/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.zeydie.skinchanger.animation.AnimatedSkinTransition;
import com.zeydie.skinchanger.handlers.PacketHandler;
import me.edoren.skin_changer.common.models.PlayerModel;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import net.minecraft.class_746;

public class LocalSkinCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"localskin").then(ClientCommandManager.literal((String)"load").then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(LocalSkinCommand::loadSkin)))).then(ClientCommandManager.literal((String)"style").then(ClientCommandManager.argument((String)"styleName", (ArgumentType)StringArgumentType.word()).executes(LocalSkinCommand::setStyle)))).then(ClientCommandManager.literal((String)"duration").then(ClientCommandManager.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(LocalSkinCommand::setDuration)))).then(ClientCommandManager.literal((String)"toggle").executes(LocalSkinCommand::toggleAnimations))).executes(LocalSkinCommand::showHelp));
    }

    private static int showHelp(CommandContext<FabricClientCommandSource> context) {
        LocalSkinCommand.sendMessage("\u00a76=== Local Skin Commands ===");
        LocalSkinCommand.sendMessage("\u00a7e/localskin load <path> \u00a77- Load skin from file path");
        LocalSkinCommand.sendMessage("\u00a7e/localskin style <style> \u00a77- Set animation style");
        LocalSkinCommand.sendMessage("\u00a77  Styles: FADE, PIXEL_DISSOLVE, WAVE, RADIAL, GLITCH");
        LocalSkinCommand.sendMessage("\u00a7e/localskin duration <ticks> \u00a77- Set animation duration (1-100 ticks)");
        LocalSkinCommand.sendMessage("\u00a7e/localskin toggle \u00a77- Toggle animations on/off");
        return 1;
    }

    private static int loadSkin(CommandContext<FabricClientCommandSource> context) {
        String filePath = StringArgumentType.getString(context, (String)"path");
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null) {
            LocalSkinCommand.sendMessage("\u00a7cNo player found!");
            return 0;
        }
        GameProfile gameProfile = player.method_7334();
        PlayerModel playerModel = new PlayerModel(gameProfile.getName(), gameProfile.getId().toString());
        boolean success = PacketHandler.loadLocalSkin(playerModel, filePath);
        if (success) {
            LocalSkinCommand.sendMessage("\u00a7aSuccessfully loaded skin from: " + filePath);
            return 1;
        }
        LocalSkinCommand.sendMessage("\u00a7cFailed to load skin! Check the file path and format.");
        return 0;
    }

    private static int setStyle(CommandContext<FabricClientCommandSource> context) {
        String styleName = StringArgumentType.getString(context, (String)"styleName").toUpperCase();
        try {
            AnimatedSkinTransition.TransitionStyle style = AnimatedSkinTransition.TransitionStyle.valueOf(styleName);
            PacketHandler.setTransitionStyle(style);
            LocalSkinCommand.sendMessage("\u00a7aAnimation style set to: \u00a7e" + style.name());
            return 1;
        }
        catch (IllegalArgumentException e) {
            LocalSkinCommand.sendMessage("\u00a7cInvalid style! Available styles:");
            for (AnimatedSkinTransition.TransitionStyle style : AnimatedSkinTransition.TransitionStyle.values()) {
                LocalSkinCommand.sendMessage("\u00a77  - " + style.name());
            }
            return 0;
        }
    }

    private static int setDuration(CommandContext<FabricClientCommandSource> context) {
        int ticks = IntegerArgumentType.getInteger(context, (String)"ticks");
        PacketHandler.setTransitionDuration(ticks);
        LocalSkinCommand.sendMessage("\u00a7aAnimation duration set to: \u00a7e" + ticks + " ticks \u00a77(" + (float)ticks / 20.0f + " seconds)");
        return 1;
    }

    private static int toggleAnimations(CommandContext<FabricClientCommandSource> context) {
        PacketHandler.toggleAnimations();
        boolean enabled = PacketHandler.isAnimationEnabled();
        LocalSkinCommand.sendMessage("\u00a7aSkin animations: " + (enabled ? "\u00a7aENABLED" : "\u00a7cDISABLED"));
        return 1;
    }

    private static void sendMessage(String message) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 != null) {
            minecraft.field_1724.method_43496((class_2561)class_2561.method_43470((String)message));
        }
    }
}

