/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.animation;

import com.google.common.collect.Maps;
import com.zeydie.skinchanger.animation.AnimatedSkinTransition;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import me.edoren.skin_changer.client.api.SkinLoaderService;
import me.edoren.skin_changer.common.models.PlayerModel;
import me.edoren.skin_changer.server.SkinProviderController;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1011;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkinTransitionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static SkinTransitionManager instance;
    private final Map<PlayerModel, AnimatedSkinTransition> activeTransitions = Maps.newHashMap();
    private final SkinLoaderService skinLoader = SkinLoaderService.GetInstance();
    private static final String SKIN_SERVER_URL = "https://skins.votive-rp.com/SKIN/STORAGE/";
    private int tickCounter = 0;
    private static final int UPDATE_INTERVAL = 2;

    private SkinTransitionManager() {
        this.registerTickHandler();
    }

    public static SkinTransitionManager getInstance() {
        if (instance == null) {
            instance = new SkinTransitionManager();
        }
        return instance;
    }

    public void startTransition(PlayerModel playerModel, byte[] oldSkinData, byte[] newSkinData, AnimatedSkinTransition.TransitionStyle style, int durationTicks) {
        if (oldSkinData == null) {
            LOGGER.info("No previous custom skin for {}, downloading from server...", (Object)playerModel.getName());
            this.loadCurrentSkinAndAnimate(playerModel, newSkinData, style, durationTicks);
            return;
        }
        this.startAnimationInternal(playerModel, oldSkinData, newSkinData, style, durationTicks);
    }

    private void startAnimationInternal(PlayerModel playerModel, byte[] oldSkinData, byte[] newSkinData, AnimatedSkinTransition.TransitionStyle style, int durationTicks) {
        LOGGER.info("Starting {} skin transition for {} (duration: {} ticks)", (Object)style, (Object)playerModel.getName(), (Object)durationTicks);
        AnimatedSkinTransition transition = new AnimatedSkinTransition(oldSkinData, newSkinData, style, durationTicks);
        this.stopTransition(playerModel);
        this.activeTransitions.put(playerModel, transition);
    }

    private void loadCurrentSkinAndAnimate(PlayerModel playerModel, byte[] newSkinData, AnimatedSkinTransition.TransitionStyle style, int durationTicks) {
        SkinProviderController controller = SkinProviderController.GetInstance();
        CompletableFuture.supplyAsync(() -> {
            try {
                String skinUrl = SKIN_SERVER_URL + playerModel.getName();
                LOGGER.info("Downloading current skin from: {}", (Object)skinUrl);
                boolean success = controller.setPlayerSkinByURL(playerModel, new URL(skinUrl), false);
                if (success) {
                    byte[] currentSkin = controller.getPlayerSkinData(playerModel).getSkin();
                    LOGGER.info("Successfully downloaded current skin from server ({} bytes)", (Object)currentSkin.length);
                    return currentSkin;
                }
                LOGGER.warn("Failed to download skin from server, will use darkened version");
                return null;
            }
            catch (Exception e) {
                LOGGER.warn("Error downloading skin from server: {}", (Object)e.getMessage());
                return null;
            }
        }).thenAcceptAsync(currentSkin -> {
            byte[] oldSkin = currentSkin;
            if (oldSkin == null) {
                LOGGER.info("Using darkened version as fallback");
                oldSkin = this.createDarkenedSkin(newSkinData);
            }
            if (oldSkin != null) {
                this.startAnimationInternal(playerModel, oldSkin, newSkinData, style, durationTicks);
            } else {
                LOGGER.warn("All methods failed, loading skin without animation");
                this.skinLoader.loadPlayerSkin(playerModel, newSkinData);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] createDarkenedSkin(byte[] skinData) {
        try (class_1011 originalImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(skinData));){
            byte[] byArray;
            try (class_1011 darkenedImage = new class_1011(originalImage.method_4307(), originalImage.method_4323(), true);){
                int b;
                int y;
                int width = originalImage.method_4307();
                int height = originalImage.method_4323();
                for (int x = 0; x < width; ++x) {
                    for (y = 0; y < height; ++y) {
                        int rgba = originalImage.method_4315(x, y);
                        int r = rgba >> 0 & 0xFF;
                        int g = rgba >> 8 & 0xFF;
                        b = rgba >> 16 & 0xFF;
                        int a = rgba >> 24 & 0xFF;
                        r = (int)((double)r * 0.3);
                        g = (int)((double)g * 0.3);
                        b = (int)((double)b * 0.3);
                        int darkened = a << 24 | b << 16 | g << 8 | r;
                        darkenedImage.method_4305(x, y, darkened);
                    }
                }
                BufferedImage bufferedImage = new BufferedImage(width, height, 2);
                for (y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int rgba = darkenedImage.method_4315(x, y);
                        int a = rgba >> 24 & 0xFF;
                        b = rgba >> 16 & 0xFF;
                        int g = rgba >> 8 & 0xFF;
                        int r = rgba >> 0 & 0xFF;
                        int argb = a << 24 | r << 16 | g << 8 | b;
                        bufferedImage.setRGB(x, y, argb);
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", baos);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create darkened skin", (Throwable)e);
            return null;
        }
    }

    public void stopTransition(PlayerModel playerModel) {
        this.activeTransitions.remove(playerModel);
    }

    public boolean hasActiveTransition(PlayerModel playerModel) {
        return this.activeTransitions.containsKey(playerModel);
    }

    public void clearAll() {
        this.activeTransitions.clear();
        LOGGER.info("Cleared all active skin transitions");
    }

    private void registerTickHandler() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (this.activeTransitions.isEmpty()) {
                return;
            }
            ++this.tickCounter;
            if (this.tickCounter < 2) {
                return;
            }
            this.tickCounter = 0;
            this.activeTransitions.entrySet().removeIf(entry -> {
                PlayerModel playerModel = (PlayerModel)entry.getKey();
                AnimatedSkinTransition transition = (AnimatedSkinTransition)entry.getValue();
                try {
                    byte[] frameData = transition.tick();
                    this.skinLoader.loadPlayerSkin(playerModel, frameData);
                    if (transition.isCompleted()) {
                        LOGGER.info("Completed skin transition for {}", (Object)playerModel.getName());
                        return true;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error updating skin transition for {}", (Object)playerModel.getName(), (Object)e);
                    return true;
                }
                return false;
            });
        });
    }
}

