/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.animation;

import com.google.common.collect.Maps;
import com.zeydie.skinchanger.animation.DemonVisibilityTransition;
import com.zeydie.skinchanger.textures.VisibilityTextureManager;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.edoren.skin_changer.client.api.ISkin;
import me.edoren.skin_changer.client.api.SkinLoaderService;
import me.edoren.skin_changer.common.models.PlayerModel;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerVisibilityManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static PlayerVisibilityManager instance;
    private final Map<PlayerModel, DemonVisibilityTransition> activeTransitions = Maps.newHashMap();
    private final Map<PlayerModel, byte[]> originalSkins = Maps.newHashMap();
    private final Map<PlayerModel, byte[]> currentFrameRefs = Maps.newHashMap();
    private final Map<PlayerModel, ByteBuffer> byteBufferRefs = Maps.newHashMap();
    private final Map<PlayerModel, ISkin> skinRefs = Maps.newHashMap();
    private final SkinLoaderService skinLoader = SkinLoaderService.GetInstance();

    private PlayerVisibilityManager() {
        this.registerTickHandler();
    }

    public static PlayerVisibilityManager getInstance() {
        if (instance == null) {
            instance = new PlayerVisibilityManager();
        }
        return instance;
    }

    public void hidePlayer(PlayerModel playerModel, byte[] skinData, String hexColor, String mode, int durationTicks) {
        LOGGER.info("Starting hide animation for {} (color: #{}, mode: {}, duration: {} ticks)", (Object)playerModel.getName(), (Object)hexColor, (Object)mode, (Object)durationTicks);
        this.originalSkins.put(playerModel, skinData);
        DemonVisibilityTransition transition = new DemonVisibilityTransition(skinData, true, hexColor, mode, durationTicks);
        this.activeTransitions.put(playerModel, transition);
    }

    public void showPlayer(PlayerModel playerModel, String hexColor, String mode, int durationTicks) {
        this.showPlayer(playerModel, null, hexColor, mode, durationTicks);
    }

    public void showPlayer(PlayerModel playerModel, byte[] skinData, String hexColor, String mode, int durationTicks) {
        if (skinData != null) {
            this.originalSkins.put(playerModel, skinData);
        } else {
            skinData = this.originalSkins.get(playerModel);
        }
        if (skinData == null) {
            LOGGER.warn("No original skin data for {}, cannot show", (Object)playerModel.getName());
            return;
        }
        LOGGER.info("Starting show animation for {} (color: #{}, mode: {}, duration: {} ticks)", (Object)playerModel.getName(), (Object)hexColor, (Object)mode, (Object)durationTicks);
        DemonVisibilityTransition transition = new DemonVisibilityTransition(skinData, false, hexColor, mode, durationTicks);
        this.activeTransitions.put(playerModel, transition);
    }

    public boolean hasActiveTransition(PlayerModel playerModel) {
        return this.activeTransitions.containsKey(playerModel);
    }

    public void clearAll() {
        this.activeTransitions.clear();
        this.originalSkins.clear();
        this.currentFrameRefs.clear();
        this.byteBufferRefs.clear();
        this.skinRefs.clear();
        VisibilityTextureManager.getInstance().clearAll();
        LOGGER.info("Cleared all visibility transitions");
    }

    private void registerTickHandler() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (this.activeTransitions.isEmpty()) {
                return;
            }
            this.activeTransitions.entrySet().removeIf(entry -> {
                PlayerModel playerModel = (PlayerModel)entry.getKey();
                DemonVisibilityTransition transition = (DemonVisibilityTransition)entry.getValue();
                try {
                    byte[] frameData = transition.tick();
                    if (frameData == null) {
                        LOGGER.error("Frame data is NULL for {}! This causes flashing!", (Object)playerModel.getName());
                        return true;
                    }
                    this.currentFrameRefs.put(playerModel, frameData);
                    VisibilityTextureManager visibilityTexManager = VisibilityTextureManager.getInstance();
                    class_2960 texLocation = visibilityTexManager.loadVisibilityFrame(playerModel, frameData);
                    if (texLocation == null) {
                        LOGGER.error("Failed to load visibility texture for {}!", (Object)playerModel.getName());
                    }
                    this.currentFrameRefs.put(playerModel, frameData);
                    if (transition.isCompleted()) {
                        LOGGER.info("Completed demon visibility animation for {}", (Object)playerModel.getName());
                        CompletableFuture.runAsync(() -> {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            this.currentFrameRefs.remove(playerModel);
                            this.byteBufferRefs.remove(playerModel);
                            this.skinRefs.remove(playerModel);
                            VisibilityTextureManager.getInstance().clearTexture(playerModel);
                        });
                        return true;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error updating visibility transition for {}", (Object)playerModel.getName(), (Object)e);
                    this.currentFrameRefs.remove(playerModel);
                    this.byteBufferRefs.remove(playerModel);
                    this.skinRefs.remove(playerModel);
                    VisibilityTextureManager.getInstance().clearTexture(playerModel);
                    return true;
                }
                return false;
            });
        });
    }
}

