/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.animation;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import lombok.Generated;
import me.edoren.skin_changer.common.SharedPool;
import net.minecraft.class_1011;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DemonVisibilityTransition {
    private static final Logger LOGGER = LogManager.getLogger();
    private final byte[] skinData;
    private final boolean isHiding;
    private final int duration;
    private final int effectColorR;
    private final int effectColorG;
    private final int effectColorB;
    private final boolean randomMode;
    private int currentTick = 0;
    private boolean completed = false;
    private byte[] currentFrame = null;
    private final Map<Integer, byte[]> frameCache = new ConcurrentHashMap<Integer, byte[]>();
    private volatile boolean pregenerationComplete = false;

    public DemonVisibilityTransition(byte[] skinData, boolean isHiding, String hexColor, String mode, int durationTicks) {
        this.skinData = skinData;
        this.isHiding = isHiding;
        this.duration = Math.max(1, durationTicks);
        try {
            this.effectColorR = Integer.parseInt(hexColor.substring(0, 2), 16);
            this.effectColorG = Integer.parseInt(hexColor.substring(2, 4), 16);
            this.effectColorB = Integer.parseInt(hexColor.substring(4, 6), 16);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid hex color: " + hexColor, e);
        }
        this.randomMode = mode.equalsIgnoreCase("random");
        try {
            class_1011 skinImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(skinData));
            this.currentFrame = this.generateDemonFrame(skinImage, 0.01f);
            this.frameCache.put(1, this.currentFrame);
            skinImage.close();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to generate initial frame, will use original", (Throwable)e);
            this.currentFrame = skinData;
        }
        this.startPregeneration();
    }

    private void startPregeneration() {
        CompletableFuture.runAsync(() -> {
            LOGGER.info("Pregenerating {} frames for demon {} animation...", (Object)this.duration, (Object)(this.isHiding ? "hide" : "show"));
            long startTime = System.currentTimeMillis();
            class_1011 skinImage = null;
            try {
                skinImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(this.skinData));
                for (int tick = 1; tick <= this.duration; ++tick) {
                    float progress = (float)tick / (float)this.duration;
                    byte[] frame = this.generateDemonFrame(skinImage, progress);
                    this.frameCache.put(tick, frame);
                }
                this.pregenerationComplete = true;
                long elapsed = System.currentTimeMillis() - startTime;
                LOGGER.info("Demon animation pregeneration complete! {} frames in {}ms", (Object)this.duration, (Object)elapsed);
            }
            catch (Exception e) {
                LOGGER.error("Error during demon animation pregeneration", (Throwable)e);
            }
            finally {
                if (skinImage != null) {
                    try {
                        skinImage.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }, SharedPool.get());
    }

    public byte[] tick() {
        if (this.completed) {
            return this.currentFrame != null ? this.currentFrame : this.skinData;
        }
        if (!this.pregenerationComplete) {
            return this.currentFrame;
        }
        ++this.currentTick;
        float progress = Math.min(1.0f, (float)this.currentTick / (float)this.duration);
        try {
            byte[] nextFrame = this.frameCache.get(this.currentTick);
            if (nextFrame != null) {
                this.currentFrame = nextFrame;
            } else if (this.currentFrame == null) {
                for (int offset = -2; offset <= 2; ++offset) {
                    nextFrame = this.frameCache.get(this.currentTick + offset);
                    if (nextFrame == null) continue;
                    this.currentFrame = nextFrame;
                    break;
                }
            }
            if (progress >= 1.0f) {
                this.completed = true;
                this.frameCache.clear();
            }
            return this.currentFrame != null ? this.currentFrame : this.skinData;
        }
        catch (Exception e) {
            LOGGER.error("Error in demon visibility animation", (Throwable)e);
            this.completed = true;
            return this.currentFrame != null ? this.currentFrame : this.skinData;
        }
    }

    private byte[] generateDemonFrame(class_1011 skinImage, float progress) throws Exception {
        int width = skinImage.method_4307();
        int height = skinImage.method_4323();
        try (class_1011 resultImage = new class_1011(width, height, true);){
            Random random = new Random((int)(progress * 1000.0f));
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    boolean isOnEdge;
                    boolean shouldBeTransparent;
                    int originalColor = skinImage.method_4315(x, y);
                    int r = originalColor >> 0 & 0xFF;
                    int g = originalColor >> 8 & 0xFF;
                    int b = originalColor >> 16 & 0xFF;
                    int a = originalColor >> 24 & 0xFF;
                    if (a == 0) {
                        resultImage.method_4305(x, y, 0);
                        continue;
                    }
                    float pixelProgress = this.getPixelProgressWithOverlay(x, y, width, height);
                    if (!this.isHiding) {
                        pixelProgress = 1.0f - pixelProgress;
                    }
                    float distanceFromEdge = progress - pixelProgress;
                    if (this.isHiding) {
                        shouldBeTransparent = distanceFromEdge > 0.08f;
                        isOnEdge = distanceFromEdge > 0.0f && distanceFromEdge <= 0.08f;
                    } else {
                        shouldBeTransparent = distanceFromEdge < -0.08f;
                        boolean bl = isOnEdge = distanceFromEdge >= -0.08f && distanceFromEdge < 0.0f;
                    }
                    if (shouldBeTransparent) {
                        resultImage.method_4305(x, y, 0);
                        continue;
                    }
                    if (isOnEdge) {
                        float edgeIntensity = this.isHiding ? 1.0f - distanceFromEdge / 0.08f : 1.0f - Math.abs(distanceFromEdge) / 0.08f;
                        if (this.randomMode) {
                            float flameChance = edgeIntensity * 0.85f;
                            if (random.nextFloat() < flameChance) {
                                float colorVariation = 0.7f + random.nextFloat() * 0.3f;
                                int fireR = (int)((float)this.effectColorR * colorVariation);
                                int fireG = (int)((float)this.effectColorG * colorVariation);
                                int fireB = (int)((float)this.effectColorB * colorVariation);
                                int fireA = Math.max(100, (int)((float)a * (0.4f + edgeIntensity * 0.6f)));
                                int fireColor = fireA << 24 | fireB << 16 | fireG << 8 | fireR;
                                resultImage.method_4305(x, y, fireColor);
                                continue;
                            }
                            int fadedA = (int)((float)a * edgeIntensity * 0.5f);
                            int fadedColor = fadedA << 24 | b / 2 << 16 | g / 2 << 8 | r / 2;
                            resultImage.method_4305(x, y, fadedColor);
                            continue;
                        }
                        int fireR = (int)((float)r * 0.3f + (float)this.effectColorR * edgeIntensity * 0.7f);
                        int fireG = (int)((float)g * 0.3f + (float)this.effectColorG * edgeIntensity * 0.7f);
                        int fireB = (int)((float)b * 0.3f + (float)this.effectColorB * edgeIntensity * 0.7f);
                        int fireA = Math.max(128, (int)((float)a * (0.5f + edgeIntensity * 0.5f)));
                        int fireColor = fireA << 24 | fireB << 16 | fireG << 8 | fireR;
                        resultImage.method_4305(x, y, fireColor);
                        continue;
                    }
                    resultImage.method_4305(x, y, originalColor);
                }
            }
            byte[] byArray = this.imageToBytes(resultImage);
            return byArray;
        }
    }

    private float getPixelProgressWithOverlay(int x, int y, int width, int height) {
        float ny;
        float nx = (float)x / (float)width * 64.0f;
        float unifiedY = ny = (float)y / (float)height * 64.0f;
        if (ny >= 16.0f && ny < 32.0f && nx >= 0.0f && nx < 16.0f) {
            unifiedY = ny - 16.0f + 32.0f;
        } else if (ny >= 32.0f && ny < 48.0f && nx >= 0.0f && nx < 16.0f) {
            unifiedY = ny;
        } else if (ny >= 48.0f && ny < 64.0f && nx >= 16.0f && nx < 32.0f) {
            unifiedY = ny - 48.0f + 32.0f;
        } else if (ny >= 48.0f && ny < 64.0f && nx >= 0.0f && nx < 16.0f) {
            unifiedY = ny - 48.0f + 32.0f;
        } else if (ny >= 32.0f && ny < 48.0f && nx >= 16.0f && nx < 40.0f) {
            unifiedY = ny - 16.0f;
        } else if (ny >= 32.0f && ny < 48.0f && nx >= 40.0f && nx < 56.0f) {
            unifiedY = ny - 16.0f;
        } else if (ny >= 48.0f && ny < 64.0f && nx >= 32.0f && nx < 64.0f) {
            unifiedY = ny - 48.0f + 16.0f;
        }
        return unifiedY / 64.0f;
    }

    private byte[] imageToBytes(class_1011 image) throws Exception {
        int width = image.method_4307();
        int height = image.method_4323();
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgba = image.method_4315(x, y);
                int a = rgba >> 24 & 0xFF;
                int b = rgba >> 16 & 0xFF;
                int g = rgba >> 8 & 0xFF;
                int r = rgba >> 0 & 0xFF;
                int argb = a << 24 | r << 16 | g << 8 | b;
                bufferedImage.setRGB(x, y, argb);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", baos);
        return baos.toByteArray();
    }

    @Generated
    public boolean isCompleted() {
        return this.completed;
    }

    @Generated
    public byte[] getCurrentFrame() {
        return this.currentFrame;
    }
}

