/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.animation;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import lombok.Generated;
import me.edoren.skin_changer.common.SharedPool;
import net.minecraft.class_1011;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnimatedSkinTransition {
    private static final Logger LOGGER = LogManager.getLogger();
    private final byte[] oldSkinData;
    private final byte[] newSkinData;
    private final TransitionStyle style;
    private final int duration;
    private int currentTick = 0;
    private boolean completed = false;
    private byte[] currentFrame = null;
    private final Map<Integer, byte[]> frameCache = new HashMap<Integer, byte[]>();
    private boolean pregenerating = false;
    private boolean pregenerationComplete = false;

    public AnimatedSkinTransition(byte[] oldSkinData, byte[] newSkinData, TransitionStyle style, int durationTicks) {
        this.oldSkinData = oldSkinData;
        this.newSkinData = newSkinData;
        this.style = style;
        this.duration = Math.max(1, durationTicks);
        this.startPregeneration();
    }

    private void startPregeneration() {
        this.pregenerating = true;
        CompletableFuture.runAsync(() -> {
            LOGGER.info("Pregenerating {} frames for {} animation...", (Object)this.duration, (Object)this.style);
            long startTime = System.currentTimeMillis();
            class_1011 oldImageTemp = null;
            class_1011 newImageTemp = null;
            try {
                oldImageTemp = class_1011.method_4309((InputStream)new ByteArrayInputStream(this.oldSkinData));
                newImageTemp = class_1011.method_4309((InputStream)new ByteArrayInputStream(this.newSkinData));
                LOGGER.info("Decoded source images, generating frames...");
                for (int tick = 1; tick <= this.duration; ++tick) {
                    float linearProgress = Math.min(1.0f, (float)tick / (float)this.duration);
                    float progress = this.easeInOutQuad(linearProgress);
                    byte[] frame = this.generateFrameWithImages(oldImageTemp, newImageTemp, progress);
                    this.frameCache.put(tick, frame);
                }
                this.pregenerationComplete = true;
                long elapsed = System.currentTimeMillis() - startTime;
                LOGGER.info("Pregeneration complete! {} frames in {}ms ({} ms/frame)", (Object)this.duration, (Object)elapsed, (Object)(elapsed / (long)this.duration));
            }
            catch (Exception e) {
                LOGGER.error("Error during frame pregeneration", (Throwable)e);
                this.pregenerationComplete = false;
            }
            finally {
                if (oldImageTemp != null) {
                    try {
                        oldImageTemp.close();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error closing old image", (Throwable)e);
                    }
                }
                if (newImageTemp != null) {
                    try {
                        newImageTemp.close();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error closing new image", (Throwable)e);
                    }
                }
                this.pregenerating = false;
            }
        }, SharedPool.get());
    }

    public byte[] tick() {
        if (this.completed) {
            return this.newSkinData;
        }
        ++this.currentTick;
        float linearProgress = Math.min(1.0f, (float)this.currentTick / (float)this.duration);
        float progress = this.easeInOutQuad(linearProgress);
        try {
            if (this.frameCache.containsKey(this.currentTick)) {
                this.currentFrame = this.frameCache.get(this.currentTick);
            } else {
                this.currentFrame = this.generateFrame(progress);
                this.frameCache.put(this.currentTick, this.currentFrame);
            }
            if (linearProgress >= 1.0f) {
                this.completed = true;
                this.frameCache.clear();
            }
            return this.currentFrame;
        }
        catch (Exception e) {
            LOGGER.error("Error generating transition frame", (Throwable)e);
            this.completed = true;
            this.frameCache.clear();
            return this.newSkinData;
        }
    }

    private float easeInOutQuad(float t) {
        if (t < 0.5f) {
            return 2.0f * t * t;
        }
        return 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 2.0) / 2.0f;
    }

    private byte[] generateFrameWithImages(class_1011 oldImage, class_1011 newImage, float progress) throws IOException {
        try (class_1011 resultImage = new class_1011(newImage.method_4307(), newImage.method_4323(), true);){
            int width = resultImage.method_4307();
            int height = resultImage.method_4323();
            switch (this.style) {
                case FADE: {
                    this.generateFadeFrame(oldImage, newImage, resultImage, progress);
                    break;
                }
                case PIXEL_DISSOLVE: {
                    this.generatePixelDissolveFrame(oldImage, newImage, resultImage, progress);
                    break;
                }
                case WAVE: {
                    this.generateWaveFrame(oldImage, newImage, resultImage, progress);
                    break;
                }
                case RADIAL: {
                    this.generateRadialFrame(oldImage, newImage, resultImage, progress);
                    break;
                }
                case GLITCH: {
                    this.generateGlitchFrame(oldImage, newImage, resultImage, progress);
                    break;
                }
                default: {
                    this.generateFadeFrame(oldImage, newImage, resultImage, progress);
                }
            }
            byte[] byArray = this.imageToBytes(resultImage);
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] generateFrame(float progress) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateFadeFrame(class_1011 oldImage, class_1011 newImage, class_1011 result, float progress) {
        int width = result.method_4307();
        int height = result.method_4323();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int oldColor = this.getScaledPixel(oldImage, x, y, width, height);
                int newColor = this.getScaledPixel(newImage, x, y, width, height);
                int blended = this.blendColors(oldColor, newColor, progress);
                result.method_4305(x, y, blended);
            }
        }
    }

    private void generatePixelDissolveFrame(class_1011 oldImage, class_1011 newImage, class_1011 result, float progress) {
        int width = result.method_4307();
        int height = result.method_4323();
        Random random = new Random(42L);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                float pixelThreshold = random.nextFloat();
                int color = progress > pixelThreshold ? this.getScaledPixel(newImage, x, y, width, height) : this.getScaledPixel(oldImage, x, y, width, height);
                result.method_4305(x, y, color);
            }
        }
    }

    private void generateWaveFrame(class_1011 oldImage, class_1011 newImage, class_1011 result, float progress) {
        int width = result.method_4307();
        int height = result.method_4323();
        for (int y = 0; y < height; ++y) {
            float waveOffset = (float)Math.sin((float)y * 0.2f + (float)this.currentTick * 0.3f) * 0.1f;
            float normalizedY = (float)y / (float)height;
            float lineProgress = progress - normalizedY * (1.0f - progress) + waveOffset;
            lineProgress = Math.max(0.0f, Math.min(1.0f, lineProgress));
            for (int x = 0; x < width; ++x) {
                int oldColor = this.getScaledPixel(oldImage, x, y, width, height);
                int newColor = this.getScaledPixel(newImage, x, y, width, height);
                int blended = this.blendColors(oldColor, newColor, lineProgress);
                result.method_4305(x, y, blended);
            }
        }
    }

    private void generateRadialFrame(class_1011 oldImage, class_1011 newImage, class_1011 result, float progress) {
        int width = result.method_4307();
        int height = result.method_4323();
        float centerX = (float)width / 2.0f;
        float centerY = (float)height / 2.0f;
        float maxDistance = (float)Math.sqrt(centerX * centerX + centerY * centerY);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float dx = (float)x - centerX;
                float dy = (float)y - centerY;
                float distance = (float)Math.sqrt(dx * dx + dy * dy);
                float normalizedDistance = distance / maxDistance;
                float pixelProgress = progress - normalizedDistance * (1.0f - progress);
                pixelProgress = Math.max(0.0f, Math.min(1.0f, pixelProgress));
                int oldColor = this.getScaledPixel(oldImage, x, y, width, height);
                int newColor = this.getScaledPixel(newImage, x, y, width, height);
                int blended = this.blendColors(oldColor, newColor, pixelProgress);
                result.method_4305(x, y, blended);
            }
        }
    }

    private void generateGlitchFrame(class_1011 oldImage, class_1011 newImage, class_1011 result, float progress) {
        int width = result.method_4307();
        int height = result.method_4323();
        Random random = new Random(this.currentTick);
        float glitchIntensity = 1.0f - progress;
        for (int y = 0; y < height; ++y) {
            int shift = random.nextFloat() < glitchIntensity * 0.3f ? random.nextInt(width / 4) - width / 8 : 0;
            boolean useNew = random.nextFloat() < progress + 0.2f;
            for (int x = 0; x < width; ++x) {
                int sourceX = (x + shift + width) % width;
                int color = useNew ? this.getScaledPixel(newImage, sourceX, y, width, height) : this.getScaledPixel(oldImage, sourceX, y, width, height);
                if (random.nextFloat() < glitchIntensity * 0.1f) {
                    int r = color >> 0 & 0xFF;
                    int g = color >> 8 & 0xFF;
                    int b = color >> 16 & 0xFF;
                    int a = color >> 24 & 0xFF;
                    color = a << 24 | r << 16 | b << 8 | g;
                }
                result.method_4305(x, y, color);
            }
        }
    }

    private int getScaledPixel(class_1011 image, int x, int y, int targetWidth, int targetHeight) {
        int srcX = x * image.method_4307() / targetWidth;
        int srcY = y * image.method_4323() / targetHeight;
        return image.method_4315(srcX, srcY);
    }

    private int blendColors(int color1, int color2, float progress) {
        if (progress >= 0.995f) {
            return color2;
        }
        int r1 = color1 >> 0 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 >> 16 & 0xFF;
        int a1 = color1 >> 24 & 0xFF;
        int r2 = color2 >> 0 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 >> 16 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * progress);
        int g = (int)((float)g1 + (float)(g2 - g1) * progress);
        int b = (int)((float)b1 + (float)(b2 - b1) * progress);
        int a = (int)((float)a1 + (float)(a2 - a1) * progress);
        return a << 24 | b << 16 | g << 8 | r;
    }

    private byte[] imageToBytes(class_1011 image) throws IOException {
        int width = image.method_4307();
        int height = image.method_4323();
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgba = image.method_4315(x, y);
                int a = rgba >> 24 & 0xFF;
                int b = rgba >> 16 & 0xFF;
                int g = rgba >> 8 & 0xFF;
                int r = rgba >> 0 & 0xFF;
                int argb = a << 24 | r << 16 | g << 8 | b;
                bufferedImage.setRGB(x, y, argb);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", baos);
        return baos.toByteArray();
    }

    @Generated
    public byte[] getOldSkinData() {
        return this.oldSkinData;
    }

    @Generated
    public byte[] getNewSkinData() {
        return this.newSkinData;
    }

    @Generated
    public TransitionStyle getStyle() {
        return this.style;
    }

    @Generated
    public boolean isCompleted() {
        return this.completed;
    }

    @Generated
    public byte[] getCurrentFrame() {
        return this.currentFrame;
    }

    public static enum TransitionStyle {
        FADE,
        PIXEL_DISSOLVE,
        WAVE,
        RADIAL,
        GLITCH;

    }
}

