/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger.alpha;

import com.google.common.collect.Maps;
import com.zeydie.skinchanger.textures.VisibilityTextureManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import me.edoren.skin_changer.client.api.SkinLoaderService;
import me.edoren.skin_changer.common.models.PlayerModel;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1011;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerAlphaManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static PlayerAlphaManager instance;
    private final Map<PlayerModel, Integer> playerAlphas = Maps.newHashMap();
    private final Map<PlayerModel, byte[]> originalSkins = Maps.newHashMap();
    private final Map<String, byte[]> alphaCache = new ConcurrentHashMap<String, byte[]>();
    private final SkinLoaderService skinLoader = SkinLoaderService.GetInstance();

    private PlayerAlphaManager() {
        this.registerTickHandler();
    }

    public static PlayerAlphaManager getInstance() {
        if (instance == null) {
            instance = new PlayerAlphaManager();
        }
        return instance;
    }

    public void setPlayerAlpha(PlayerModel playerModel, byte[] skinData, int alpha) {
        alpha = Math.max(0, Math.min(255, alpha));
        LOGGER.info("Setting alpha for {}: {}", (Object)playerModel.getName(), (Object)alpha);
        if (!this.originalSkins.containsKey(playerModel)) {
            this.originalSkins.put(playerModel, skinData);
        }
        this.playerAlphas.put(playerModel, alpha);
        this.applyAlpha(playerModel);
    }

    public void resetPlayer(PlayerModel playerModel) {
        LOGGER.info("Resetting alpha for {}", (Object)playerModel.getName());
        this.playerAlphas.remove(playerModel);
        this.originalSkins.remove(playerModel);
        VisibilityTextureManager.getInstance().clearTexture(playerModel);
    }

    public boolean hasAlpha(PlayerModel playerModel) {
        return this.playerAlphas.containsKey(playerModel);
    }

    public Integer getAlpha(PlayerModel playerModel) {
        return this.playerAlphas.get(playerModel);
    }

    private void applyAlpha(PlayerModel playerModel) {
        Integer alpha = this.playerAlphas.get(playerModel);
        byte[] skinData = this.originalSkins.get(playerModel);
        if (alpha == null || skinData == null) {
            return;
        }
        try {
            String cacheKey = playerModel.getId() + "_" + alpha;
            byte[] alphaSkin = this.alphaCache.get(cacheKey);
            if (alphaSkin == null) {
                alphaSkin = this.generateAlphaSkin(skinData, alpha);
                this.alphaCache.put(cacheKey, alphaSkin);
            }
            VisibilityTextureManager visibilityTexManager = VisibilityTextureManager.getInstance();
            visibilityTexManager.loadVisibilityFrame(playerModel, alphaSkin);
        }
        catch (Exception e) {
            LOGGER.error("Error applying alpha to {}", (Object)playerModel.getName(), (Object)e);
        }
    }

    private byte[] generateAlphaSkin(byte[] skinData, int targetAlpha) throws Exception {
        try (class_1011 skinImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(skinData));){
            byte[] byArray;
            try (class_1011 resultImage = new class_1011(skinImage.method_4307(), skinImage.method_4323(), true);){
                int b;
                int width = skinImage.method_4307();
                int height = skinImage.method_4323();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int originalColor = skinImage.method_4315(x, y);
                        int r = originalColor >> 0 & 0xFF;
                        int g = originalColor >> 8 & 0xFF;
                        b = originalColor >> 16 & 0xFF;
                        int a = originalColor >> 24 & 0xFF;
                        if (a == 0) {
                            resultImage.method_4305(x, y, 0);
                            continue;
                        }
                        int newAlpha = (int)((float)a * (float)targetAlpha / 255.0f);
                        int newColor = newAlpha << 24 | b << 16 | g << 8 | r;
                        resultImage.method_4305(x, y, newColor);
                    }
                }
                BufferedImage bufferedImage = new BufferedImage(width, height, 2);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int rgba = resultImage.method_4315(x, y);
                        int a = rgba >> 24 & 0xFF;
                        b = rgba >> 16 & 0xFF;
                        int g = rgba >> 8 & 0xFF;
                        int r = rgba >> 0 & 0xFF;
                        int argb = a << 24 | r << 16 | g << 8 | b;
                        bufferedImage.setRGB(x, y, argb);
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", baos);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    private void registerTickHandler() {
        int[] tickCounter = new int[]{0};
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (this.playerAlphas.isEmpty()) {
                return;
            }
            tickCounter[0] = tickCounter[0] + 1;
            if (tickCounter[0] < 20) {
                return;
            }
            tickCounter[0] = 0;
            for (PlayerModel player : this.playerAlphas.keySet()) {
                this.applyAlpha(player);
            }
        });
    }

    public void clearAll() {
        for (PlayerModel player : this.playerAlphas.keySet()) {
            this.resetPlayer(player);
        }
        this.playerAlphas.clear();
        this.originalSkins.clear();
        this.alphaCache.clear();
        LOGGER.info("Cleared all alpha states");
    }
}

