/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.skinchanger;

import com.mojang.brigadier.CommandDispatcher;
import com.zeydie.skinchanger.commands.LocalSkinCommand;
import com.zeydie.skinchanger.commands.SkinLibraryCommand;
import com.zeydie.skinchanger.library.SkinLibrary;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkinChangerClient
implements ClientModInitializer {
    private static final Logger LOGGER = LogManager.getLogger((String)"SkinChangerClient");

    public void onInitializeClient() {
        LOGGER.info("Initializing SkinChanger client features...");
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            LocalSkinCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher, registryAccess);
            SkinLibraryCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher, registryAccess);
            LOGGER.info("Registered local skin and library commands");
        });
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            LOGGER.info("Client started, loading bundled skins...");
            try {
                SkinLibrary.getInstance().loadSkinsFromResources();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load bundled skins", (Throwable)e);
            }
        });
        LOGGER.info("SkinChanger client initialized successfully!");
    }
}

