/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorRegistry;
import com.misterpemodder.shulkerboxtooltip.impl.color.ColorRegistryImpl;
import com.misterpemodder.shulkerboxtooltip.impl.config.ConfigurationHandler;
import com.misterpemodder.shulkerboxtooltip.impl.config.annotation.AutoTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.annotation.Validator;
import com.misterpemodder.shulkerboxtooltip.impl.config.validators.GreaterThanZero;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Config(name="shulkerboxtooltip")
@Config.Gui.Background(value="minecraft:textures/block/purpur_block.png")
public final class Configuration
implements ConfigData {
    @ConfigEntry.Category(value="preview")
    @ConfigEntry.Gui.TransitiveObject
    public PreviewCategory preview = new PreviewCategory();
    @ConfigEntry.Category(value="tooltip")
    @ConfigEntry.Gui.TransitiveObject
    public TooltipCategory tooltip = new TooltipCategory();
    @ConfigEntry.Category(value="colors")
    @ConfigEntry.Gui.TransitiveObject
    @Environment(value=EnvType.CLIENT)
    public ColorsCategory colors;
    @ConfigEntry.Category(value="controls")
    @ConfigEntry.Gui.TransitiveObject
    @Environment(value=EnvType.CLIENT)
    public ControlsCategory controls;
    @ConfigEntry.Category(value="server")
    @ConfigEntry.Gui.TransitiveObject
    public ServerCategory server;

    public Configuration() {
        if (ShulkerBoxTooltip.isClient()) {
            this.colors = new ColorsCategory();
            this.controls = new ControlsCategory();
        }
        this.server = new ServerCategory();
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        ConfigurationHandler.validate(this);
    }

    public static class PreviewCategory
    implements Cloneable {
        @AutoTooltip
        @Comment(value="Toggles the shulker box preview.\n(default value: true)")
        public boolean enable = true;
        @AutoTooltip
        @Comment(value="Swaps the preview modes.\nIf true, pressing the preview key will show the full preview instead.\n(default value: false)")
        public boolean swapModes = false;
        @AutoTooltip
        @Comment(value="If on, the preview is always displayed, regardless of the preview key being pressed.\n(default value: false)")
        public boolean alwaysOn = false;
        @AutoTooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        @Comment(value="In compact mode, how should items with the same ID but different NBT data be compacted?\nIGNORE: Ignores NBT data\nFIRST_ITEM: Items are displayed as all having the same NBT as the first item\nSEPARATE: Separates items with different NBT data\n(default value: SEPARATE)")
        public CompactPreviewNbtBehavior compactPreviewNbtBehavior = CompactPreviewNbtBehavior.SEPARATE;
        @AutoTooltip
        @Validator(value=GreaterThanZero.class)
        @Comment(value="The max number of items in a row.\nMay not affect modded containers.\n(default value: 9)")
        public int defaultMaxRowSize = 9;
        @AutoTooltip
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="If on, the client will try to send packets to servers to allow extra preview information such as ender chest previews.\n(default value: true)\n")
        public boolean serverIntegration = true;
        @AutoTooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        @Comment(value="The theme to use for preview windows.\nMOD_LIGHT: ShulkerBoxTooltip's style with vanilla colors.\nMOD_DARK: ShulkerBoxTooltip's style with gray preview windows instead of white.\nVANILLA: Mimics the style of vanilla bundle previews.\n(default value: MOD_LIGHT)")
        public Theme theme = Theme.MOD_LIGHT;
        @AutoTooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        @Comment(value="The position of the preview window.\nINSIDE: Inside the item's tooltip.\nOUTSIDE: Outside the item's tooltip, moves depending on the screen borders.\nOUTSIDE_TOP: Always at the top of the item's tooltip.\nOUTSIDE_BOTTOM: Always at the bottom of the item's tooltip.\n(default value: INSIDE)")
        public PreviewPosition position = PreviewPosition.INSIDE;
        @AutoTooltip
        @Comment(value="If on, large item counts in compact previews will be shortened.\n(default value: true)")
        public boolean shortItemCounts = true;

        protected static PreviewCategory copyFrom(PreviewCategory source) {
            try {
                return (PreviewCategory)source.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class TooltipCategory
    implements Cloneable {
        @AutoTooltip
        @Comment(value="Controls whether the key hints in the container's tooltip should be displayed.\n(default value: true)")
        public boolean showKeyHints = true;
        @AutoTooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        @Comment(value="The tooltip to use.\nVANILLA: The vanilla tooltip (shows the first 5 items)\nMOD: The mod's tooltip\nNONE: No tooltip\n(default value: MOD)")
        public ShulkerBoxTooltipType type = ShulkerBoxTooltipType.MOD;
        @AutoTooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        @Comment(value="Shows info about the current loot table of the item if present.\nVisible only when Tooltip Type is set to Modded.\nHIDE: No loot table info, default.\nSIMPLE: Displays whether the stack uses a loot table.\nADVANCED: Shows the loot table used by the item.\n(default value: HIDE)")
        public LootTableInfoType lootTableInfoType = LootTableInfoType.HIDE;
        @AutoTooltip
        @Comment(value="If on, the mod hides the custom text on shulker box tooltips.\nUse this option when a server-side preview data pack clashes with the mod.\n(default value: false)")
        public boolean hideShulkerBoxLore = false;

        protected static TooltipCategory copyFrom(TooltipCategory source) {
            try {
                return (TooltipCategory)source.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ColorsCategory
    implements Cloneable {
        @AutoTooltip
        @Comment(value="Controls whether the preview window should be colored.\n(default value: true)")
        public boolean coloredPreview = true;
        public ColorRegistry colors = ColorRegistryImpl.INSTANCE;

        protected static ColorsCategory copyFrom(ColorsCategory source) {
            if (source == null) {
                return null;
            }
            try {
                return (ColorsCategory)source.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ControlsCategory
    implements Cloneable {
        @AutoTooltip
        @Comment(value="Press this key when hovering a container stack to open the preview window.\n(default value: key.keyboard.left.shift)")
        public Key previewKey = Key.defaultPreviewKey();
        @AutoTooltip
        @Comment(value="Press this key when hovering a container stack to open the full preview window.\n(default value: key.keyboard.left.alt)")
        public Key fullPreviewKey = Key.defaultFullPreviewKey();

        protected static ControlsCategory copyFrom(ControlsCategory source) {
            if (source == null) {
                return null;
            }
            try {
                return (ControlsCategory)source.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ServerCategory
    implements Cloneable {
        @AutoTooltip
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="If on, the server will be able to provide extra information about containers to the clients with the mod installed.\nDisabling this option will disable all of the options below.\n(default value: true)\n")
        public boolean clientIntegration = true;
        @AutoTooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Changes the way the ender chest content preview is synchronized.\nNONE: No synchronization, prevents clients from seeing a preview of their ender chest.\nACTIVE: Ender chest contents are synchronized when changed.\nPASSIVE: Ender chest contents are synchronized when the client opens a preview.\n(default value: ACTIVE)")
        public EnderChestSyncType enderChestSyncType = EnderChestSyncType.ACTIVE;

        protected static ServerCategory copyFrom(ServerCategory source) {
            try {
                return (ServerCategory)source.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum EnderChestSyncType {
        NONE,
        ACTIVE,
        PASSIVE;


        public String toString() {
            return "shulkerboxtooltip.enderChestSyncType." + this.name().toLowerCase();
        }
    }

    public static enum LootTableInfoType {
        HIDE,
        SIMPLE,
        ADVANCED;


        public String toString() {
            return "shulkerboxtooltip.lootTableInfoType." + this.name().toLowerCase();
        }
    }

    public static enum ShulkerBoxTooltipType {
        VANILLA,
        MOD,
        NONE;


        public String toString() {
            return "shulkerboxtooltip.tooltipType." + this.name().toLowerCase();
        }
    }

    public static enum PreviewPosition {
        INSIDE,
        OUTSIDE,
        OUTSIDE_TOP,
        OUTSIDE_BOTTOM;


        public String toString() {
            return "shulkerboxtooltip.preview_position." + this.name().toLowerCase();
        }
    }

    public static enum Theme {
        MOD_LIGHT,
        MOD_DARK,
        VANILLA;


        public String toString() {
            return "shulkerboxtooltip.theme." + this.name().toLowerCase();
        }
    }

    public static enum CompactPreviewNbtBehavior {
        IGNORE,
        FIRST_ITEM,
        SEPARATE;


        public String toString() {
            return "shulkerboxtooltip.compactPreviewNbtBehavior." + this.name().toLowerCase();
        }
    }
}

