/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltipClient;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorRegistry;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public interface ShulkerBoxTooltipApi {
    @Nullable
    public static PreviewProvider getPreviewProviderForStack(class_1799 stack) {
        return PreviewProviderRegistry.getInstance().get(stack);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isPreviewAvailable(PreviewContext context) {
        if (ShulkerBoxTooltip.config.preview.enable) {
            PreviewProvider provider = ShulkerBoxTooltipApi.getPreviewProviderForStack(context.stack());
            return provider != null && provider.shouldDisplay(context) && ShulkerBoxTooltipApi.getCurrentPreviewType(provider.isFullPreviewAvailable(context)) != PreviewType.NO_PREVIEW;
        }
        return false;
    }

    @Nonnull
    @Environment(value=EnvType.CLIENT)
    public static PreviewType getCurrentPreviewType(boolean hasFullPreviewMode) {
        boolean shouldDisplay = ShulkerBoxTooltipClient.shouldDisplayPreview();
        if (shouldDisplay && !hasFullPreviewMode) {
            return PreviewType.COMPACT;
        }
        if (ShulkerBoxTooltip.config.preview.swapModes) {
            if (shouldDisplay) {
                return ShulkerBoxTooltipApi.isFullPreviewKeyPressed() ? PreviewType.COMPACT : PreviewType.FULL;
            }
        } else if (shouldDisplay) {
            return ShulkerBoxTooltipApi.isFullPreviewKeyPressed() ? PreviewType.FULL : PreviewType.COMPACT;
        }
        return PreviewType.NO_PREVIEW;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isPreviewKeyPressed() {
        return ShulkerBoxTooltipClient.isPreviewKeyPressed();
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isFullPreviewKeyPressed() {
        return ShulkerBoxTooltipClient.isFullPreviewKeyPressed();
    }

    public static boolean hasModAvailable(class_3222 player) {
        return ServerNetworking.hasModAvailable(player);
    }

    @Environment(value=EnvType.CLIENT)
    default public void registerColors(ColorRegistry registry) {
    }

    public void registerProviders(PreviewProviderRegistry var1);
}

