/*
 * Decompiled with CFR 0.152.
 */
package iwust.rpbattle.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenderUtil {
    private static final Map<class_2960, Integer> WIDTH_CACHE = new HashMap<class_2960, Integer>();
    private static final Map<class_2960, Integer> HEIGHT_CACHE = new HashMap<class_2960, Integer>();
    private static final Map<class_2960, Integer> SCALE_CACHE = new HashMap<class_2960, Integer>();

    public static void drawSquare(@NotNull class_4587 matrixStack, int x, int y, int size, int color) {
        class_332.method_25294((class_4587)matrixStack, (int)x, (int)y, (int)(x + size), (int)(y + size), (int)color);
    }

    public static void drawPlayerFace(@NotNull class_4587 matrixStack, @NotNull class_2960 skinTexture, int x, int y, int size, int outerBorder, int innerBorder, int outerBorderColor, int innerBorderColor) {
        if (!RenderUtil.isTextureExists(skinTexture)) {
            return;
        }
        int scale = RenderUtil.getSkinTextureScale(skinTexture);
        if (scale <= 0) {
            return;
        }
        if (outerBorder > 0) {
            RenderUtil.drawSquare(matrixStack, x - outerBorder, y - outerBorder, size + outerBorder * 2, outerBorderColor);
        }
        if (innerBorder > 0) {
            RenderUtil.drawSquare(matrixStack, x - innerBorder, y - innerBorder, size + innerBorder * 2, innerBorderColor);
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)skinTexture);
        class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)size, (int)size, (float)(8 * scale), (float)(8 * scale), (int)(8 * scale), (int)(8 * scale), (int)(64 * scale), (int)(64 * scale));
    }

    public static int toColor(int red, int green, int blue) {
        return RenderUtil.toColor(red, green, blue, 255);
    }

    public static int toColor(int red, int green, int blue, int a) {
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        return a << 24 | red << 16 | green << 8 | blue;
    }

    public static int getSkinTextureScale(@NotNull class_2960 texture) {
        int textureHeight;
        if (SCALE_CACHE.containsKey(texture)) {
            return SCALE_CACHE.get(texture);
        }
        int textureWidth = RenderUtil.getTextureWidth(texture);
        if (textureWidth != (textureHeight = RenderUtil.getTextureHeight(texture))) {
            SCALE_CACHE.put(texture, -1);
            return -1;
        }
        int scale = textureWidth / 64;
        SCALE_CACHE.put(texture, scale);
        return scale;
    }

    public static int getTextureWidth(@NotNull class_2960 texture) {
        if (WIDTH_CACHE.containsKey(texture)) {
            return WIDTH_CACHE.get(texture);
        }
        int width = -1;
        try (class_1011 nativeImage = RenderUtil.getNativeImage(texture);){
            if (nativeImage != null) {
                width = nativeImage.method_4307();
            }
        }
        WIDTH_CACHE.put(texture, width);
        return width;
    }

    public static int getTextureHeight(@NotNull class_2960 texture) {
        if (HEIGHT_CACHE.containsKey(texture)) {
            return HEIGHT_CACHE.get(texture);
        }
        int height = -1;
        try (class_1011 nativeImage = RenderUtil.getNativeImage(texture);){
            if (nativeImage != null) {
                height = nativeImage.method_4323();
            }
        }
        HEIGHT_CACHE.put(texture, height);
        return height;
    }

    public static void drawTexture(@NotNull class_2960 texture, @NotNull class_4587 matrixStack, int x, int y, float scale, boolean centered) {
        if (!RenderUtil.isTextureExists(texture)) {
            return;
        }
        if (scale <= 0.0f) {
            return;
        }
        int width = RenderUtil.getTextureWidth(texture);
        int height = RenderUtil.getTextureHeight(texture);
        if (width <= 0 || height <= 0) {
            return;
        }
        if (centered) {
            x -= (int)((float)width * scale) / 2;
            y -= (int)((float)height * scale) / 2;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)((int)((float)width * scale)), (int)((int)((float)height * scale)), (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
        RenderSystem.disableBlend();
    }

    public static boolean isMouseOnTexture(@NotNull class_2960 texture, int x, int y, float scale, boolean centered) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1729 == null) {
            return false;
        }
        if (!RenderUtil.isTextureExists(texture)) {
            return false;
        }
        if (scale <= 0.0f) {
            return false;
        }
        int width = RenderUtil.getTextureWidth(texture);
        int height = RenderUtil.getTextureHeight(texture);
        if (width <= 0 || height <= 0) {
            return false;
        }
        if (centered) {
            x -= (int)((float)width * scale) / 2;
            y -= (int)((float)height * scale) / 2;
        }
        double mouseX = client.field_1729.method_1603() / client.method_22683().method_4495();
        double mouseY = client.field_1729.method_1604() / client.method_22683().method_4495();
        return mouseX > (double)x && mouseX < (double)((float)x + (float)width * scale) && mouseY > (double)y && mouseY < (double)((float)y + (float)height * scale);
    }

    public static boolean isMouseOnArea(int x, int y, int width, int height, float scale, boolean centered) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1729 == null) {
            return false;
        }
        if (scale <= 0.0f) {
            return false;
        }
        if (width <= 0 || height <= 0) {
            return false;
        }
        if (centered) {
            x -= (int)((float)width * scale) / 2;
            y -= (int)((float)height * scale) / 2;
        }
        double mouseX = client.field_1729.method_1603() / client.method_22683().method_4495();
        double mouseY = client.field_1729.method_1604() / client.method_22683().method_4495();
        return mouseX > (double)x && mouseX < (double)((float)x + (float)width * scale) && mouseY > (double)y && mouseY < (double)((float)y + (float)height * scale);
    }

    public static boolean isTextureExists(@NotNull class_2960 texture) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return false;
        }
        if (client.method_1531().method_4619(texture) != null) {
            return true;
        }
        try {
            client.method_1478().method_14486(texture);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Nullable
    private static class_1011 getNativeImage(@NotNull class_2960 texture) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return null;
        }
        class_1044 abstractTexture = client.method_1531().method_4619(texture);
        if (abstractTexture instanceof class_1043) {
            class_1043 backedTexture = (class_1043)abstractTexture;
            return backedTexture.method_4525();
        }
        try {
            Optional resourceOptional = client.method_1478().method_14486(texture);
            if (resourceOptional.isPresent()) {
                return class_1011.method_4309((InputStream)((class_3298)resourceOptional.get()).method_14482());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static double getScaled(double coordinate) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return coordinate;
        }
        return coordinate * 2.0 / client.method_22683().method_4495();
    }
}

