/*
 * Decompiled with CFR 0.152.
 */
package iwust.rpbattle.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import iwust.rpbattle.battle.BattlePlayer;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FrameUtil {
    @Nullable
    private static String getFileData(@NotNull String frame) {
        String string;
        block8: {
            class_3300 resourceManager = class_310.method_1551().method_1478();
            class_2960 resourceLocation = new class_2960("rpbattle", "frames/" + frame + ".json");
            class_3298 resource = (class_3298)resourceManager.method_14486(resourceLocation).orElseThrow(Exception::new);
            InputStream inputStream = resource.method_14482();
            try {
                string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ignored) {
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    @Nullable
    public static class_2960 getFrameTextureIdentifier(@NotNull String frame, @NotNull BattlePlayer battlePlayer) {
        String data = FrameUtil.getFileData(frame);
        if (data == null) {
            return null;
        }
        JsonObject jsonObject = JsonParser.parseString((String)data).getAsJsonObject();
        JsonObject frameJsonObject = jsonObject.getAsJsonObject("frame");
        Gson gson = new Gson();
        JsonFrame jsonFrame = (JsonFrame)gson.fromJson((JsonElement)frameJsonObject, JsonFrame.class);
        for (int i = 0; i < jsonFrame.hp.size(); ++i) {
            if (i != battlePlayer.getHp()) continue;
            JsonFrameValue hpJsonFrameValue = jsonFrame.hp.get(i);
            if (i == 0) {
                if (hpJsonFrameValue.death != null) {
                    return new class_2960("rpbattle", hpJsonFrameValue.death);
                }
                if (jsonFrame.common.death != null) {
                    return new class_2960("rpbattle", jsonFrame.common.death);
                }
                if (jsonFrame.common._default != null) {
                    return new class_2960("rpbattle", jsonFrame.common._default);
                }
                return null;
            }
            if (battlePlayer.isMove()) {
                if (hpJsonFrameValue.move != null) {
                    return new class_2960("rpbattle", hpJsonFrameValue.move);
                }
                if (jsonFrame.common.move != null) {
                    return new class_2960("rpbattle", jsonFrame.common.move);
                }
                if (jsonFrame.common._default != null) {
                    return new class_2960("rpbattle", jsonFrame.common._default);
                }
                return null;
            }
            if (hpJsonFrameValue._default != null) {
                return new class_2960("rpbattle", hpJsonFrameValue._default);
            }
            if (jsonFrame.common._default != null) {
                return new class_2960("rpbattle", jsonFrame.common._default);
            }
            return null;
        }
        if (battlePlayer.getHp() == 0) {
            if (jsonFrame.common.death != null) {
                return new class_2960("rpbattle", jsonFrame.common.death);
            }
            if (jsonFrame.common._default != null) {
                return new class_2960("rpbattle", jsonFrame.common._default);
            }
            return null;
        }
        if (battlePlayer.isMove()) {
            if (jsonFrame.common.move != null) {
                return new class_2960("rpbattle", jsonFrame.common.move);
            }
            if (jsonFrame.common._default != null) {
                return new class_2960("rpbattle", jsonFrame.common._default);
            }
            return null;
        }
        if (jsonFrame.common._default != null) {
            return new class_2960("rpbattle", jsonFrame.common._default);
        }
        return null;
    }

    private static final class JsonFrame {
        @SerializedName(value="common")
        public JsonFrameValue common;
        @SerializedName(value="hp")
        public List<JsonFrameValue> hp;

        private JsonFrame() {
        }
    }

    private static final class JsonFrameValue {
        @SerializedName(value="default")
        public String _default;
        @SerializedName(value="move")
        public String move;
        @SerializedName(value="death")
        public String death;

        private JsonFrameValue() {
        }
    }
}

