/*
 * Decompiled with CFR 0.152.
 */
package iwust.rpbattle.render;

import iwust.rpbattle.battle.Battle;
import iwust.rpbattle.battle.BattlePlayer;
import iwust.rpbattle.constant.Color;
import iwust.rpbattle.render.PlayerPropertiesWindowRender;
import iwust.rpbattle.util.FrameUtil;
import iwust.rpbattle.util.RenderUtil;
import iwust.rpbattle.util.TextureUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_634;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public final class QueueRender
implements HudRenderCallback {
    private static final int BASE_Y = 30;
    private static final int BASE_SIZE = 40;
    private static final int INDENT = 10;
    private static final int OUTER_BORDER = 3;
    private static final int INNER_BORDER = 2;
    private static final int MOVE_ADDER = 4;
    private static final int HEART_Y_OFFSET = -13;
    private static final int NAME_Y_OFFSET = 5;
    private static final int NAME_INDENT = 8;
    @NotNull
    private final List<PlayerHead> playerHeadList = new ArrayList<PlayerHead>();
    private static int movePlayerIndex = -1;

    public QueueRender() {
        ClientTickEvents.END_CLIENT_TICK.register(this::handleMouseClick);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHudRender(@NotNull class_4587 matrixStack, float tickDelta) {
        Battle battle;
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) {
            return;
        }
        class_634 networkHandler = client.method_1562();
        if (networkHandler == null) {
            return;
        }
        Battle battle2 = battle = Battle.getInstance();
        synchronized (battle2) {
            if (!battle.isStarted()) {
                return;
            }
            List<BattlePlayer> battlePlayerList = battle.getBattlePlayerList();
            if (battlePlayerList.size() < 2) {
                return;
            }
            this.playerHeadList.clear();
            for (int i = 0; i < battlePlayerList.size(); ++i) {
                if (!battlePlayerList.get(i).isMove()) continue;
                movePlayerIndex = i;
                break;
            }
            if (movePlayerIndex == -1) {
                return;
            }
            int playerCount = battlePlayerList.size();
            int centerX = client.method_22683().method_4486() / 2;
            int totalWidthPerPlayer = 53;
            int centerSlot = playerCount / 2;
            for (int slot = 0; slot < playerCount; ++slot) {
                int offset = slot - centerSlot;
                int displayIndex = (movePlayerIndex + offset + playerCount) % playerCount;
                BattlePlayer battlePlayer = battlePlayerList.get(displayIndex);
                if (battlePlayer.isNext()) continue;
                String name = battlePlayer.getName();
                if (name == null) {
                    return;
                }
                class_2960 skinTexture = TextureUtil.getSkinIdentifier(name);
                name = battlePlayer.getIcName();
                if (name == null) continue;
                String frame = battlePlayer.getFrame();
                class_2960 frameTexture = null;
                if (!(frame == null || frame.isEmpty() || (frameTexture = FrameUtil.getFrameTextureIdentifier(frame, battlePlayer)) != null && RenderUtil.isTextureExists(frameTexture))) {
                    frameTexture = null;
                }
                int currentX = centerX + offset * totalWidthPerPlayer - totalWidthPerPlayer / 2 + 5;
                int currentY = 30;
                int currentSize = 40;
                int outerBorder = 3;
                int innerBorder = 2;
                int color = this.borderColor(battlePlayer);
                if (frameTexture != null) {
                    outerBorder = 0;
                    innerBorder = 0;
                }
                if (battlePlayer.isMove()) {
                    currentSize += 4;
                    currentY -= 2;
                    currentX -= 2;
                }
                PlayerHead playerHead = new PlayerHead();
                playerHead.battlePlayer = battlePlayer;
                playerHead.x = currentX;
                playerHead.y = currentY;
                playerHead.size = currentSize;
                this.playerHeadList.add(playerHead);
                RenderUtil.drawPlayerFace(matrixStack, skinTexture, currentX, currentY, currentSize, outerBorder, innerBorder, Color.BLACK, color);
                if (battlePlayer.getHp() <= 0) {
                    RenderUtil.drawSquare(matrixStack, currentX, currentY, currentSize, RenderUtil.toColor(0, 0, 0, 160));
                }
                if (frameTexture != null) {
                    RenderUtil.drawTexture(frameTexture, matrixStack, currentX + currentSize / 2, currentY + currentSize / 2, (float)currentSize / 40.0f, true);
                }
                int hp = battlePlayer.getHp();
                int heartsPerLine = 5;
                for (int i = 0; i < hp; i += 5) {
                    int end = Math.min(i + 5, hp);
                    String line = "\u2764".repeat(end - i);
                    class_332.method_27534((class_4587)matrixStack, (class_327)client.field_1772, (class_2561)class_2561.method_43470((String)line), (int)(currentX + currentSize / 2), (int)(currentY + -13 - i / 5 * 8), (int)Color.DARK_RED);
                }
                this.drawPlayerName(matrixStack, client.field_1772, name, currentX + currentSize / 2, currentY + currentSize + 5, color);
            }
        }
    }

    private int borderColor(@NotNull BattlePlayer battlePlayer) {
        if (battlePlayer.isMove()) {
            return Color.YELLOW;
        }
        if (battlePlayer.getHp() <= 0) {
            return Color.DARK_RED;
        }
        return Color.WHITE;
    }

    private void drawPlayerName(@NotNull class_4587 matrixStack, @NotNull class_327 textRenderer, @NotNull String name, int x, int y, int color) {
        ArrayList<Object> lineList = new ArrayList<Object>();
        List<String> nameWordList = Arrays.stream(name.split(" ")).toList();
        StringBuilder tempLine = new StringBuilder();
        int tempLength = 0;
        for (String word : nameWordList) {
            int wordLength = word.length();
            if (wordLength > 8) {
                if (!tempLine.isEmpty()) {
                    lineList.add(tempLine.toString());
                    tempLine = new StringBuilder();
                    tempLength = 0;
                }
                lineList.add(word.substring(0, 8) + "...");
                continue;
            }
            if (tempLength + (!tempLine.isEmpty() ? 1 : 0) + wordLength > 8) {
                if (!tempLine.isEmpty()) {
                    lineList.add(tempLine.toString());
                    tempLine = new StringBuilder();
                }
                tempLine.append(word);
                tempLength = wordLength;
                continue;
            }
            if (!tempLine.isEmpty()) {
                tempLine.append(" ");
                ++tempLength;
            }
            tempLine.append(word);
            tempLength += wordLength;
        }
        if (!tempLine.isEmpty()) {
            lineList.add(tempLine.toString());
        }
        for (int i = 0; i < lineList.size(); ++i) {
            class_332.method_27534((class_4587)matrixStack, (class_327)textRenderer, (class_2561)class_2561.method_43470((String)((String)lineList.get(i))), (int)x, (int)(y + 8 * i), (int)color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMouseClick(@NotNull class_310 client) {
        Battle battle;
        if (client.field_1724 == null) {
            return;
        }
        Battle battle2 = battle = Battle.getInstance();
        synchronized (battle2) {
            boolean isRightPressed;
            boolean isLeftPressed = GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)0) == 1;
            boolean bl = isRightPressed = GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)1) == 1;
            if (!isLeftPressed && !isRightPressed) {
                return;
            }
            for (PlayerHead playerHead : this.playerHeadList) {
                String creator;
                if (!RenderUtil.isMouseOnArea(playerHead.x, playerHead.y, playerHead.size, playerHead.size, 1.0f, false) || PlayerPropertiesWindowRender.getInstance().isOpen() || (creator = battle.getCreator()) == null || !creator.equals(client.field_1724.method_5477().getString())) continue;
                PlayerPropertiesWindowRender.getInstance().open(playerHead.battlePlayer);
            }
        }
    }

    private static final class PlayerHead {
        private BattlePlayer battlePlayer;
        private int x;
        private int y;
        private int size;

        private PlayerHead() {
        }
    }
}

