/*
 * Decompiled with CFR 0.152.
 */
package iwust.rpbattle.render;

import iwust.rpbattle.battle.Battle;
import iwust.rpbattle.battle.BattlePlayer;
import iwust.rpbattle.constant.Color;
import iwust.rpbattle.constant.Texture;
import iwust.rpbattle.util.RenderUtil;
import iwust.rpbattle.util.TextureUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_634;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public final class PlayerPropertiesWindowRender
implements HudRenderCallback {
    private static final int Y = 200;
    private static final float BASE_SCALE = 0.5f;
    private static final float ARROW_SCALE = 0.4f;
    private static final int SAVE_BUTTON_X = 70;
    private static final int SAVE_BUTTON_Y = 25;
    private static final int PLAYER_HEAD_X = 10;
    private static final int PLAYER_HEAD_Y = 10;
    private static final int PLAYER_HEAD_SIZE = 55;
    private static final int SPINNER_X = 10;
    private static final int SPINNER_START_Y = 50;
    @NotNull
    private final List<Spinner> spinnerList = new ArrayList<Spinner>();
    @Nullable
    private BattlePlayer battlePlayer;
    private int saveButtonX;
    private int saveButtonY;
    private boolean open;
    private boolean lastPressed;

    private PlayerPropertiesWindowRender() {
        ClientTickEvents.END_CLIENT_TICK.register(this::handleMouseClick);
    }

    @NotNull
    public static PlayerPropertiesWindowRender getInstance() {
        return Holder.playerPropertiesWindowRender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        PlayerPropertiesWindowRender playerPropertiesWindowRender = this;
        synchronized (playerPropertiesWindowRender) {
            return this.open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(@NotNull BattlePlayer battlePlayer) {
        PlayerPropertiesWindowRender playerPropertiesWindowRender = this;
        synchronized (playerPropertiesWindowRender) {
            this.spinnerList.clear();
            this.battlePlayer = battlePlayer;
            Spinner hpScoreSpinner = new Spinner("\u041a\u043e\u043b-\u0432\u043e \u043e\u0447\u043a\u043e\u0432 \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u044f: ", value -> {
                class_310 client = class_310.method_1551();
                if (client == null) {
                    return;
                }
                class_634 clientPlayNetworkHandler = client.method_1562();
                if (clientPlayNetworkHandler != null && value != battlePlayer.getHp()) {
                    clientPlayNetworkHandler.method_45730(String.format("rp_battle set %s %d %s", "hp", value, battlePlayer.getName()));
                }
            }, battlePlayer.getHp());
            hpScoreSpinner.unsigned = true;
            Spinner moveScoreSpinner = new Spinner("\u041a\u043e\u043b-\u0432\u043e \u043e\u0447\u043a\u043e\u0432 \u043f\u0435\u0440\u0435\u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f: ", value -> {
                class_310 client = class_310.method_1551();
                if (client == null) {
                    return;
                }
                class_634 clientPlayNetworkHandler = client.method_1562();
                if (clientPlayNetworkHandler != null && value != battlePlayer.getDefaultMoveScore()) {
                    clientPlayNetworkHandler.method_45730(String.format("rp_battle set %s %d %s", "move", value, battlePlayer.getName()));
                }
            }, battlePlayer.getDefaultMoveScore());
            moveScoreSpinner.unsigned = true;
            Spinner attackCountSpinner = new Spinner("\u041a\u043e\u043b-\u0432\u043e \u0430\u0442\u0430\u043a \u043d\u0430 \u043e\u0434\u0438\u043d \u0445\u043e\u0434: ", value -> {
                class_310 client = class_310.method_1551();
                if (client == null) {
                    return;
                }
                class_634 clientPlayNetworkHandler = client.method_1562();
                if (clientPlayNetworkHandler != null && value != battlePlayer.getDefaultAttackCount()) {
                    clientPlayNetworkHandler.method_45730(String.format("rp_battle set %s %d %s", "count", value, battlePlayer.getName()));
                }
            }, battlePlayer.getDefaultAttackCount());
            attackCountSpinner.unsigned = true;
            Spinner attackBonusSpinner = new Spinner("\u0411\u043e\u043d\u0443\u0441 \u043a \u0444\u0438\u0437. \u0430\u0442\u0430\u043a\u0435: ", value -> {
                class_310 client = class_310.method_1551();
                if (client == null) {
                    return;
                }
                class_634 clientPlayNetworkHandler = client.method_1562();
                if (clientPlayNetworkHandler != null && value != battlePlayer.getAttackBonus()) {
                    clientPlayNetworkHandler.method_45730(String.format("rp_battle set %s %s %d %s", "dice", "attack", value, battlePlayer.getName()));
                }
            }, battlePlayer.getAttackBonus());
            Spinner defendBonusSpinner = new Spinner("\u0411\u043e\u043d\u0443\u0441 \u043a \u0444\u0438\u0437. \u0437\u0430\u0449\u0438\u0442\u0435: ", value -> {
                class_310 client = class_310.method_1551();
                if (client == null) {
                    return;
                }
                class_634 clientPlayNetworkHandler = client.method_1562();
                if (clientPlayNetworkHandler != null && value != battlePlayer.getDefendBonus()) {
                    clientPlayNetworkHandler.method_45730(String.format("rp_battle set %s %s %d %s", "dice", "defend", value, battlePlayer.getName()));
                }
            }, battlePlayer.getDefendBonus());
            Spinner escapeBonusSpinner = new Spinner("\u0411\u043e\u043d\u0443\u0441 \u043a \u0444\u0438\u0437. \u043f\u043e\u0431\u0435\u0433\u0443: ", value -> {
                class_310 client = class_310.method_1551();
                if (client == null) {
                    return;
                }
                class_634 clientPlayNetworkHandler = client.method_1562();
                if (clientPlayNetworkHandler != null && value != battlePlayer.getEscapeBonus()) {
                    clientPlayNetworkHandler.method_45730(String.format("rp_battle set %s %s %d %s", "dice", "escape", value, battlePlayer.getName()));
                }
            }, battlePlayer.getEscapeBonus());
            Spinner magicAttackBonusSpinner = new Spinner("\u0411\u043e\u043d\u0443\u0441 \u043a \u0441\u043f\u0435\u0446. \u0430\u0442\u0430\u043a\u0435: ", value -> {
                class_310 client = class_310.method_1551();
                if (client == null) {
                    return;
                }
                class_634 clientPlayNetworkHandler = client.method_1562();
                if (clientPlayNetworkHandler != null && value != battlePlayer.getMagicAttackBonus()) {
                    clientPlayNetworkHandler.method_45730(String.format("rp_battle set %s %s %d %s", "dice", "mattack", value, battlePlayer.getName()));
                }
            }, battlePlayer.getMagicAttackBonus());
            Spinner magicDefendBonusSpinner = new Spinner("\u0411\u043e\u043d\u0443\u0441 \u043a \u0441\u043f\u0435\u0446. \u0437\u0430\u0449\u0438\u0442\u0435: ", value -> {
                class_310 client = class_310.method_1551();
                if (client == null) {
                    return;
                }
                class_634 clientPlayNetworkHandler = client.method_1562();
                if (clientPlayNetworkHandler != null && value != battlePlayer.getMagicDefendBonus()) {
                    clientPlayNetworkHandler.method_45730(String.format("rp_battle set %s %s %d %s", "dice", "mdefend", value, battlePlayer.getName()));
                }
            }, battlePlayer.getMagicDefendBonus());
            Spinner magicEscapeBonusSpinner = new Spinner("\u0411\u043e\u043d\u0443\u0441 \u043a \u0441\u043f\u0435\u0446. \u043f\u043e\u0431\u0435\u0433\u0443: ", value -> {
                class_310 client = class_310.method_1551();
                if (client == null) {
                    return;
                }
                class_634 clientPlayNetworkHandler = client.method_1562();
                if (clientPlayNetworkHandler != null && value != battlePlayer.getMagicEscapeBonus()) {
                    clientPlayNetworkHandler.method_45730(String.format("rp_battle set %s %s %d %s", "dice", "mescape", value, battlePlayer.getName()));
                }
            }, battlePlayer.getMagicEscapeBonus());
            this.spinnerList.add(hpScoreSpinner);
            this.spinnerList.add(moveScoreSpinner);
            this.spinnerList.add(attackCountSpinner);
            this.spinnerList.add(attackBonusSpinner);
            this.spinnerList.add(defendBonusSpinner);
            this.spinnerList.add(escapeBonusSpinner);
            this.spinnerList.add(magicAttackBonusSpinner);
            this.spinnerList.add(magicDefendBonusSpinner);
            this.spinnerList.add(magicEscapeBonusSpinner);
            this.open = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PlayerPropertiesWindowRender playerPropertiesWindowRender = this;
        synchronized (playerPropertiesWindowRender) {
            if (this.isOpen()) {
                this.spinnerList.clear();
                this.battlePlayer = null;
                this.open = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHudRender(@NotNull class_4587 matrixStack, float tickDelta) {
        Battle battle;
        Battle battle2 = battle = Battle.getInstance();
        synchronized (battle2) {
            if (!battle.isStarted()) {
                this.close();
            }
        }
        if (!this.open) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) {
            return;
        }
        int Y = (int)RenderUtil.getScaled(200.0);
        float BASE_SCALE = (float)RenderUtil.getScaled(0.5);
        float ARROW_SCALE = (float)RenderUtil.getScaled(0.4f);
        int SAVE_BUTTON_X = (int)RenderUtil.getScaled(70.0);
        int SAVE_BUTTON_Y = (int)RenderUtil.getScaled(25.0);
        int PLAYER_HEAD_X = (int)RenderUtil.getScaled(10.0);
        int PLAYER_HEAD_Y = (int)RenderUtil.getScaled(10.0);
        int PLAYER_HEAD_SIZE = (int)RenderUtil.getScaled(55.0);
        int SPINNER_X = (int)RenderUtil.getScaled(10.0);
        int SPINNER_START_Y = (int)RenderUtil.getScaled(50.0);
        class_634 networkHandler = client.method_1562();
        if (networkHandler == null) {
            return;
        }
        PlayerPropertiesWindowRender playerPropertiesWindowRender = this;
        synchronized (playerPropertiesWindowRender) {
            String name;
            if (this.battlePlayer == null) {
                return;
            }
            if (client.field_1755 == null) {
                class_408 chatScreen = new class_408("");
                client.method_1507((class_437)chatScreen);
            }
            if ((name = this.battlePlayer.getName()) == null) {
                return;
            }
            class_2960 skinTexture = TextureUtil.getSkinIdentifier(name);
            int centerX = client.method_22683().method_4486() / 2;
            int windowWidth = (int)((float)RenderUtil.getTextureWidth(Texture.PLAYER_PROPERTIES_WINDOW) * BASE_SCALE);
            int windowHeight = (int)((float)RenderUtil.getTextureHeight(Texture.PLAYER_PROPERTIES_WINDOW) * BASE_SCALE);
            int windowX = centerX - windowWidth / 2;
            RenderUtil.drawTexture(Texture.PLAYER_PROPERTIES_WINDOW, matrixStack, windowX, Y, BASE_SCALE, false);
            int saveButtonWidth = (int)((float)RenderUtil.getTextureWidth(Texture.SAVE_BUTTON) * BASE_SCALE);
            int saveButtonHeight = (int)((float)RenderUtil.getTextureHeight(Texture.SAVE_BUTTON) * BASE_SCALE);
            this.saveButtonX = windowX + windowWidth - SAVE_BUTTON_X - saveButtonWidth / 2;
            this.saveButtonY = Y + windowHeight - SAVE_BUTTON_Y - saveButtonHeight / 2;
            int saveButtonHoverOffsetY = 0;
            if (RenderUtil.isMouseOnTexture(Texture.SAVE_BUTTON, this.saveButtonX, this.saveButtonY, BASE_SCALE, false)) {
                saveButtonHoverOffsetY += (int)RenderUtil.getScaled(2.0);
            }
            RenderUtil.drawTexture(Texture.SAVE_BUTTON, matrixStack, this.saveButtonX, this.saveButtonY + saveButtonHoverOffsetY, BASE_SCALE, false);
            RenderUtil.drawPlayerFace(matrixStack, skinTexture, windowX + PLAYER_HEAD_X, Y + PLAYER_HEAD_Y, (int)((float)PLAYER_HEAD_SIZE * BASE_SCALE), 0, 0, 0, 0);
            int spinnerY = 0;
            for (Spinner spinner : this.spinnerList) {
                spinner.x = SPINNER_X + windowX;
                spinner.y = SPINNER_START_Y + spinnerY + Y;
                class_332.method_27535((class_4587)matrixStack, (class_327)client.field_1772, (class_2561)class_2561.method_43470((String)spinner.title), (int)spinner.x, (int)spinner.y, (int)Color.WHITE);
                class_332.method_27535((class_4587)matrixStack, (class_327)client.field_1772, (class_2561)class_2561.method_43470((String)String.valueOf(spinner.value)), (int)(spinner.x + windowWidth - SPINNER_X * 5), (int)spinner.y, (int)Color.YELLOW);
                spinner.upX = spinner.x + windowWidth - SPINNER_X * 3;
                spinner.upY = spinner.y - (int)RenderUtil.getScaled(2.0);
                int arrowUpYHover = 0;
                if (RenderUtil.isMouseOnTexture(Texture.ARROW_UP_BUTTON, spinner.upX, spinner.upY, ARROW_SCALE, true)) {
                    arrowUpYHover = (int)RenderUtil.getScaled(1.0);
                }
                RenderUtil.drawTexture(Texture.ARROW_UP_BUTTON, matrixStack, spinner.upX, spinner.upY + arrowUpYHover, ARROW_SCALE, true);
                spinner.downX = spinner.x + windowWidth - SPINNER_X * 3;
                spinner.downY = spinner.y + (int)RenderUtil.getScaled(6.0);
                int arrowDownYHover = 0;
                if (RenderUtil.isMouseOnTexture(Texture.ARROW_DOWN_BUTTON, spinner.downX, spinner.downY, ARROW_SCALE, true)) {
                    arrowDownYHover = (int)RenderUtil.getScaled(1.0);
                }
                RenderUtil.drawTexture(Texture.ARROW_DOWN_BUTTON, matrixStack, spinner.downX, spinner.downY + arrowDownYHover, ARROW_SCALE, true);
                spinnerY += (int)RenderUtil.getScaled(14.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMouseClick(@NotNull class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        float BASE_SCALE = (float)RenderUtil.getScaled(0.5);
        float ARROW_SCALE = (float)RenderUtil.getScaled(0.4f);
        if (client.field_1755 == null) {
            return;
        }
        PlayerPropertiesWindowRender playerPropertiesWindowRender = this;
        synchronized (playerPropertiesWindowRender) {
            boolean isPressed;
            if (!this.open) {
                return;
            }
            boolean bl = isPressed = GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)0) == 1 || GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)1) == 1;
            if (isPressed || !this.lastPressed) {
                this.lastPressed = isPressed;
                return;
            }
            this.lastPressed = false;
            if (RenderUtil.isMouseOnTexture(Texture.SAVE_BUTTON, this.saveButtonX, this.saveButtonY, BASE_SCALE, false)) {
                for (Spinner spinner : this.spinnerList) {
                    spinner.valueFunction.set(spinner.value);
                }
                this.open = false;
                if (client.field_1755 != null) {
                    client.method_1507(null);
                }
                return;
            }
            for (Spinner spinner : this.spinnerList) {
                if (RenderUtil.isMouseOnTexture(Texture.ARROW_UP_BUTTON, spinner.upX, spinner.upY, ARROW_SCALE, true)) {
                    ++spinner.value;
                    continue;
                }
                if (!RenderUtil.isMouseOnTexture(Texture.ARROW_DOWN_BUTTON, spinner.downX, spinner.downY, ARROW_SCALE, true)) continue;
                if (spinner.unsigned && spinner.value <= 0) {
                    return;
                }
                --spinner.value;
            }
        }
    }

    private static final class Holder {
        @NotNull
        private static final PlayerPropertiesWindowRender playerPropertiesWindowRender = new PlayerPropertiesWindowRender();

        private Holder() {
        }
    }

    private static final class Spinner {
        @NotNull
        private final String title;
        @NotNull
        private final ValueFunction valueFunction;
        private int value;
        private int x;
        private int y;
        private int upX;
        private int upY;
        private int downX;
        private int downY;
        private boolean unsigned;

        private Spinner(@NotNull String title, @NotNull ValueFunction valueFunction, int value) {
            this.title = title;
            this.valueFunction = valueFunction;
            this.value = value;
        }
    }

    @FunctionalInterface
    private static interface ValueFunction {
        public void set(int var1);
    }
}

