/*
 * Decompiled with CFR 0.152.
 */
package iwust.rpbattle.render;

import iwust.rpbattle.battle.Battle;
import iwust.rpbattle.battle.BattlePlayer;
import iwust.rpbattle.constant.Texture;
import iwust.rpbattle.render.PlayerPropertiesWindowRender;
import iwust.rpbattle.util.RenderUtil;
import iwust.rpbattle.util.TextureUtil;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public final class EscapeDialogRender
implements HudRenderCallback {
    private static final int Y = 350;
    private static final int PLAYER_FACE_SIZE = 45;
    private static final float BASE_SCALE = 0.5f;
    private static int escapeButtonX;
    private static int escapeButtonY;
    private static int ignoreButtonX;
    private static int ignoreButtonY;
    private static boolean open;

    public EscapeDialogRender() {
        ClientTickEvents.END_CLIENT_TICK.register(this::handleMouseClick);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHudRender(@NotNull class_4587 matrixStack, float tickDelta) {
        Battle battle;
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) {
            return;
        }
        int Y = (int)RenderUtil.getScaled(350.0);
        int PLAYER_FACE_SIZE = (int)RenderUtil.getScaled(45.0);
        float BASE_SCALE = (float)RenderUtil.getScaled(0.5);
        class_634 networkHandler = client.method_1562();
        if (networkHandler == null) {
            return;
        }
        Battle battle2 = battle = Battle.getInstance();
        synchronized (battle2) {
            if (this.isDialogInactive(client.field_1724, battle)) {
                if (open && client.field_1755 != null) {
                    client.method_1507(null);
                }
                open = false;
                return;
            }
            open = true;
            String escapePlayer = battle.getEscapePlayer();
            if (escapePlayer == null) {
                return;
            }
            class_2960 skinTexture = TextureUtil.getSkinIdentifier(escapePlayer);
            PlayerPropertiesWindowRender.getInstance().close();
            if (client.field_1755 == null) {
                class_408 chatScreen = new class_408("");
                client.method_1507((class_437)chatScreen);
            }
            int centerX = client.method_22683().method_4486() / 2;
            int escapeDialogWidth = (int)((float)RenderUtil.getTextureWidth(Texture.ESCAPE_DIALOG) * BASE_SCALE);
            int escapeDialogHeight = (int)((float)RenderUtil.getTextureHeight(Texture.ESCAPE_DIALOG) * BASE_SCALE);
            int escapeDialogX = centerX - escapeDialogWidth / 2;
            RenderUtil.drawTexture(Texture.ESCAPE_DIALOG, matrixStack, escapeDialogX, Y, BASE_SCALE, false);
            RenderUtil.drawPlayerFace(matrixStack, skinTexture, escapeDialogX + (int)RenderUtil.getScaled(12.0), Y + (int)RenderUtil.getScaled(12.0), PLAYER_FACE_SIZE, 0, 0, 0, 0);
            escapeButtonX = escapeDialogX + (int)RenderUtil.getScaled(65.0);
            escapeButtonY = Y + escapeDialogHeight / 2;
            int escapeButtonHoverOffsetY = 0;
            if (RenderUtil.isMouseOnTexture(Texture.ESCAPE_BUTTON, escapeButtonX, escapeButtonY, BASE_SCALE, false)) {
                escapeButtonHoverOffsetY = (int)RenderUtil.getScaled(2.0);
            }
            RenderUtil.drawTexture(Texture.ESCAPE_BUTTON, matrixStack, escapeButtonX, escapeButtonY + escapeButtonHoverOffsetY, BASE_SCALE, false);
            ignoreButtonX = escapeDialogX + (int)RenderUtil.getScaled(165.0);
            ignoreButtonY = Y + escapeDialogHeight / 2;
            int ignoreButtonHoverOffsetY = 0;
            if (RenderUtil.isMouseOnTexture(Texture.IGNORE_BUTTON, ignoreButtonX, ignoreButtonY, BASE_SCALE, false)) {
                ignoreButtonHoverOffsetY = (int)RenderUtil.getScaled(2.0);
            }
            RenderUtil.drawTexture(Texture.IGNORE_BUTTON, matrixStack, ignoreButtonX, ignoreButtonY + ignoreButtonHoverOffsetY, BASE_SCALE, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMouseClick(@NotNull class_310 client) {
        Battle battle;
        if (client.field_1724 == null) {
            return;
        }
        float BASE_SCALE = (float)RenderUtil.getScaled(0.5);
        if (client.field_1755 == null) {
            return;
        }
        Battle battle2 = battle = Battle.getInstance();
        synchronized (battle2) {
            boolean isRightPressed;
            if (this.isDialogInactive(client.field_1724, Battle.getInstance())) {
                return;
            }
            boolean isLeftPressed = GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)0) == 1;
            boolean bl = isRightPressed = GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)1) == 1;
            if (!isLeftPressed && !isRightPressed) {
                return;
            }
            if (RenderUtil.isMouseOnTexture(Texture.ESCAPE_BUTTON, escapeButtonX, escapeButtonY, BASE_SCALE, false)) {
                client.field_1724.field_3944.method_45730("rp_battle catch");
                if (client.field_1755 != null) {
                    client.method_1507(null);
                    battle.setEscapePlayer(null);
                }
            } else if (RenderUtil.isMouseOnTexture(Texture.IGNORE_BUTTON, ignoreButtonX, ignoreButtonY, BASE_SCALE, false)) {
                client.field_1724.field_3944.method_45730("rp_battle ignore");
                if (client.field_1755 != null) {
                    client.method_1507(null);
                    battle.setEscapePlayer(null);
                }
            }
        }
    }

    private boolean isDialogInactive(@NotNull class_746 player, @NotNull Battle battle) {
        if (!battle.isStarted()) {
            return true;
        }
        String name = player.method_5477().getString();
        BattlePlayer battlePlayer = null;
        for (BattlePlayer bp : battle.getBattlePlayerList()) {
            if (bp == null || !name.equals(bp.getName())) continue;
            battlePlayer = bp;
            break;
        }
        return battlePlayer == null || !battlePlayer.isEscape();
    }
}

