/*
 * Decompiled with CFR 0.152.
 */
package iwust.rpbattle.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import iwust.rpbattle.battle.Battle;
import iwust.rpbattle.battle.BattlePlayer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.jetbrains.annotations.NotNull;

public final class MainChannelHandler
implements ClientPlayNetworking.PlayChannelHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(@NotNull class_310 client, @NotNull class_634 handler, @NotNull class_2540 buffer, @NotNull PacketSender responseSender) {
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        String data = new String(bytes, StandardCharsets.UTF_8);
        JsonObject jsonObject = JsonParser.parseString((String)data).getAsJsonObject();
        JsonObject battleJsonObject = jsonObject.getAsJsonObject("battle");
        Battle battle = Battle.getInstance();
        if (battleJsonObject == null || battleJsonObject.size() == 0) {
            Battle battle2 = battle;
            synchronized (battle2) {
                battle.setStarted(false);
                battle.clearBattlePlayerList();
            }
            return;
        }
        Gson gson = new Gson();
        JsonBattle jsonBattle = (JsonBattle)gson.fromJson((JsonElement)battleJsonObject, JsonBattle.class);
        Battle battle3 = battle;
        synchronized (battle3) {
            battle.setStarted(jsonBattle.started);
            battle.setAttackPlayer(jsonBattle.attackPlayer);
            battle.setDefendPlayer(jsonBattle.defendPlayer);
            battle.setEscapePlayer(jsonBattle.escapePlayer);
            battle.setCreator(jsonBattle.creator);
            battle.clearBattlePlayerList();
            for (JsonPlayer jsonPlayer : jsonBattle.playerList) {
                BattlePlayer battlePlayer = MainChannelHandler.getBattlePlayer(jsonPlayer);
                battle.addBattlePlayer(battlePlayer);
            }
        }
    }

    @NotNull
    private static BattlePlayer getBattlePlayer(@NotNull JsonPlayer jsonPlayer) {
        BattlePlayer battlePlayer = new BattlePlayer();
        battlePlayer.setName(jsonPlayer.name);
        battlePlayer.setHp(jsonPlayer.hp);
        battlePlayer.setMoveScore(jsonPlayer.moveScore);
        battlePlayer.setMove(jsonPlayer.move);
        battlePlayer.setIcName(jsonPlayer.icName);
        battlePlayer.setNext(jsonPlayer.next);
        battlePlayer.setAttack(jsonPlayer.attack);
        battlePlayer.setDefend(jsonPlayer.defend);
        battlePlayer.setEscape(jsonPlayer.escape);
        battlePlayer.setCanWalk(jsonPlayer.canWalk);
        battlePlayer.setFrame(jsonPlayer.frame);
        battlePlayer.setDefaultMoveScore(jsonPlayer.defaultMoveScore);
        battlePlayer.setDefaultAttackCount(jsonPlayer.defaultAttackCount);
        battlePlayer.setAttackBonus(jsonPlayer.attackBonus);
        battlePlayer.setDefendBonus(jsonPlayer.defendBonus);
        battlePlayer.setEscapeBonus(jsonPlayer.escapeBonus);
        battlePlayer.setMagicAttackBonus(jsonPlayer.magicAttackBonus);
        battlePlayer.setMagicDefendBonus(jsonPlayer.magicDefendBonus);
        battlePlayer.setMagicEscapeBonus(jsonPlayer.magicEscapeBonus);
        return battlePlayer;
    }

    private static final class JsonBattle {
        @SerializedName(value="started")
        public boolean started;
        @SerializedName(value="player_list")
        public List<JsonPlayer> playerList = new ArrayList<JsonPlayer>();
        @SerializedName(value="attack_player")
        public String attackPlayer;
        @SerializedName(value="defend_player")
        public String defendPlayer;
        @SerializedName(value="escape_player")
        public String escapePlayer;
        @SerializedName(value="creator")
        public String creator;

        private JsonBattle() {
        }
    }

    private static final class JsonPlayer {
        @SerializedName(value="name")
        public String name;
        @SerializedName(value="hp")
        public int hp;
        @SerializedName(value="move_score")
        public int moveScore;
        @SerializedName(value="move")
        public boolean move;
        @SerializedName(value="ic_name")
        public String icName;
        @SerializedName(value="next")
        public boolean next;
        @SerializedName(value="attack")
        public boolean attack;
        @SerializedName(value="defend")
        public boolean defend;
        @SerializedName(value="escape")
        public boolean escape;
        @SerializedName(value="can_walk")
        public boolean canWalk;
        @SerializedName(value="frame")
        public String frame;
        @SerializedName(value="default_move_score")
        public int defaultMoveScore;
        @SerializedName(value="default_attack_count")
        public int defaultAttackCount;
        @SerializedName(value="attack_bonus")
        public int attackBonus;
        @SerializedName(value="defend_bonus")
        public int defendBonus;
        @SerializedName(value="escape_bonus")
        public int escapeBonus;
        @SerializedName(value="magic_attack_bonus")
        public int magicAttackBonus;
        @SerializedName(value="magic_defend_bonus")
        public int magicDefendBonus;
        @SerializedName(value="magic_escape_bonus")
        public int magicEscapeBonus;

        private JsonPlayer() {
        }
    }
}

