/*
 * Decompiled with CFR 0.152.
 */
package io.github.ultimateboomer.resolutioncontrol.util;

import io.github.ultimateboomer.resolutioncontrol.ResolutionControlMod;
import io.github.ultimateboomer.resolutioncontrol.util.Config;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import net.minecraft.class_310;

public class DynamicResolutionHandler {
    public static final DynamicResolutionHandler INSTANCE = new DynamicResolutionHandler();
    private final FloatList scales = new FloatArrayList();
    private int baseScale;
    private int timer = 10;
    private int currentScale;

    private DynamicResolutionHandler() {
        this.reset();
    }

    public void tick() {
        --this.timer;
        if (this.timer <= 0) {
            this.update();
        }
    }

    public void reset() {
        for (float i = Config.getInstance().drMinScale; i <= Config.getInstance().drMaxScale; i += Config.getInstance().drResStep) {
            this.scales.add(i);
            if (i != 1.0f) continue;
            this.currentScale = this.baseScale = this.scales.size() - 1;
        }
    }

    private void update() {
        class_310 client = class_310.method_1551();
        int smoothAmount = Config.getInstance().drFpsSmoothAmount;
        float sum = 0.0f;
        for (int i = client.field_1688.method_15250() - smoothAmount; i < client.field_1688.method_15250(); ++i) {
            sum += (float)client.field_1688.method_15246()[Math.floorMod(i, 240)];
        }
        float fps = 1.0E9f / (sum / (float)smoothAmount);
        if (fps > (float)Config.getInstance().drMaxFps) {
            this.setCurrentScale(Math.min(this.currentScale + 1, this.scales.size() - 1));
            this.timer = 15;
        } else if (fps < (float)Config.getInstance().drMinFps) {
            this.setCurrentScale(Math.max(this.currentScale - 1, 0));
            this.timer = 5;
        } else {
            this.timer = 3;
        }
    }

    private void setCurrentScale(int currentScale) {
        boolean equal = this.currentScale == currentScale;
        this.currentScale = currentScale;
        if (!equal) {
            ResolutionControlMod.getInstance().updateFramebufferSize();
        }
    }

    public double getCurrentScale() {
        return this.scales.getFloat(this.currentScale);
    }
}

