/*
 * Decompiled with CFR 0.152.
 */
package io.github.ultimateboomer.resolutioncontrol.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.ultimateboomer.resolutioncontrol.util.Config;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_310;

public final class ConfigHandler {
    public static final ConfigHandler instance = new ConfigHandler();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private Config config = new Config();

    private static File configFile() {
        return new File(class_310.method_1551().field_1697, "config/resolutioncontrol.json");
    }

    public Config getConfig() {
        return this.config;
    }

    private ConfigHandler() {
        this.loadConfig();
    }

    public void loadConfig() {
        File configFile = ConfigHandler.configFile();
        if (!configFile.exists()) {
            this.config = new Config();
            this.saveConfig();
        }
        try (FileReader reader = new FileReader(configFile);){
            this.config = (Config)this.gson.fromJson((Reader)reader, Config.class);
        }
        catch (IOException e) {
            System.err.println("Could not load config file at " + configFile.getAbsolutePath());
            e.printStackTrace();
        }
    }

    public void saveConfig() {
        File configFile = ConfigHandler.configFile();
        configFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(configFile);){
            writer.write(this.gson.toJson((Object)this.config));
        }
        catch (IOException e) {
            System.err.println("Could not save config file at " + configFile.getAbsolutePath());
            e.printStackTrace();
        }
    }
}

