/*
 * Decompiled with CFR 0.152.
 */
package io.github.ultimateboomer.resolutioncontrol.client.gui.screen;

import io.github.ultimateboomer.resolutioncontrol.client.gui.screen.SettingsScreen;
import io.github.ultimateboomer.resolutioncontrol.util.RCUtil;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.Nullable;

public class ScreenshotSettingsScreen
extends SettingsScreen {
    private static final double[] scaleValues = new double[]{0.1, 0.25, 0.5, 1.0, 2.0, 3.0, 4.0, 6.0, 8.0, 16.0};
    private static final class_2561 increaseText = class_2561.method_43470((String)"x2");
    private static final class_2561 decreaseText = class_2561.method_43470((String)"/2");
    private static final class_2561 resetText = class_2561.method_43470((String)"R");
    private class_342 widthTextField;
    private class_342 heightTextField;
    private class_4185 increaseButton;
    private class_4185 decreaseButton;
    private class_4185 resetButton;
    private class_4185 toggleOverrideSizeButton;
    private class_4185 toggleAlwaysAllocatedButton;
    private final int buttonSize = 20;
    private final int textFieldSize = 40;
    private long estimatedSize;

    public ScreenshotSettingsScreen(@Nullable class_437 parent) {
        super(ScreenshotSettingsScreen.text("settings.screenshot", new Object[0]), parent);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.toggleOverrideSizeButton = new class_4185.class_7840(ScreenshotSettingsScreen.getStateText(this.mod.getOverrideScreenshotScale()), button -> {
            this.mod.setOverrideScreenshotScale(!this.mod.getOverrideScreenshotScale());
            button.method_25355(ScreenshotSettingsScreen.getStateText(this.mod.getOverrideScreenshotScale()));
        }).method_46434(this.centerX + 20, this.centerY - 40, 50, 20).method_46431();
        this.method_37063((class_364)this.toggleOverrideSizeButton);
        this.toggleAlwaysAllocatedButton = new class_4185.class_7840(ScreenshotSettingsScreen.getStateText(this.mod.isScreenshotFramebufferAlwaysAllocated()), button -> {
            this.mod.setScreenshotFramebufferAlwaysAllocated(!this.mod.isScreenshotFramebufferAlwaysAllocated());
            button.method_25355(ScreenshotSettingsScreen.getStateText(this.mod.isScreenshotFramebufferAlwaysAllocated()));
        }).method_46434(this.centerX + 20, this.centerY - 20, 50, 20).method_46431();
        this.method_37063((class_364)this.toggleAlwaysAllocatedButton);
        this.widthTextField = new class_342(this.field_22787.field_1772, this.centerX - 85, this.centerY + 7, 40, 20, (class_2561)class_2561.method_43473());
        this.widthTextField.method_1852(String.valueOf(this.mod.getScreenshotWidth()));
        this.method_37063((class_364)this.widthTextField);
        this.heightTextField = new class_342(this.field_22787.field_1772, this.centerX - 35, this.centerY + 7, 40, 20, (class_2561)class_2561.method_43473());
        this.heightTextField.method_1852(String.valueOf(this.mod.getScreenshotHeight()));
        this.method_37063((class_364)this.heightTextField);
        this.increaseButton = new class_4185.class_7840(increaseText, button -> this.multiply(2.0)).method_46434(this.centerX - 10 - 60, this.centerY + 35, 20, 20).method_46431();
        this.method_37063((class_364)this.increaseButton);
        this.decreaseButton = new class_4185.class_7840(decreaseText, button -> this.multiply(0.5)).method_46434(this.centerX + 10 - 60, this.centerY + 35, 20, 20).method_46431();
        this.method_37063((class_364)this.decreaseButton);
        this.resetButton = new class_4185.class_7840(resetText, button -> this.resetSize()).method_46434(this.centerX + 30 - 60, this.centerY + 35, 20, 20).method_46431();
        this.method_37063((class_364)this.resetButton);
        this.calculateSize();
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.drawLeftAlignedString(matrices, "\u00a78" + ScreenshotSettingsScreen.text("settings.screenshot.overrideSize", new Object[0]).getString(), this.centerX - 75, this.centerY - 35, 0);
        this.drawLeftAlignedString(matrices, "\u00a78" + ScreenshotSettingsScreen.text("settings.screenshot.alwaysAllocated", new Object[0]).getString(), this.centerX - 75, this.centerY - 15, 0);
        this.drawLeftAlignedString(matrices, "\u00a78x", (float)this.centerX - 42.5f, this.centerY + 12, 0);
        this.drawLeftAlignedString(matrices, "\u00a78" + ScreenshotSettingsScreen.text("settings.main.estimate", new Object[0]).getString() + " " + RCUtil.formatMetric(this.estimatedSize) + "B", this.centerX + 25, this.centerY + 12, 0);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.calculateSize();
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25393() {
        this.widthTextField.method_1865();
        this.heightTextField.method_1865();
        super.method_25393();
    }

    @Override
    protected void applySettingsAndCleanup() {
        if (NumberUtils.isParsable((String)this.widthTextField.method_1882()) && NumberUtils.isParsable((String)this.heightTextField.method_1882())) {
            int newWidth = (int)Math.abs(Double.parseDouble(this.widthTextField.method_1882()));
            int newHeight = (int)Math.abs(Double.parseDouble(this.heightTextField.method_1882()));
            if (newWidth != this.mod.getScreenshotWidth() || newHeight != this.mod.getScreenshotHeight()) {
                this.mod.setScreenshotWidth(newWidth);
                this.mod.setScreenshotHeight(newHeight);
                if (this.mod.isScreenshotFramebufferAlwaysAllocated()) {
                    this.mod.initScreenshotFramebuffer();
                }
            }
        }
        super.applySettingsAndCleanup();
    }

    private void multiply(double mul) {
        if (NumberUtils.isParsable((String)this.widthTextField.method_1882()) && NumberUtils.isParsable((String)this.heightTextField.method_1882())) {
            this.widthTextField.method_1852(String.valueOf((int)Math.abs(Double.parseDouble(this.widthTextField.method_1882()) * mul)));
            this.heightTextField.method_1852(String.valueOf((int)Math.abs(Double.parseDouble(this.heightTextField.method_1882()) * mul)));
            this.calculateSize();
        }
    }

    private void resetSize() {
        this.mod.setScreenshotWidth(3840);
        this.mod.setScreenshotHeight(2160);
        this.widthTextField.method_1852(String.valueOf(this.mod.getScreenshotWidth()));
        this.heightTextField.method_1852(String.valueOf(this.mod.getScreenshotHeight()));
    }

    private void calculateSize() {
        if (NumberUtils.isParsable((String)this.widthTextField.method_1882()) && NumberUtils.isParsable((String)this.heightTextField.method_1882())) {
            this.estimatedSize = (long)(Double.parseDouble(this.widthTextField.method_1882()) * Double.parseDouble(this.heightTextField.method_1882()) * 8.0);
        }
    }
}

