/*
 * Decompiled with CFR 0.152.
 */
package io.github.ultimateboomer.resolutioncontrol.client.gui.screen;

import io.github.ultimateboomer.resolutioncontrol.ResolutionControlMod;
import io.github.ultimateboomer.resolutioncontrol.client.gui.screen.SettingsScreen;
import io.github.ultimateboomer.resolutioncontrol.util.RCUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.Nullable;

public final class MainSettingsScreen
extends SettingsScreen {
    private static final class_2960 backgroundTexture = ResolutionControlMod.identifier("textures/gui/settings.png");
    private static final float[] scaleValues = new float[]{0.0f, 0.01f, 0.025f, 0.05f, 0.1f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 3.0f, 4.0f, 6.0f, 8.0f};
    private static final double redValue = 2.0;
    private static final class_2561 increaseText = class_2561.method_43470((String)"+");
    private static final class_2561 decreaseText = class_2561.method_43470((String)"-");
    private static final class_2561 setText = class_2561.method_43470((String)"S");
    private static final class_2561 resetText = class_2561.method_43470((String)"R");
    private static final class_2561 cancelText = class_2561.method_43470((String)"C");
    private class_4185 increaseButton;
    private class_4185 decreaseButton;
    private class_4185 setButton;
    private class_4185 cancelOrResetButton;
    private class_342 entryTextField;
    private class_4185 upscaleAlgoButton;
    private class_4185 downscaleAlgoButton;
    private boolean manualEntry = false;

    public MainSettingsScreen(@Nullable class_437 parent) {
        super(MainSettingsScreen.text("settings.main", new Object[0]), parent);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int buttonSize = 20;
        int buttonOffset = buttonSize / 2;
        int buttonY = this.centerY + 15 - buttonSize / 2;
        int textFieldSize = 40;
        this.decreaseButton = new class_4185.class_7840(decreaseText, button -> this.changeScaleFactor(false)).method_46434(this.centerX - 55 - buttonOffset - buttonSize / 2, buttonY, buttonSize, buttonSize).method_46431();
        this.method_37063((class_364)this.decreaseButton);
        this.increaseButton = new class_4185.class_7840(increaseText, button -> this.changeScaleFactor(true)).method_46434(this.centerX - 55 + buttonOffset - buttonSize / 2, buttonY, buttonSize, buttonSize).method_46431();
        this.method_37063((class_364)this.increaseButton);
        this.setButton = new class_4185.class_7840(setText, button -> this.setManualEntry(!this.manualEntry, false)).method_46434(this.centerX - 55 - buttonOffset - buttonSize / 2, buttonY + buttonSize, buttonSize, buttonSize).method_46431();
        this.method_37063((class_364)this.setButton);
        this.cancelOrResetButton = new class_4185.class_7840(resetText, button -> {
            if (this.manualEntry) {
                this.setManualEntry(false, true);
            } else {
                this.mod.setScaleFactor(1.0f);
                this.updateButtons();
            }
        }).method_46434(this.centerX - 55 - buttonOffset + buttonSize / 2, buttonY + buttonSize, buttonSize, buttonSize).method_46431();
        this.method_37063((class_364)this.cancelOrResetButton);
        this.entryTextField = new class_342(this.field_22787.field_1772, this.centerX - 55 - textFieldSize / 2, this.centerY - 36, textFieldSize, buttonSize, (class_2561)class_2561.method_43473());
        this.entryTextField.method_1862(false);
        this.method_37063((class_364)this.entryTextField);
        this.upscaleAlgoButton = new class_4185.class_7840(this.mod.getUpscaleAlgorithm().getText(), button -> {
            this.mod.nextUpscaleAlgorithm();
            button.method_25355(this.mod.getUpscaleAlgorithm().getText());
        }).method_46434(this.centerX + 15, this.centerY - 28, 60, buttonSize).method_46431();
        this.method_37063((class_364)this.upscaleAlgoButton);
        this.downscaleAlgoButton = new class_4185.class_7840(this.mod.getDownscaleAlgorithm().getText(), button -> {
            this.mod.nextDownscaleAlgorithm();
            button.method_25355(this.mod.getDownscaleAlgorithm().getText());
        }).method_46434(this.centerX + 15, this.centerY + 8, 60, buttonSize).method_46431();
        this.method_37063((class_364)this.downscaleAlgoButton);
        this.updateButtons();
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.manualEntry) {
            if (keyCode == 257) {
                this.setManualEntry(false, false);
                return true;
            }
            if (keyCode == 256) {
                this.setManualEntry(false, true);
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float time) {
        super.method_25394(matrices, mouseX, mouseY, time);
        if (!this.manualEntry) {
            this.drawCenteredString(matrices, String.format("\u00a7%s%s\u00a7rx", (double)this.mod.getScaleFactor() > 2.0 ? "4" : "0", Float.valueOf(this.mod.getScaleFactor())), this.centerX - 55, this.centerY - 36, 0);
            this.drawCenteredString(matrices, String.format("\u00a78%sx%s\u00a7r", ResolutionControlMod.getInstance().getCurrentWidth(), ResolutionControlMod.getInstance().getCurrentHeight()), this.centerX - 55, this.centerY - 24, 0);
            this.drawCenteredString(matrices, "\u00a78" + MainSettingsScreen.text("settings.main.estimate", RCUtil.formatMetric(ResolutionControlMod.getInstance().getEstimatedMemory()) + "B").getString() + "\u00a7r", this.centerX - 55, this.centerY - 12, 0);
        }
        this.drawLeftAlignedString(matrices, "\u00a78" + MainSettingsScreen.text("settings.main.upscale", new Object[0]).getString(), this.centerX + 15, this.centerY - 40, 0);
        this.drawLeftAlignedString(matrices, "\u00a78" + MainSettingsScreen.text("settings.main.downscale", new Object[0]).getString(), this.centerX + 15, this.centerY - 5, 0);
    }

    public void method_25393() {
        if (this.manualEntry) {
            if (!this.method_25399().equals(this.entryTextField)) {
                this.method_20086((class_364)this.entryTextField);
            }
            if (!this.entryTextField.field_22763) {
                this.entryTextField.field_22763 = true;
            }
        }
        this.entryTextField.method_1865();
        super.method_25393();
    }

    private void changeScaleFactor(boolean add) {
        float currentScale = this.mod.getScaleFactor();
        int nextIndex = ArrayUtils.indexOf((float[])scaleValues, (float)currentScale);
        if (nextIndex == -1) {
            for (int i = -1; i < scaleValues.length; ++i) {
                double scale2;
                double scale1 = i == -1 ? 0.0 : (double)scaleValues[i];
                double d = scale2 = i == scaleValues.length - 1 ? Double.POSITIVE_INFINITY : (double)scaleValues[i + 1];
                if (!((double)currentScale > scale1) || !((double)currentScale < scale2)) continue;
                nextIndex = i + (add ? 1 : 0);
                break;
            }
        } else {
            nextIndex += add ? 1 : -1;
        }
        this.mod.setScaleFactor(scaleValues[nextIndex]);
        this.updateButtons();
    }

    private void updateButtons() {
        this.increaseButton.field_22763 = this.mod.getScaleFactor() < scaleValues[scaleValues.length - 1];
        this.decreaseButton.field_22763 = this.mod.getScaleFactor() > scaleValues[0];
    }

    public void setManualEntry(boolean manualEntry, boolean cancel) {
        this.manualEntry = manualEntry;
        if (manualEntry) {
            this.entryTextField.method_1852(String.valueOf(this.mod.getScaleFactor()));
            this.entryTextField.method_1862(true);
            this.entryTextField.method_1875(0);
            this.entryTextField.method_1884(this.entryTextField.method_1882().length());
            this.entryTextField.field_22763 = true;
            this.cancelOrResetButton.method_25355(cancelText);
            this.increaseButton.field_22763 = false;
            this.decreaseButton.field_22763 = false;
            this.method_20086((class_364)this.entryTextField);
        } else {
            String text;
            if (!cancel && NumberUtils.isParsable((String)(text = this.entryTextField.method_1882()))) {
                float value = Math.abs(Float.parseFloat(text));
                this.mod.setScaleFactor(value);
            }
            this.entryTextField.method_1862(false);
            this.setButton.method_25355(setText);
            this.cancelOrResetButton.method_25355(resetText);
            this.increaseButton.field_22763 = true;
            this.decreaseButton.field_22763 = true;
            this.updateButtons();
        }
    }
}

