/*
 * Decompiled with CFR 0.152.
 */
package io.github.ultimateboomer.resolutioncontrol;

import io.github.ultimateboomer.resolutioncontrol.client.gui.screen.MainSettingsScreen;
import io.github.ultimateboomer.resolutioncontrol.client.gui.screen.SettingsScreen;
import io.github.ultimateboomer.resolutioncontrol.util.Config;
import io.github.ultimateboomer.resolutioncontrol.util.ConfigHandler;
import io.github.ultimateboomer.resolutioncontrol.util.DynamicResolutionHandler;
import io.github.ultimateboomer.resolutioncontrol.util.RCUtil;
import io.github.ultimateboomer.resolutioncontrol.util.ScalingAlgorithm;
import java.io.File;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_6364;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ResolutionControlMod
implements ModInitializer {
    public static final String MOD_ID = "resolutioncontrol";
    public static final String MOD_NAME = "ResolutionControl+";
    public static final Logger LOGGER = LogManager.getLogger((String)"ResolutionControl+");
    private static final class_310 client = class_310.method_1551();
    private static ResolutionControlMod instance;
    private static final String SCREENSHOT_PREFIX = "fb";
    private boolean optifineInstalled;
    private class_304 settingsKey;
    private class_304 screenshotKey;
    private boolean shouldScale = false;
    @Nullable
    private class_276 framebuffer;
    @Nullable
    private class_276 screenshotFrameBuffer;
    @Nullable
    private class_276 clientFramebuffer;
    private Set<class_276> minecraftFramebuffers;
    private Class<? extends SettingsScreen> lastSettingsScreen = MainSettingsScreen.class;
    private int currentWidth;
    private int currentHeight;
    private long estimatedMemory;
    private boolean screenshot = false;
    private int lastWidth;
    private int lastHeight;

    public static class_2960 identifier(String path) {
        return new class_2960(MOD_ID, path);
    }

    public static ResolutionControlMod getInstance() {
        return instance;
    }

    public void onInitialize() {
        instance = this;
        this.settingsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.resolutioncontrol.settings", class_3675.class_307.field_1668, 79, "key.categories.resolutioncontrol"));
        this.screenshotKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.resolutioncontrol.screenshot", class_3675.class_307.field_1668, -1, "key.categories.resolutioncontrol"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (this.settingsKey.method_1436()) {
                client.method_1507((class_437)SettingsScreen.getScreen(this.lastSettingsScreen));
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (this.screenshotKey.method_1436()) {
                if (this.getOverrideScreenshotScale()) {
                    this.screenshot = true;
                    client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"resolutioncontrol.screenshot.wait"), false);
                    continue;
                }
                this.saveScreenshot(this.framebuffer);
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (ConfigHandler.instance.getConfig().enableDynamicResolution && client.field_1687 != null && this.getWindow().method_4499() != -32000) {
                DynamicResolutionHandler.INSTANCE.tick();
            }
        });
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (ConfigHandler.instance.getConfig().enableDynamicResolution) {
                DynamicResolutionHandler.INSTANCE.reset();
            }
        });
        this.optifineInstalled = FabricLoader.getInstance().isModLoaded("optifabric");
    }

    private void saveScreenshot(class_276 fb) {
        class_318.method_22690((File)ResolutionControlMod.client.field_1697, (String)RCUtil.getScreenshotFilename(ResolutionControlMod.client.field_1697).toString(), (class_276)fb, text -> ResolutionControlMod.client.field_1724.method_7353(text, false));
    }

    public void setShouldScale(boolean shouldScale) {
        if (shouldScale == this.shouldScale) {
            return;
        }
        class_1041 window = this.getWindow();
        if (this.framebuffer == null) {
            this.shouldScale = true;
            this.framebuffer = new class_6364(window.method_4489(), window.method_4506());
            this.calculateSize();
        }
        this.shouldScale = shouldScale;
        client.method_16011().method_15405(shouldScale ? "startScaling" : "finishScaling");
        if (shouldScale) {
            this.clientFramebuffer = client.method_1522();
            if (this.screenshot) {
                this.resizeMinecraftFramebuffers();
                if (!this.isScreenshotFramebufferAlwaysAllocated() && this.screenshotFrameBuffer != null) {
                    this.screenshotFrameBuffer.method_1238();
                }
                if (this.screenshotFrameBuffer == null) {
                    this.initScreenshotFramebuffer();
                }
                this.setClientFramebuffer(this.screenshotFrameBuffer);
                this.screenshotFrameBuffer.method_1235(true);
            } else {
                this.setClientFramebuffer(this.framebuffer);
                this.framebuffer.method_1235(true);
            }
        } else {
            this.setClientFramebuffer(this.clientFramebuffer);
            client.method_1522().method_1235(true);
            if (this.screenshot) {
                this.saveScreenshot(this.screenshotFrameBuffer);
                if (!this.isScreenshotFramebufferAlwaysAllocated()) {
                    this.screenshotFrameBuffer.method_1238();
                    this.screenshotFrameBuffer = null;
                }
                this.screenshot = false;
                this.resizeMinecraftFramebuffers();
            } else {
                this.framebuffer.method_1237(window.method_4489(), window.method_4506());
            }
        }
        client.method_16011().method_15405("level");
    }

    public void initMinecraftFramebuffers() {
        if (this.minecraftFramebuffers != null) {
            this.minecraftFramebuffers.clear();
        } else {
            this.minecraftFramebuffers = new HashSet<class_276>();
        }
        this.minecraftFramebuffers.add(ResolutionControlMod.client.field_1769.method_22990());
        this.minecraftFramebuffers.add(ResolutionControlMod.client.field_1769.method_29360());
        this.minecraftFramebuffers.add(ResolutionControlMod.client.field_1769.method_29361());
        this.minecraftFramebuffers.add(ResolutionControlMod.client.field_1769.method_29362());
        this.minecraftFramebuffers.add(ResolutionControlMod.client.field_1769.method_29363());
        this.minecraftFramebuffers.add(ResolutionControlMod.client.field_1769.method_29364());
        this.minecraftFramebuffers.remove(null);
    }

    public class_276 getFramebuffer() {
        return this.framebuffer;
    }

    public void initScreenshotFramebuffer() {
        if (Objects.nonNull(this.screenshotFrameBuffer)) {
            this.screenshotFrameBuffer.method_1238();
        }
        this.screenshotFrameBuffer = new class_6364(this.getScreenshotWidth(), this.getScreenshotHeight());
    }

    public float getScaleFactor() {
        return Config.getInstance().scaleFactor;
    }

    public void setScaleFactor(float scaleFactor) {
        Config.getInstance().scaleFactor = scaleFactor;
        this.updateFramebufferSize();
        ConfigHandler.instance.saveConfig();
    }

    public ScalingAlgorithm getUpscaleAlgorithm() {
        return Config.getInstance().upscaleAlgorithm;
    }

    public void setUpscaleAlgorithm(ScalingAlgorithm algorithm) {
        if (algorithm == Config.getInstance().upscaleAlgorithm) {
            return;
        }
        Config.getInstance().upscaleAlgorithm = algorithm;
        this.onResolutionChanged();
        ConfigHandler.instance.saveConfig();
    }

    public void nextUpscaleAlgorithm() {
        ScalingAlgorithm currentAlgorithm = this.getUpscaleAlgorithm();
        if (currentAlgorithm.equals((Object)ScalingAlgorithm.NEAREST)) {
            this.setUpscaleAlgorithm(ScalingAlgorithm.LINEAR);
        } else {
            this.setUpscaleAlgorithm(ScalingAlgorithm.NEAREST);
        }
    }

    public ScalingAlgorithm getDownscaleAlgorithm() {
        return Config.getInstance().downscaleAlgorithm;
    }

    public void setDownscaleAlgorithm(ScalingAlgorithm algorithm) {
        if (algorithm == Config.getInstance().downscaleAlgorithm) {
            return;
        }
        Config.getInstance().downscaleAlgorithm = algorithm;
        this.onResolutionChanged();
        ConfigHandler.instance.saveConfig();
    }

    public void nextDownscaleAlgorithm() {
        ScalingAlgorithm currentAlgorithm = this.getDownscaleAlgorithm();
        if (currentAlgorithm.equals((Object)ScalingAlgorithm.NEAREST)) {
            this.setDownscaleAlgorithm(ScalingAlgorithm.LINEAR);
        } else {
            this.setDownscaleAlgorithm(ScalingAlgorithm.NEAREST);
        }
    }

    public double getCurrentScaleFactor() {
        return this.shouldScale ? (Config.getInstance().enableDynamicResolution ? DynamicResolutionHandler.INSTANCE.getCurrentScale() : (double)Config.getInstance().scaleFactor) : 1.0;
    }

    public boolean getOverrideScreenshotScale() {
        return Config.getInstance().overrideScreenshotScale;
    }

    public void setOverrideScreenshotScale(boolean value) {
        Config.getInstance().overrideScreenshotScale = value;
        if (value && this.isScreenshotFramebufferAlwaysAllocated()) {
            this.initScreenshotFramebuffer();
        } else if (this.screenshotFrameBuffer != null) {
            this.screenshotFrameBuffer.method_1238();
            this.screenshotFrameBuffer = null;
        }
    }

    public int getScreenshotWidth() {
        return Math.max(Config.getInstance().screenshotWidth, 1);
    }

    public void setScreenshotWidth(int width) {
        Config.getInstance().screenshotWidth = width;
    }

    public int getScreenshotHeight() {
        return Math.max(Config.getInstance().screenshotHeight, 1);
    }

    public void setScreenshotHeight(int height) {
        Config.getInstance().screenshotHeight = height;
    }

    public boolean isScreenshotFramebufferAlwaysAllocated() {
        return Config.getInstance().screenshotFramebufferAlwaysAllocated;
    }

    public void setScreenshotFramebufferAlwaysAllocated(boolean value) {
        Config.getInstance().screenshotFramebufferAlwaysAllocated = value;
        if (value) {
            if (this.getOverrideScreenshotScale() && Objects.isNull(this.screenshotFrameBuffer)) {
                this.initScreenshotFramebuffer();
            }
        } else if (this.screenshotFrameBuffer != null) {
            this.screenshotFrameBuffer.method_1238();
            this.screenshotFrameBuffer = null;
        }
    }

    public void setEnableDynamicResolution(boolean enableDynamicResolution) {
        Config.getInstance().enableDynamicResolution = enableDynamicResolution;
    }

    public void onResolutionChanged() {
        if (this.getWindow() == null) {
            return;
        }
        LOGGER.info("Size changed to {}x{} {}x{} {}x{}", (Object)this.getWindow().method_4489(), (Object)this.getWindow().method_4506(), (Object)this.getWindow().method_4480(), (Object)this.getWindow().method_4507(), (Object)this.getWindow().method_4486(), (Object)this.getWindow().method_4502());
        this.updateFramebufferSize();
        this.lastWidth = this.getWindow().method_4502();
        this.lastHeight = this.getWindow().method_4502();
    }

    public void updateFramebufferSize() {
        if (this.framebuffer == null) {
            return;
        }
        this.resize(this.framebuffer);
        this.resize(ResolutionControlMod.client.field_1769.method_22990());
        this.calculateSize();
    }

    public void resizeMinecraftFramebuffers() {
        this.initMinecraftFramebuffers();
        this.minecraftFramebuffers.forEach(this::resize);
    }

    public void calculateSize() {
        this.currentWidth = this.framebuffer.field_1482;
        this.currentHeight = this.framebuffer.field_1481;
        this.estimatedMemory = (long)this.currentWidth * (long)this.currentHeight * 8L;
    }

    public void resize(@Nullable class_276 framebuffer) {
        if (framebuffer == null) {
            return;
        }
        boolean prev = this.shouldScale;
        this.shouldScale = true;
        if (this.screenshot) {
            framebuffer.method_1234(this.getScreenshotWidth(), this.getScreenshotHeight(), class_310.field_1703);
        } else {
            framebuffer.method_1234(this.getWindow().method_4489(), this.getWindow().method_4506(), class_310.field_1703);
        }
        this.shouldScale = prev;
    }

    private class_1041 getWindow() {
        return client.method_22683();
    }

    private void setClientFramebuffer(class_276 framebuffer) {
        ResolutionControlMod.client.field_1689 = framebuffer;
    }

    public class_304 getSettingsKey() {
        return this.settingsKey;
    }

    public int getCurrentWidth() {
        return this.currentWidth;
    }

    public int getCurrentHeight() {
        return this.currentHeight;
    }

    public long getEstimatedMemory() {
        return this.estimatedMemory;
    }

    public boolean isScreenshotting() {
        return this.screenshot;
    }

    public boolean isOptifineInstalled() {
        return this.optifineInstalled;
    }

    public void saveSettings() {
        ConfigHandler.instance.saveConfig();
    }

    public void setLastSettingsScreen(Class<? extends SettingsScreen> ordinal) {
        this.lastSettingsScreen = ordinal;
    }
}

