/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.physics.PxFilterData;
import physx.vehicle.PxVehicleAntiRollBarData;
import physx.vehicle.PxVehicleSuspensionData;
import physx.vehicle.PxVehicleTireData;
import physx.vehicle.PxVehicleTireLoadFilterData;
import physx.vehicle.PxVehicleWheelData;
import physx.vehicle.PxVehicleWheelsSimFlags;

public class PxVehicleWheelsSimData
extends NativeObject {
    protected PxVehicleWheelsSimData() {
    }

    public static PxVehicleWheelsSimData wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheelsSimData(address) : null;
    }

    protected PxVehicleWheelsSimData(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        PxVehicleWheelsSimData._delete_native_instance(this.address);
        this.address = 0L;
    }

    private static native long _delete_native_instance(long var0);

    public static PxVehicleWheelsSimData allocate(int nbWheels) {
        return PxVehicleWheelsSimData.wrapPointer(PxVehicleWheelsSimData._allocate(nbWheels));
    }

    private static native long _allocate(int var0);

    public void setChassisMass(float chassisMass) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setChassisMass(this.address, chassisMass);
    }

    private static native void _setChassisMass(long var0, float var2);

    public void free() {
        this.checkNotNull();
        PxVehicleWheelsSimData._free(this.address);
    }

    private static native void _free(long var0);

    public void copy(PxVehicleWheelsSimData src, int srcWheel, int trgWheel) {
        this.checkNotNull();
        PxVehicleWheelsSimData._copy(this.address, src.getAddress(), srcWheel, trgWheel);
    }

    private static native void _copy(long var0, long var2, int var4, int var5);

    public int getNbWheels() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbWheels(this.address);
    }

    private static native int _getNbWheels(long var0);

    public PxVehicleSuspensionData getSuspensionData(int id) {
        this.checkNotNull();
        return PxVehicleSuspensionData.wrapPointer(PxVehicleWheelsSimData._getSuspensionData(this.address, id));
    }

    private static native long _getSuspensionData(long var0, int var2);

    public PxVehicleWheelData getWheelData(int id) {
        this.checkNotNull();
        return PxVehicleWheelData.wrapPointer(PxVehicleWheelsSimData._getWheelData(this.address, id));
    }

    private static native long _getWheelData(long var0, int var2);

    public PxVehicleTireData getTireData(int id) {
        this.checkNotNull();
        return PxVehicleTireData.wrapPointer(PxVehicleWheelsSimData._getTireData(this.address, id));
    }

    private static native long _getTireData(long var0, int var2);

    public PxVec3 getSuspTravelDirection(int id) {
        this.checkNotNull();
        return PxVec3.wrapPointer(PxVehicleWheelsSimData._getSuspTravelDirection(this.address, id));
    }

    private static native long _getSuspTravelDirection(long var0, int var2);

    public PxVec3 getSuspForceAppPointOffset(int id) {
        this.checkNotNull();
        return PxVec3.wrapPointer(PxVehicleWheelsSimData._getSuspForceAppPointOffset(this.address, id));
    }

    private static native long _getSuspForceAppPointOffset(long var0, int var2);

    public PxVec3 getTireForceAppPointOffset(int id) {
        this.checkNotNull();
        return PxVec3.wrapPointer(PxVehicleWheelsSimData._getTireForceAppPointOffset(this.address, id));
    }

    private static native long _getTireForceAppPointOffset(long var0, int var2);

    public PxVec3 getWheelCentreOffset(int id) {
        this.checkNotNull();
        return PxVec3.wrapPointer(PxVehicleWheelsSimData._getWheelCentreOffset(this.address, id));
    }

    private static native long _getWheelCentreOffset(long var0, int var2);

    public int getWheelShapeMapping(int wheelId) {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getWheelShapeMapping(this.address, wheelId);
    }

    private static native int _getWheelShapeMapping(long var0, int var2);

    public PxFilterData getSceneQueryFilterData(int suspId) {
        this.checkNotNull();
        return PxFilterData.wrapPointer(PxVehicleWheelsSimData._getSceneQueryFilterData(this.address, suspId));
    }

    private static native long _getSceneQueryFilterData(long var0, int var2);

    public int getNbAntiRollBars() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbAntiRollBars(this.address);
    }

    private static native int _getNbAntiRollBars(long var0);

    public PxVehicleAntiRollBarData getAntiRollBarData(int antiRollId) {
        this.checkNotNull();
        return PxVehicleAntiRollBarData.wrapPointer(PxVehicleWheelsSimData._getAntiRollBarData(this.address, antiRollId));
    }

    private static native long _getAntiRollBarData(long var0, int var2);

    public PxVehicleTireLoadFilterData getTireLoadFilterData() {
        this.checkNotNull();
        return PxVehicleTireLoadFilterData.wrapPointer(PxVehicleWheelsSimData._getTireLoadFilterData(this.address));
    }

    private static native long _getTireLoadFilterData(long var0);

    public void setSuspensionData(int id, PxVehicleSuspensionData susp) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setSuspensionData(this.address, id, susp.getAddress());
    }

    private static native void _setSuspensionData(long var0, int var2, long var3);

    public void setWheelData(int id, PxVehicleWheelData wheel) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setWheelData(this.address, id, wheel.getAddress());
    }

    private static native void _setWheelData(long var0, int var2, long var3);

    public void setTireData(int id, PxVehicleTireData tire) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setTireData(this.address, id, tire.getAddress());
    }

    private static native void _setTireData(long var0, int var2, long var3);

    public void setSuspTravelDirection(int id, PxVec3 dir) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setSuspTravelDirection(this.address, id, dir.getAddress());
    }

    private static native void _setSuspTravelDirection(long var0, int var2, long var3);

    public void setSuspForceAppPointOffset(int id, PxVec3 offset) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setSuspForceAppPointOffset(this.address, id, offset.getAddress());
    }

    private static native void _setSuspForceAppPointOffset(long var0, int var2, long var3);

    public void setTireForceAppPointOffset(int id, PxVec3 offset) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setTireForceAppPointOffset(this.address, id, offset.getAddress());
    }

    private static native void _setTireForceAppPointOffset(long var0, int var2, long var3);

    public void setWheelCentreOffset(int id, PxVec3 offset) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setWheelCentreOffset(this.address, id, offset.getAddress());
    }

    private static native void _setWheelCentreOffset(long var0, int var2, long var3);

    public void setWheelShapeMapping(int wheelId, int shapeId) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setWheelShapeMapping(this.address, wheelId, shapeId);
    }

    private static native void _setWheelShapeMapping(long var0, int var2, int var3);

    public void setSceneQueryFilterData(int suspId, PxFilterData sqFilterData) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setSceneQueryFilterData(this.address, suspId, sqFilterData.getAddress());
    }

    private static native void _setSceneQueryFilterData(long var0, int var2, long var3);

    public void setTireLoadFilterData(PxVehicleTireLoadFilterData tireLoadFilter) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setTireLoadFilterData(this.address, tireLoadFilter.getAddress());
    }

    private static native void _setTireLoadFilterData(long var0, long var2);

    public int addAntiRollBarData(PxVehicleAntiRollBarData antiRoll) {
        this.checkNotNull();
        return PxVehicleWheelsSimData._addAntiRollBarData(this.address, antiRoll.getAddress());
    }

    private static native int _addAntiRollBarData(long var0, long var2);

    public void disableWheel(int wheel) {
        this.checkNotNull();
        PxVehicleWheelsSimData._disableWheel(this.address, wheel);
    }

    private static native void _disableWheel(long var0, int var2);

    public void enableWheel(int wheel) {
        this.checkNotNull();
        PxVehicleWheelsSimData._enableWheel(this.address, wheel);
    }

    private static native void _enableWheel(long var0, int var2);

    public boolean getIsWheelDisabled(int wheel) {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getIsWheelDisabled(this.address, wheel);
    }

    private static native boolean _getIsWheelDisabled(long var0, int var2);

    public void setSubStepCount(float thresholdLongitudinalSpeed, int lowForwardSpeedSubStepCount, int highForwardSpeedSubStepCount) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setSubStepCount(this.address, thresholdLongitudinalSpeed, lowForwardSpeedSubStepCount, highForwardSpeedSubStepCount);
    }

    private static native void _setSubStepCount(long var0, float var2, int var3, int var4);

    public void setMinLongSlipDenominator(float minLongSlipDenominator) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setMinLongSlipDenominator(this.address, minLongSlipDenominator);
    }

    private static native void _setMinLongSlipDenominator(long var0, float var2);

    public void setFlags(PxVehicleWheelsSimFlags flags) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setFlags(this.address, flags.getAddress());
    }

    private static native void _setFlags(long var0, long var2);

    public PxVehicleWheelsSimFlags getFlags() {
        this.checkNotNull();
        return PxVehicleWheelsSimFlags.wrapPointer(PxVehicleWheelsSimData._getFlags(this.address));
    }

    private static native long _getFlags(long var0);

    public int getNbWheels4() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbWheels4(this.address);
    }

    private static native int _getNbWheels4(long var0);

    public int getNbSuspensionData() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbSuspensionData(this.address);
    }

    private static native int _getNbSuspensionData(long var0);

    public int getNbWheelData() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbWheelData(this.address);
    }

    private static native int _getNbWheelData(long var0);

    public int getNbSuspTravelDirection() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbSuspTravelDirection(this.address);
    }

    private static native int _getNbSuspTravelDirection(long var0);

    public int getNbTireData() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbTireData(this.address);
    }

    private static native int _getNbTireData(long var0);

    public int getNbSuspForceAppPointOffset() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbSuspForceAppPointOffset(this.address);
    }

    private static native int _getNbSuspForceAppPointOffset(long var0);

    public int getNbTireForceAppPointOffset() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbTireForceAppPointOffset(this.address);
    }

    private static native int _getNbTireForceAppPointOffset(long var0);

    public int getNbWheelCentreOffset() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbWheelCentreOffset(this.address);
    }

    private static native int _getNbWheelCentreOffset(long var0);

    public int getNbWheelShapeMapping() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbWheelShapeMapping(this.address);
    }

    private static native int _getNbWheelShapeMapping(long var0);

    public int getNbSceneQueryFilterData() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbSceneQueryFilterData(this.address);
    }

    private static native int _getNbSceneQueryFilterData(long var0);

    public float getMinLongSlipDenominator() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getMinLongSlipDenominator(this.address);
    }

    private static native float _getMinLongSlipDenominator(long var0);

    public void setThresholdLongSpeed(float f) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setThresholdLongSpeed(this.address, f);
    }

    private static native void _setThresholdLongSpeed(long var0, float var2);

    public float getThresholdLongSpeed() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getThresholdLongSpeed(this.address);
    }

    private static native float _getThresholdLongSpeed(long var0);

    public void setLowForwardSpeedSubStepCount(int f) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setLowForwardSpeedSubStepCount(this.address, f);
    }

    private static native void _setLowForwardSpeedSubStepCount(long var0, int var2);

    public int getLowForwardSpeedSubStepCount() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getLowForwardSpeedSubStepCount(this.address);
    }

    private static native int _getLowForwardSpeedSubStepCount(long var0);

    public void setHighForwardSpeedSubStepCount(int f) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setHighForwardSpeedSubStepCount(this.address, f);
    }

    private static native void _setHighForwardSpeedSubStepCount(long var0, int var2);

    public int getHighForwardSpeedSubStepCount() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getHighForwardSpeedSubStepCount(this.address);
    }

    private static native int _getHighForwardSpeedSubStepCount(long var0);

    public void setWheelEnabledState(int wheel, boolean state) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setWheelEnabledState(this.address, wheel, state);
    }

    private static native void _setWheelEnabledState(long var0, int var2, boolean var3);

    public boolean getWheelEnabledState(int wheel) {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getWheelEnabledState(this.address, wheel);
    }

    private static native boolean _getWheelEnabledState(long var0, int var2);

    public int getNbWheelEnabledState() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbWheelEnabledState(this.address);
    }

    private static native int _getNbWheelEnabledState(long var0);

    public int getNbAntiRollBars4() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbAntiRollBars4(this.address);
    }

    private static native int _getNbAntiRollBars4(long var0);

    public int getNbAntiRollBarData() {
        this.checkNotNull();
        return PxVehicleWheelsSimData._getNbAntiRollBarData(this.address);
    }

    private static native int _getNbAntiRollBarData(long var0);

    public void setAntiRollBarData(int id, PxVehicleAntiRollBarData antiRoll) {
        this.checkNotNull();
        PxVehicleWheelsSimData._setAntiRollBarData(this.address, id, antiRoll.getAddress());
    }

    private static native void _setAntiRollBarData(long var0, int var2, long var3);
}

