/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.compat.Optifine;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.EntityOcean;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.RenderConstraint;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1690;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.joml.Matrix4d;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class OceanPhysicsDisplacementConstraint
extends RenderConstraint {
    private class_1297 entity;
    private Matrix4d gravityTransformation;
    private Vector3d gravity;

    public OceanPhysicsDisplacementConstraint(class_1297 entity) {
        this.entity = entity;
        this.gravityTransformation = new Matrix4d();
        this.gravity = new Vector3d();
    }

    @Override
    public void render(class_4587 matrixStack, double renderPercent, VerletSimulation simulation) {
        if (ConfigClient.areOceanPhysicsEnabled()) {
            double px = class_3532.method_16436((double)renderPercent, (double)this.entity.field_6038, (double)this.entity.method_23317());
            double py = class_3532.method_16436((double)renderPercent, (double)this.entity.field_5971, (double)this.entity.method_23318());
            double pz = class_3532.method_16436((double)renderPercent, (double)this.entity.field_5989, (double)this.entity.method_23321());
            OceanWorld oceanWorld = PhysicsMod.getInstance(this.entity.field_6002).getPhysicsWorld().getOceanWorld();
            float yRot = class_3532.method_16439((float)((float)renderPercent), (float)this.entity.field_5982, (float)this.entity.method_36454());
            Vector3d offset = simulation.getOffset();
            oceanWorld.computeEntityOffset(matrixStack.method_23760().method_23761(), matrixStack.method_23760().method_23762(), this.entity.field_6002, this.entity, px, py, pz, offset.x, offset.y, offset.z, yRot, (float)renderPercent);
            this.calculateGravityTransformation(renderPercent);
            RenderSystem.applyModelViewMatrix();
            if (StarterClient.optifabric && Optifine.areShadersEnabled()) {
                Optifine.setModelViewMatrix(RenderSystem.getModelViewMatrix());
            }
        }
        super.render(matrixStack, renderPercent, simulation);
    }

    private void calculateGravityTransformation(double renderPercent) {
        float actualYRot = 0.0f;
        class_1297 vehicle = this.entity.method_5854();
        EntityOcean entityOcean = (EntityOcean)this.entity;
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            actualYRot = class_3532.method_17821((float)((float)renderPercent), (float)living.field_6220, (float)living.field_6283);
        } else {
            actualYRot = this.entity.method_5705((float)renderPercent);
        }
        float currentYRot = (float)(-Math.toRadians(actualYRot - (float)Math.PI));
        double forwardZ = Math.cos(currentYRot);
        double forwardX = Math.sin(currentYRot);
        double leftX = forwardZ;
        double leftZ = -forwardX;
        double roll = entityOcean.getPhysicsRoll((float)renderPercent);
        double pitch = entityOcean.getPhysicsPitch((float)renderPercent);
        float diffRot = 0.0f;
        if (vehicle != null && vehicle instanceof class_1690) {
            diffRot = vehicle.method_5705((float)renderPercent) - actualYRot;
        }
        this.gravityTransformation.identity();
        this.gravityTransformation.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-diffRot));
        this.gravityTransformation.rotate((Quaternionfc)class_7833.method_46356((Vector3f)new Vector3f((float)forwardX, 0.0f, (float)forwardZ)).rotationDegrees((float)(-Math.toDegrees(roll))));
        this.gravityTransformation.rotate((Quaternionfc)class_7833.method_46356((Vector3f)new Vector3f((float)leftX, 0.0f, (float)leftZ)).rotationDegrees((float)Math.toDegrees(pitch)));
        this.gravityTransformation.invert();
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        super.updateBefore(delta, simulation);
        this.gravity.set((Vector3dc)simulation.getGravity());
        this.gravityTransformation.transformDirection(simulation.getGravity());
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
        super.updateAfter(delta, simulation);
        simulation.setGravity(this.gravity);
    }
}

