/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.vines;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.diebuddies.config.ConfigVines;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.settings.cloth.BaseEntry;
import net.diebuddies.physics.settings.gui.EditButton;
import net.diebuddies.physics.settings.gui.RemoveButton;
import net.diebuddies.physics.settings.gui.legacy.LegacyObjectSelectionList;
import net.diebuddies.physics.settings.vines.BlockEntry;
import net.diebuddies.physics.settings.vines.VineEditScreen;
import net.diebuddies.physics.vines.DynamicSetting;
import net.diebuddies.physics.vines.VineHelper;
import net.diebuddies.physics.vines.VineSetting;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class VineObjectSelectionList
extends LegacyObjectSelectionList<BaseEntry> {
    private Map<class_2248, DynamicSetting> settings;
    private Map<BaseEntry, class_4185> buttons1 = new Object2ObjectOpenHashMap();
    private Map<BaseEntry, class_4185> buttons2 = new Object2ObjectOpenHashMap();

    public VineObjectSelectionList(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
        super(minecraft, width, height, top, bottom, itemHeight);
        this.settings = ConfigVines.configSettings;
        this.refreshEntries();
    }

    public void refreshEntries() {
        this.clearEntries();
        this.buttons1 = new Object2ObjectOpenHashMap();
        this.buttons2 = new Object2ObjectOpenHashMap();
        for (class_2248 block : this.settings.keySet()) {
            String id = PhysicsMod.registeredBlocks.get(block);
            if (id == null) continue;
            BlockEntry entry = new BlockEntry(this, id, block);
            this.addEntry(entry);
        }
    }

    public void addSetting(class_2248 block, VineSetting setting) {
        this.settings.put(block, setting);
        this.refreshEntries();
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float tickDelta) {
        super.method_25394(poseStack, mouseX, mouseY, tickDelta);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        return super.method_25402(mouseX, mouseY, mouseButton) | this.listButtons(null, mouseX, mouseY, mouseButton, 0.0f, false);
    }

    public boolean listButtons(class_4587 poseStack, double mouseX, double mouseY, int mouseButton, float tickDelta, boolean render) {
        boolean clicked = false;
        for (int i = 0; i < this.getItemCount(); ++i) {
            int entryY = this.getRowTop(i);
            int p = this.getRowBottomCustom(i);
            if (p < this.y0 || entryY > this.y1) continue;
            int entryHeight = this.itemHeight - 4;
            BaseEntry entry = (BaseEntry)this.getEntry(i);
            class_4185 editButton = this.buttons1.computeIfAbsent(entry, key -> new EditButton(this.getRowRight() + 3, entryY, entryHeight, entryHeight - 1, (class_2561)class_2561.method_43470((String)""), source -> {
                class_2248 block = (class_2248)((BlockEntry)entry).getUserData();
                if (block != null) {
                    this.minecraft.method_1507((class_437)new VineEditScreen(this.minecraft.field_1755, this.minecraft.field_1690, this.settings.get(block), block));
                }
            }));
            editButton.method_46421(this.getRowRight() + 3);
            editButton.method_46419(entryY);
            class_4185 removeButton = this.buttons2.computeIfAbsent(entry, key -> new RemoveButton(this.getRowRight() + 26, entryY, entryHeight, entryHeight - 1, (class_2561)class_2561.method_43470((String)""), source -> {
                this.removeEntry(entry);
                this.settings.remove((class_2248)entry.getUserData());
                ConfigVines.save();
                VineHelper.initFromConfigSettings();
            }));
            removeButton.method_46421(this.getRowRight() + 26);
            removeButton.method_46419(entryY);
            if (!render) {
                if (editButton.method_25402(mouseX, mouseY, mouseButton)) {
                    return true;
                }
                if (!removeButton.method_25402(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
            removeButton.method_25394(poseStack, (int)mouseX, (int)mouseY, tickDelta);
            editButton.method_25394(poseStack, (int)mouseX, (int)mouseY, tickDelta);
        }
        return clicked;
    }

    @Override
    protected void renderList(class_4587 poseStack, int x, int scrollAmount, int mouseX, int mouseY, float tickDelta) {
        super.renderList(poseStack, x, scrollAmount, mouseX, mouseY, tickDelta);
        this.listButtons(poseStack, mouseX, mouseY, 0, tickDelta, true);
    }

    private int getRowBottomCustom(int i) {
        return this.getRowTop(i) + this.itemHeight;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.width - 20;
    }

    @Override
    public int getRowLeft() {
        return this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    @Override
    public int getRowWidth() {
        return 220;
    }

    @Override
    public void setSelected(BaseEntry entry) {
        super.setSelected(entry);
    }
}

