/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.mobs;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.diebuddies.compat.Sodium;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.settings.cloth.LabelEntry;
import net.diebuddies.physics.settings.gui.legacy.LegacyObjectSelectionList;
import net.diebuddies.physics.settings.mobs.BoundingBoxGetter;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3879;
import net.minecraft.class_4042;
import net.minecraft.class_4505;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4999;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_554;
import net.minecraft.class_5597;
import net.minecraft.class_5602;
import net.minecraft.class_5762;
import net.minecraft.class_5774;
import net.minecraft.class_579;
import net.minecraft.class_580;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_603;
import net.minecraft.class_607;
import net.minecraft.class_613;
import net.minecraft.class_630;
import net.minecraft.class_7213;
import net.minecraft.class_742;
import net.minecraft.class_881;
import net.minecraft.class_883;
import net.minecraft.class_892;
import net.minecraft.class_895;
import net.minecraft.class_897;
import net.minecraft.class_905;
import net.minecraft.class_910;
import net.minecraft.class_915;
import net.minecraft.class_920;
import net.minecraft.class_921;
import net.minecraft.class_922;
import net.minecraft.class_925;
import net.minecraft.class_926;
import net.minecraft.class_929;
import net.minecraft.class_930;
import net.minecraft.class_931;
import net.minecraft.class_939;
import net.minecraft.class_940;
import net.minecraft.class_943;
import net.minecraft.class_955;
import net.minecraft.class_959;
import net.minecraft.class_960;
import net.minecraft.class_961;
import net.minecraft.class_964;
import net.minecraft.class_966;
import net.minecraft.class_969;
import org.joml.Quaternionf;

public class MobEntry
extends LabelEntry {
    private static final class_2960 DEFAULT_TEXTURE = new class_2960("physicsmod:textures/gui/white.png");
    private static final Map<class_897, class_3879> models = new Object2ObjectOpenHashMap();
    private String text;
    private class_1299<?> entityType;

    public MobEntry(LegacyObjectSelectionList objectSelectionList, String text) {
        super(objectSelectionList, text);
        this.text = text;
        this.entityType = (class_1299)class_1299.method_5898((String)text).get();
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void render(class_4587 poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        String newText;
        class_327 font = class_310.method_1551().field_1772;
        Object text = this.text;
        if (font.method_27525((class_5348)class_2561.method_43470((String)text).method_27692(class_124.field_1067)) > this.objectSelectionList.getRowWidth() - 55 && !((String)text).equalsIgnoreCase(newText = font.method_27523((String)text, this.objectSelectionList.getRowWidth() - 58))) {
            text = newText + "...";
        }
        class_5250 label = class_2561.method_43470((String)text);
        if (hovered) {
            label = label.method_27692(class_124.field_1067);
            class_332.method_27534((class_4587)poseStack, (class_327)font, (class_2561)label, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)0xFFFFFF);
        } else {
            class_332.method_27534((class_4587)poseStack, (class_327)font, (class_2561)label, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)0xC2C2C2);
        }
        class_4587 matrices = RenderSystem.getModelViewStack();
        float scale = (float)entryHeight / 2.0f * 0.9f;
        double xPosition = this.objectSelectionList.getRowLeft() + 2 + (int)scale;
        double yPosition = y + entryHeight / 2;
        matrices.method_22903();
        matrices.method_22904(xPosition, yPosition, 100.0);
        matrices.method_22905(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        class_310.method_1551().field_1773.method_22974().method_3316();
        class_308.method_34742();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        PhysicsMod.sodiumCatchBoundingBox = true;
        PhysicsMod.sodiumBoundingBox.start.set(Double.MAX_VALUE);
        PhysicsMod.sodiumBoundingBox.end.set(-1.7976931348623157E308);
        try {
            class_897<?> renderer = PhysicsMod.renderers.get(this.entityType);
            class_2960 textureLocation = MobEntry.getTextureLocation(renderer, this.entityType);
            class_3879 model = MobEntry.getModel(renderer, this.entityType);
            if (model instanceof class_583) {
                class_583 entityModel = (class_583)model;
                entityModel.field_3448 = false;
            }
            class_1921 renderType = class_1921.method_23576((class_2960)textureLocation);
            BoundingBoxGetter boundingBox = StarterClient.sodium ? Sodium.getNewBoundingBoxConsumer() : new BoundingBoxGetter();
            model.method_2828(new class_4587(), (class_4588)boundingBox, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.0f);
            if (StarterClient.sodium) {
                boundingBox.min = PhysicsMod.sodiumBoundingBox.getMin();
                boundingBox.max = PhysicsMod.sodiumBoundingBox.getMax();
            }
            double startX = boundingBox.min.x;
            double endX = boundingBox.max.x;
            double startY = boundingBox.min.y;
            double endY = boundingBox.max.y;
            double startZ = boundingBox.min.z;
            double endZ = boundingBox.max.z;
            double mobWidth = endX - startX;
            double mobHeight = endY - startY;
            double mobDepth = endZ - startZ;
            float mobScale = 1.0f / (float)Math.max(mobWidth, Math.max(mobHeight, mobDepth)) * 2.0f;
            matrices.method_22905(mobScale, mobScale, mobScale);
            matrices.method_22904(-mobWidth * 0.5 - startX, -mobHeight * 0.5 - startY, -mobDepth * 0.5 - startZ);
            matrices.method_22907(new Quaternionf().rotationXYZ((float)Math.toRadians(-25.0), (float)Math.toRadians(-130.0), 0.0f));
            RenderSystem.applyModelViewMatrix();
            class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
            class_4588 vertexConsumer = bufferSource.getBuffer(renderType);
            model.method_2828(new class_4587(), vertexConsumer, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.0f);
            bufferSource.method_22993();
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrices.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        PhysicsMod.sodiumCatchBoundingBox = false;
    }

    public static class_3879 getModel(class_897 renderer, class_1299<?> entityType, class_1297 entity) {
        if (entityType == class_1299.field_6097) {
            if (entity != null && entity instanceof class_742) {
                class_742 player = (class_742)entity;
                if (player.method_3121().equalsIgnoreCase("slim")) {
                    return models.computeIfAbsent(renderer, key -> new class_591(class_310.method_1551().method_31974().method_32072(class_5602.field_27581), true));
                }
                return models.computeIfAbsent(renderer, key -> new class_591(class_310.method_1551().method_31974().method_32072(class_5602.field_27577), false));
            }
            return models.computeIfAbsent(renderer, key -> new class_591(class_310.method_1551().method_31974().method_32072(class_5602.field_27577), false));
        }
        if (renderer instanceof class_922) {
            class_922 livingRenderer = (class_922)renderer;
            return livingRenderer.method_4038();
        }
        if (renderer instanceof class_895) {
            return models.computeIfAbsent(renderer, key -> new class_895.class_625(class_310.method_1551().method_31974().method_32072(class_5602.field_27562)));
        }
        if (renderer instanceof class_881) {
            return models.computeIfAbsent(renderer, key -> new class_554(class_310.method_1551().method_31974().method_32072(class_5602.method_32077((class_1690.class_1692)class_1690.class_1692.field_7727))));
        }
        if (renderer instanceof class_925) {
            if (entityType == class_1299.field_6053) {
                return models.computeIfAbsent(renderer, key -> new class_580(class_310.method_1551().method_31974().method_32072(class_5602.field_27666)));
            }
            if (entityType == class_1299.field_6126) {
                return models.computeIfAbsent(renderer, key -> new class_580(class_310.method_1551().method_31974().method_32072(class_5602.field_27690)));
            }
            if (entityType == class_1299.field_6136) {
                return models.computeIfAbsent(renderer, key -> new class_580(class_310.method_1551().method_31974().method_32072(class_5602.field_27693)));
            }
            if (entityType == class_1299.field_6080) {
                return models.computeIfAbsent(renderer, key -> new class_580(class_310.method_1551().method_31974().method_32072(class_5602.field_27567)));
            }
            if (entityType == class_1299.field_6058) {
                return models.computeIfAbsent(renderer, key -> new class_580(class_310.method_1551().method_31974().method_32072(class_5602.field_27601)));
            }
            if (entityType == class_1299.field_6142) {
                return models.computeIfAbsent(renderer, key -> new class_580(class_310.method_1551().method_31974().method_32072(class_5602.field_27657)));
            }
            return models.computeIfAbsent(renderer, key -> new class_580(class_310.method_1551().method_31974().method_32072(class_5602.field_27614)));
        }
        if (renderer instanceof class_940) {
            return models.computeIfAbsent(renderer, key -> new class_603(class_310.method_1551().method_31974().method_32072(class_5602.field_27597)));
        }
        if (renderer instanceof class_955) {
            return models.computeIfAbsent(renderer, key -> new class_613(class_310.method_1551().method_31974().method_32072(class_5602.field_27668)));
        }
        if (renderer instanceof class_966) {
            return models.computeIfAbsent(renderer, key -> new class_607(class_310.method_1551().method_31974().method_32072(class_5602.field_27635)));
        }
        if (renderer instanceof class_920) {
            return models.computeIfAbsent(renderer, key -> new class_579(class_310.method_1551().method_31974().method_32072(class_5602.field_27609)));
        }
        if (renderer instanceof class_892) {
            return models.computeIfAbsent(renderer, key -> new class_5597(){
                class_630 root = class_310.method_1551().method_31974().method_32072(class_5602.field_27563);

                public class_630 method_32008() {
                    return this.root;
                }

                public void method_2819(class_1297 var1, float var2, float var3, float var4, float var5, float var6) {
                }
            });
        }
        return null;
    }

    public static class_3879 getModel(class_897 renderer, class_1299<?> entityType) {
        return MobEntry.getModel(renderer, entityType, null);
    }

    public static class_2960 getTextureLocation(class_897 renderer, class_1299 entityType, class_1297 entity) {
        if (entityType == class_1299.field_6097) {
            class_742 player;
            if (entity != null && entity instanceof class_742 && (player = (class_742)entity).method_3127()) {
                return player.method_3117();
            }
            return new class_2960("textures/entity/player/wide/steve.png");
        }
        if (entityType == class_1299.field_22281) {
            return new class_2960("textures/entity/piglin/piglin.png");
        }
        if (entityType == class_1299.field_6050) {
            return new class_2960("textures/entity/piglin/zombified_piglin.png");
        }
        if (entityType == class_1299.field_25751) {
            return new class_2960("textures/entity/piglin/piglin_brute.png");
        }
        if (renderer instanceof class_939) {
            return new class_2960("textures/entity/rabbit/brown.png");
        }
        if (renderer instanceof class_5774) {
            return new class_2960(String.format("textures/entity/axolotl/axolotl_%s.png", class_5762.class_5767.field_28345.method_33238()));
        }
        if (renderer instanceof class_4505) {
            return new class_2960("textures/entity/bee/bee.png");
        }
        if (renderer instanceof class_881) {
            return new class_2960("textures/entity/boat/oak.png");
        }
        if (renderer instanceof class_929) {
            return new class_2960("textures/entity/cat/tabby.png");
        }
        if (renderer instanceof class_910) {
            return new class_2960("textures/entity/horse/horse_white.png");
        }
        if (renderer instanceof class_961) {
            if (entityType == class_1299.field_6048) {
                return new class_2960("textures/entity/horse/horse_zombie.png");
            }
            if (entityType == class_1299.field_6075) {
                return new class_2960("textures/entity/horse/horse_skeleton.png");
            }
            return new class_2960("textures/entity/horse/horse_skeleton.png");
        }
        if (renderer instanceof class_921) {
            return new class_2960("textures/entity/llama/creamy.png");
        }
        if (renderer instanceof class_883) {
            if (entityType == class_1299.field_6067) {
                return new class_2960("textures/entity/horse/donkey.png");
            }
            if (entityType == class_1299.field_6057) {
                return new class_2960("textures/entity/horse/mule.png");
            }
        } else {
            if (renderer instanceof class_4042) {
                return new class_2960("textures/entity/fox/fox.png");
            }
            if (renderer instanceof class_905) {
                return new class_2960("textures/entity/ghast/ghast.png");
            }
            if (renderer instanceof class_926) {
                return new class_2960("textures/entity/cow/red_mooshroom.png");
            }
            if (renderer instanceof class_931) {
                return new class_2960("textures/entity/panda/panda.png");
            }
            if (renderer instanceof class_930) {
                return new class_2960("textures/entity/parrot/parrot_red_blue.png");
            }
            if (renderer instanceof class_943) {
                return new class_2960("textures/" + class_4722.field_21710.method_24147().method_12832() + ".png");
            }
            if (renderer instanceof class_4999) {
                return new class_2960("textures/entity/strider/strider.png");
            }
            if (renderer instanceof class_959) {
                return new class_2960("textures/entity/fish/tropical_a.png");
            }
            if (renderer instanceof class_960) {
                return new class_2960("textures/entity/illager/vex.png");
            }
            if (renderer instanceof class_964) {
                return new class_2960("textures/entity/wither/wither.png");
            }
            if (renderer instanceof class_969) {
                return new class_2960("textures/entity/wolf/wolf.png");
            }
            if (renderer instanceof class_915) {
                return new class_2960("textures/entity/wolf/wolf.png");
            }
            if (renderer instanceof class_966) {
                return new class_2960("textures/entity/wither/wither_invulnerable.png");
            }
            if (renderer instanceof class_7213) {
                return new class_2960("textures/entity/frog/cold_frog.png");
            }
        }
        class_2960 texture = null;
        try {
            texture = renderer.method_3931(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (texture == null) {
            texture = MobEntry.getBackupTextureLocation(renderer, entityType);
        }
        if (texture == null) {
            return DEFAULT_TEXTURE;
        }
        return texture;
    }

    public static class_2960 getTextureLocation(class_897 renderer, class_1299 entityType) {
        return MobEntry.getTextureLocation(renderer, entityType, null);
    }

    private static class_2960 getBackupTextureLocation(class_897 renderer, class_1299 entityType) {
        Field[] fields;
        for (Field field : fields = renderer.getClass().getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(class_2960.class)) continue;
            try {
                String file;
                field.setAccessible(true);
                class_2960 resource = (class_2960)field.get(null);
                if (resource == null || !(file = resource.method_12832()).endsWith(".png") && !file.endsWith(".jpg") && !file.endsWith(".tga") && !file.endsWith(".jpeg")) continue;
                return resource;
            }
            catch (IllegalAccessException | IllegalArgumentException e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public class_2561 getNarration() {
        return class_2561.method_43470((String)this.text);
    }
}

