/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.gui.legacy;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.diebuddies.physics.settings.ux.BaseColors;
import net.diebuddies.physics.settings.ux.GUIResources;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public abstract class LegacyAbstractSelectionList<E extends LegacyEntry<E>>
extends class_362
implements class_4068,
class_6379 {
    protected final class_310 minecraft;
    public boolean renderBackgroundWhenIngame = true;
    protected final int itemHeight;
    private final List<E> children = new TrackedList();
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected int xOffset;
    protected boolean centerListVertically = true;
    private double scrollAmount;
    private boolean renderSelection = true;
    private boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;
    @Nullable
    private E selected;
    private boolean renderBackground = true;
    private boolean renderTopAndBottom = true;
    @Nullable
    private E hovered;
    private static float currentMouseX = Float.MAX_VALUE;
    private static float currentMouseY = Float.MAX_VALUE;
    private static float oldMouseX;
    private static float oldMouseY;
    private static float nextMouseX;
    private static float nextMouseY;
    private float mouseSmoothness = 0.15f;
    private float time = 0.0f;

    public LegacyAbstractSelectionList(class_310 minecraft, int i, int j, int k, int l, int m) {
        this.minecraft = minecraft;
        this.width = i;
        this.height = j;
        this.y0 = k;
        this.y1 = l;
        this.itemHeight = m;
        this.x0 = 0;
        this.x1 = i;
        this.xOffset = this.x0;
        this.init();
    }

    public void tick() {
        this.updatePositions();
        if (nextMouseX != Float.MAX_VALUE) {
            currentMouseX = Math.lerp((float)currentMouseX, (float)nextMouseX, (float)this.mouseSmoothness);
            currentMouseY = Math.lerp((float)currentMouseY, (float)nextMouseY, (float)this.mouseSmoothness);
        }
    }

    public void init() {
        if (currentMouseX == Float.MAX_VALUE) {
            currentMouseX = (float)this.width * 0.5f + (float)this.x0;
            currentMouseY = (float)this.height * 0.5f + (float)this.y0;
            this.updatePositions();
        }
    }

    private void updatePositions() {
        oldMouseX = currentMouseX;
        oldMouseY = currentMouseY;
    }

    public void setRenderSelection(boolean bl) {
        this.renderSelection = bl;
    }

    protected void setRenderHeader(boolean bl, int i) {
        this.renderHeader = bl;
        this.headerHeight = i;
        if (!bl) {
            this.headerHeight = 0;
        }
    }

    public int getRowWidth() {
        return 220;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E entry) {
        this.selected = entry;
    }

    public void setRenderBackground(boolean bl) {
        this.renderBackground = bl;
    }

    public void setRenderTopAndBottom(boolean bl) {
        this.renderTopAndBottom = bl;
    }

    @Nullable
    public E getFocused() {
        return (E)((LegacyEntry)super.method_25399());
    }

    public final List<E> method_25396() {
        return this.children;
    }

    protected final void clearEntries() {
        this.children.clear();
    }

    protected void replaceEntries(Collection<E> collection) {
        this.children.clear();
        this.children.addAll(collection);
    }

    protected E getEntry(int i) {
        if (i >= this.method_25396().size()) {
            return null;
        }
        return (E)((LegacyEntry)this.method_25396().get(i));
    }

    protected int addEntry(E entry) {
        this.children.add(entry);
        return this.children.size() - 1;
    }

    protected int getItemCount() {
        return this.method_25396().size();
    }

    protected boolean isSelectedItem(int i) {
        return Objects.equals(this.getSelected(), this.method_25396().get(i));
    }

    @Nullable
    protected final E getEntryAtPosition(double d, double e) {
        int i = this.getRowWidth() / 2;
        int j = this.x0 + this.width / 2;
        int k = j - i;
        int l = j + i;
        int m = class_3532.method_15357((double)(e - (double)this.y0)) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int n = m / this.itemHeight;
        if (d < (double)this.getScrollbarPosition() && d >= (double)k && d <= (double)l && n >= 0 && m >= 0 && n < this.getItemCount()) {
            return (E)((LegacyEntry)this.method_25396().get(n));
        }
        return null;
    }

    public void updateSize(int i, int j, int k, int l) {
        this.width = i;
        this.height = j;
        this.y0 = k;
        this.y1 = l;
        this.x0 = 0;
        this.x1 = i;
    }

    public void setLeftPos(int i) {
        this.x0 = i;
        this.x1 = i + this.width;
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected void clickedHeader(int i, int j) {
    }

    protected void renderHeader(class_4587 poseStack, int i, int j, class_289 tesselator) {
    }

    protected void renderBackground(class_4587 poseStack) {
    }

    protected void renderDecorations(class_4587 poseStack, int i, int j) {
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        int maxScroll;
        if (nextMouseX == Float.MAX_VALUE) {
            currentMouseX = net.diebuddies.math.Math.clamp((float)mouseX, 0.0f, (float)this.width);
            currentMouseY = net.diebuddies.math.Math.clamp((float)mouseY, 0.0f, (float)this.height);
        }
        this.time += delta;
        while (this.time >= 1.0f) {
            this.time -= 1.0f;
            this.tick();
        }
        nextMouseX = net.diebuddies.math.Math.clamp((float)mouseX, 0.0f, (float)this.width);
        nextMouseY = net.diebuddies.math.Math.clamp((float)mouseY, 0.0f, (float)this.height);
        float lMouseX = Math.lerp((float)oldMouseX, (float)currentMouseX, (float)this.time);
        float lMouseY = Math.lerp((float)oldMouseY, (float)currentMouseY, (float)this.time);
        this.renderBackground(poseStack);
        int scrollPosition = this.getScrollbarPosition();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        this.hovered = this.method_25405(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        Object v0 = this.hovered;
        if (this.renderBackground && (this.renderBackgroundWhenIngame || !this.renderBackgroundWhenIngame && this.minecraft.field_1687 == null)) {
            RenderSystem.setShaderTexture((int)0, (class_2960)GUIResources.BACKGROUND_TEXTURE);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            int color = class_5253.class_5254.method_27764((int)255, (int)64, (int)64, (int)64);
            int depth = -130;
            float offsetMultiplier = 0.001f;
            float uOffset = lMouseX * offsetMultiplier;
            float vOffset = lMouseY * offsetMultiplier;
            bufferBuilder.method_22912((double)this.xOffset, (double)this.y1, (double)depth).method_22913((float)this.xOffset / 32.0f + uOffset, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f + vOffset).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)this.x1, (double)this.y1, (double)depth).method_22913((float)this.x1 / 32.0f + uOffset, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f + vOffset).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)this.x1, (double)this.y0, (double)depth).method_22913((float)this.x1 / 32.0f + uOffset, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f + vOffset).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)this.xOffset, (double)this.y0, (double)depth).method_22913((float)this.xOffset / 32.0f + uOffset, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f + vOffset).method_39415(color).method_1344();
            tesselator.method_1350();
        }
        int xStart = this.getRowLeft();
        int yStart = this.y0 + 4 - (int)this.getScrollAmount();
        if (this.renderHeader) {
            this.renderHeader(poseStack, xStart, yStart, tesselator);
        }
        this.renderList(poseStack, xStart, yStart, mouseX, mouseY, delta);
        if (this.renderTopAndBottom) {
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture((int)0, (class_2960)GUIResources.BACKGROUND_TEXTURE);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)519);
            int color = class_5253.class_5254.method_27764((int)255, (int)96, (int)96, (int)96);
            int depth = -120;
            float offsetMultiplier = 0.0f;
            float uOffset = lMouseX * offsetMultiplier;
            float vOffset = lMouseY * offsetMultiplier;
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22912((double)this.xOffset, (double)this.y0, (double)depth).method_22913(uOffset, (float)this.y0 / 32.0f + vOffset).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)(this.xOffset + this.width), (double)this.y0, (double)depth).method_22913((float)this.width / 32.0f + uOffset, (float)this.y0 / 32.0f + vOffset).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)(this.xOffset + this.width), 0.0, (double)depth).method_22913((float)this.width / 32.0f + uOffset, vOffset).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)this.xOffset, 0.0, (double)depth).method_22913(uOffset, vOffset).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)this.xOffset, (double)this.height, (double)depth).method_22913(uOffset, (float)this.height / 32.0f + vOffset).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)(this.xOffset + this.width), (double)this.height, (double)depth).method_22913((float)this.width / 32.0f + uOffset, (float)this.height / 32.0f + vOffset).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)(this.xOffset + this.width), (double)this.y1, (double)depth).method_22913((float)this.width / 32.0f + uOffset, (float)this.y1 / 32.0f + vOffset).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)this.xOffset, (double)this.y1, (double)depth).method_22913(uOffset, (float)this.y1 / 32.0f + vOffset).method_39415(color).method_1344();
            tesselator.method_1350();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            RenderSystem.disableTexture();
            RenderSystem.setShader(class_757::method_34540);
            int gradientSize = 4;
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            bufferBuilder.method_22912((double)this.xOffset, (double)(this.y0 + gradientSize), (double)depth).method_1336(0, 0, 0, 0).method_1344();
            bufferBuilder.method_22912((double)this.x1, (double)(this.y0 + gradientSize), (double)depth).method_1336(0, 0, 0, 0).method_1344();
            bufferBuilder.method_22912((double)this.x1, (double)this.y0, (double)depth).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)this.xOffset, (double)this.y0, (double)depth).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)this.xOffset, (double)this.y1, (double)depth).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)this.x1, (double)this.y1, (double)depth).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)this.x1, (double)(this.y1 - gradientSize), (double)depth).method_1336(0, 0, 0, 0).method_1344();
            bufferBuilder.method_22912((double)this.xOffset, (double)(this.y1 - gradientSize), (double)depth).method_1336(0, 0, 0, 0).method_1344();
            tesselator.method_1350();
        }
        if ((maxScroll = this.getMaxScroll()) > 0) {
            RenderSystem.disableTexture();
            RenderSystem.setShader(class_757::method_34540);
            int barHeight = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            barHeight = class_3532.method_15340((int)barHeight, (int)32, (int)(this.y1 - this.y0 - 8));
            int yPos = (int)this.getScrollAmount() * (this.y1 - this.y0 - barHeight) / maxScroll + this.y0;
            if (yPos < this.y0) {
                yPos = this.y0;
            }
            int barBackground = class_5253.class_5254.method_27764((int)255, (int)14, (int)14, (int)14);
            int barWidth = 4;
            int depth = -120;
            int xScrollOffset = (scrollPosition += 2) + barWidth;
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            bufferBuilder.method_22912((double)scrollPosition, (double)this.y1, (double)depth).method_39415(barBackground).method_1344();
            bufferBuilder.method_22912((double)xScrollOffset, (double)this.y1, (double)depth).method_39415(barBackground).method_1344();
            bufferBuilder.method_22912((double)xScrollOffset, (double)this.y0, (double)depth).method_39415(barBackground).method_1344();
            bufferBuilder.method_22912((double)scrollPosition, (double)this.y0, (double)depth).method_39415(barBackground).method_1344();
            barBackground = class_5253.class_5254.method_27764((int)255, (int)22, (int)22, (int)22);
            bufferBuilder.method_22912((double)(scrollPosition + 1), (double)this.y1, (double)depth).method_39415(barBackground).method_1344();
            bufferBuilder.method_22912((double)xScrollOffset, (double)this.y1, (double)depth).method_39415(barBackground).method_1344();
            bufferBuilder.method_22912((double)xScrollOffset, (double)this.y0, (double)depth).method_39415(barBackground).method_1344();
            bufferBuilder.method_22912((double)(scrollPosition + 1), (double)this.y0, (double)depth).method_39415(barBackground).method_1344();
            int highlightColor = BaseColors.BAR_COLOR;
            if (mouseX >= scrollPosition - 2 && mouseX < scrollPosition + 4) {
                highlightColor = BaseColors.HIGHLIGHT_COLOR;
            }
            int darkenFactor = 198;
            int darkerColor = class_5253.class_5254.method_27763((int)highlightColor, (int)class_5253.class_5254.method_27764((int)255, (int)darkenFactor, (int)darkenFactor, (int)darkenFactor));
            bufferBuilder.method_22912((double)scrollPosition, (double)(yPos + barHeight), (double)depth).method_39415(darkerColor).method_1344();
            bufferBuilder.method_22912((double)xScrollOffset, (double)(yPos + barHeight), (double)depth).method_39415(darkerColor).method_1344();
            bufferBuilder.method_22912((double)xScrollOffset, (double)yPos, (double)depth).method_39415(darkerColor).method_1344();
            bufferBuilder.method_22912((double)scrollPosition, (double)yPos, (double)depth).method_39415(darkerColor).method_1344();
            bufferBuilder.method_22912((double)(scrollPosition + 1), (double)(yPos + barHeight), (double)depth).method_39415(highlightColor).method_1344();
            bufferBuilder.method_22912((double)xScrollOffset, (double)(yPos + barHeight), (double)depth).method_39415(highlightColor).method_1344();
            bufferBuilder.method_22912((double)xScrollOffset, (double)(yPos + 1), (double)depth).method_39415(highlightColor).method_1344();
            bufferBuilder.method_22912((double)(scrollPosition + 1), (double)(yPos + 1), (double)depth).method_39415(highlightColor).method_1344();
            tesselator.method_1350();
        }
        this.renderDecorations(poseStack, mouseX, mouseY);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    protected void centerScrollOn(E entry) {
        this.setScrollAmount(this.method_25396().indexOf(entry) * this.itemHeight + this.itemHeight / 2 - (this.y1 - this.y0) / 2);
    }

    protected void ensureVisible(E entry) {
        int k;
        int i = this.getRowTop(this.method_25396().indexOf(entry));
        int j = i - this.y0 - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll(j);
        }
        if ((k = this.y1 - i - this.itemHeight - this.itemHeight) < 0) {
            this.scroll(-k);
        }
    }

    private void scroll(int i) {
        this.setScrollAmount(this.getScrollAmount() + (double)i);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double d) {
        this.scrollAmount = class_3532.method_15350((double)d, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return java.lang.Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScrollAmount() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double d, double e, int i) {
        this.scrolling = i == 0 && d >= (double)this.getScrollbarPosition() && d < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    public boolean method_25402(double d, double e, int i) {
        this.updateScrollingState(d, e, i);
        if (!this.method_25405(d, e)) {
            return false;
        }
        E entry = this.getEntryAtPosition(d, e);
        if (entry != null) {
            if (entry.method_25402(d, e, i)) {
                this.method_25395((class_364)entry);
                this.method_25398(true);
                return true;
            }
        } else if (i == 0) {
            this.clickedHeader((int)(d - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(e - (double)this.y0) + (int)this.getScrollAmount() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean method_25406(double d, double e, int i) {
        if (this.getFocused() != null) {
            this.getFocused().method_25406(d, e, i);
        }
        return false;
    }

    public boolean method_25403(double d, double e, int i, double f, double g) {
        if (super.method_25403(d, e, i, f, g)) {
            return true;
        }
        if (i != 0 || !this.scrolling) {
            return false;
        }
        if (e < (double)this.y0) {
            this.setScrollAmount(0.0);
        } else if (e > (double)this.y1) {
            this.setScrollAmount(this.getMaxScroll());
        } else {
            double h = java.lang.Math.max(1, this.getMaxScroll());
            int j = this.y1 - this.y0;
            int k = class_3532.method_15340((int)((int)((float)(j * j) / (float)this.getMaxPosition())), (int)32, (int)(j - 8));
            double l = java.lang.Math.max(1.0, h / (double)(j - k));
            this.setScrollAmount(this.getScrollAmount() + g * l);
        }
        return true;
    }

    public boolean method_25401(double d, double e, double f) {
        this.setScrollAmount(this.getScrollAmount() - f * (double)this.itemHeight / 2.0);
        return true;
    }

    public boolean method_25404(int i, int j, int k) {
        if (super.method_25404(i, j, k)) {
            return true;
        }
        if (i == 264) {
            this.moveSelection(SelectionDirection.DOWN);
            return true;
        }
        if (i == 265) {
            this.moveSelection(SelectionDirection.UP);
            return true;
        }
        return false;
    }

    protected void moveSelection(SelectionDirection selectionDirection) {
        this.moveSelection(selectionDirection, entry -> true);
    }

    protected void refreshSelection() {
        E entry = this.getSelected();
        if (entry != null) {
            this.setSelected(entry);
            this.ensureVisible(entry);
        }
    }

    protected void moveSelection(SelectionDirection selectionDirection, Predicate<E> predicate) {
        int i;
        int n = i = selectionDirection == SelectionDirection.UP ? -1 : 1;
        if (!this.method_25396().isEmpty()) {
            int k;
            int j = this.method_25396().indexOf(this.getSelected());
            while (j != (k = class_3532.method_15340((int)(j + i), (int)0, (int)(this.getItemCount() - 1)))) {
                LegacyEntry entry = (LegacyEntry)this.method_25396().get(k);
                if (predicate.test(entry)) {
                    this.setSelected(entry);
                    this.ensureVisible(entry);
                    break;
                }
                j = k;
            }
        }
    }

    public boolean method_25405(double d, double e) {
        return e >= (double)this.y0 && e <= (double)this.y1 && d >= (double)this.x0 && d <= (double)this.x1;
    }

    protected void renderList(class_4587 poseStack, int i, int j, int k, int l, float f) {
        int m = this.getItemCount();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        for (int n = 0; n < m; ++n) {
            int t;
            int o = this.getRowTop(n);
            int p = this.getRowBottom(n);
            if (p < this.y0 || o > this.y1) continue;
            int q = j + n * this.itemHeight + this.headerHeight;
            int r = this.itemHeight - 4;
            E entry = this.getEntry(n);
            int s = this.getRowWidth();
            if (this.renderSelection && this.isSelectedItem(n)) {
                t = this.x0 + this.width / 2 - s / 2;
                int u = this.x0 + this.width / 2 + s / 2;
                RenderSystem.disableTexture();
                RenderSystem.setShader(class_757::method_34539);
                float g = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.setShaderColor((float)g, (float)g, (float)g, (float)1.0f);
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                bufferBuilder.method_22912((double)t, (double)(q + r + 2), 0.0).method_1344();
                bufferBuilder.method_22912((double)u, (double)(q + r + 2), 0.0).method_1344();
                bufferBuilder.method_22912((double)u, (double)(q - 2), 0.0).method_1344();
                bufferBuilder.method_22912((double)t, (double)(q - 2), 0.0).method_1344();
                tesselator.method_1350();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                bufferBuilder.method_22912((double)(t + 1), (double)(q + r + 1), 0.0).method_1344();
                bufferBuilder.method_22912((double)(u - 1), (double)(q + r + 1), 0.0).method_1344();
                bufferBuilder.method_22912((double)(u - 1), (double)(q - 1), 0.0).method_1344();
                bufferBuilder.method_22912((double)(t + 1), (double)(q - 1), 0.0).method_1344();
                tesselator.method_1350();
                RenderSystem.enableTexture();
            }
            t = this.getRowLeft();
            ((LegacyEntry)entry).render(poseStack, n, o, t, s, r, k, l, Objects.equals(this.hovered, entry), f);
        }
    }

    public int getRowLeft() {
        return this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    protected int getRowTop(int i) {
        return this.y0 + 4 - (int)this.getScrollAmount() + i * this.itemHeight + this.headerHeight;
    }

    private int getRowBottom(int i) {
        return this.getRowTop(i) + this.itemHeight;
    }

    protected boolean isFocused() {
        return false;
    }

    public class_6379.class_6380 method_37018() {
        if (this.isFocused()) {
            return class_6379.class_6380.field_33786;
        }
        if (this.hovered != null) {
            return class_6379.class_6380.field_33785;
        }
        return class_6379.class_6380.field_33784;
    }

    @Nullable
    protected E remove(int i) {
        LegacyEntry entry = (LegacyEntry)this.children.get(i);
        if (this.removeEntry((LegacyEntry)this.children.get(i))) {
            return (E)entry;
        }
        return null;
    }

    protected boolean removeEntry(E entry) {
        boolean bl = this.children.remove(entry);
        if (bl && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return bl;
    }

    @Nullable
    public E getHovered() {
        return this.hovered;
    }

    void bindEntryToSelf(LegacyEntry<E> entry) {
        entry.list = this;
    }

    protected void narrateListElementPosition(class_6382 narrationElementOutput, E entry) {
        int i;
        List<E> list = this.method_25396();
        if (list.size() > 1 && (i = list.indexOf(entry)) != -1) {
            narrationElementOutput.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    static {
        nextMouseX = Float.MAX_VALUE;
        nextMouseY = Float.MAX_VALUE;
    }

    class TrackedList
    extends AbstractList<E> {
        private final List<E> delegate = Lists.newArrayList();

        TrackedList() {
        }

        @Override
        public E get(int i) {
            return (LegacyEntry)this.delegate.get(i);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public E set(int i, E entry) {
            LegacyEntry entry2 = (LegacyEntry)this.delegate.set(i, entry);
            LegacyAbstractSelectionList.this.bindEntryToSelf(entry);
            return entry2;
        }

        @Override
        public void add(int i, E entry) {
            this.delegate.add(i, entry);
            LegacyAbstractSelectionList.this.bindEntryToSelf(entry);
        }

        @Override
        public E remove(int i) {
            return (LegacyEntry)this.delegate.remove(i);
        }
    }

    public static abstract class LegacyEntry<E extends LegacyEntry<E>>
    implements class_364 {
        @Deprecated
        LegacyAbstractSelectionList<E> list;

        public abstract void render(class_4587 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public boolean method_25405(double d, double e) {
            return Objects.equals(this.list.getEntryAtPosition(d, e), this);
        }
    }

    protected static enum SelectionDirection {
        UP,
        DOWN;

    }
}

