/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.PopupWidget;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.diebuddies.physics.settings.ux.BaseRenderer;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class SnowSettingsScreen
extends class_4667 {
    private boolean thicknessChanged = false;
    private final CycleOption<Boolean> PHYSICS_SNOW = CycleOption.createOnOff("physicsmod.menu.snow.snowphysics", gameOptions -> ConfigClient.snowPhysics, (gameOptions, option, value) -> {
        ConfigClient.snowPhysics = value;
        ConfigClient.save();
        class_310.method_1551().field_1769.method_3279();
    });
    private final ProgressOption PHYSICS_SNOW_THICKNESS = new ProgressOption("physicsmod.menu.snow.snowthickness", 0.0, 0.5, 0.01f, gameOptions -> ConfigClient.snowThickness, (gameOptions, value) -> {
        ConfigClient.snowThickness = value.floatValue();
        ConfigClient.save();
        this.thicknessChanged = true;
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.snow.snowthickness", String.format("%.2f", option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.snow.snowthickness.info"));
    private final CycleOption<Boolean> PHYSICS_SNOW_TRACKS = CycleOption.createOnOff("physicsmod.menu.snow.snowtracks", gameOptions -> ConfigClient.snowTracks, (gameOptions, option, value) -> {
        ConfigClient.snowTracks = value;
        ConfigClient.save();
    });
    private final ProgressOption PHYSICS_SNOW_TRACK_DISTANCE = new ProgressOption("physicsmod.menu.snow.snowtrackdistance", 4.0, 240.0, 0.1f, gameOptions -> ConfigClient.snowTrackDistance, (gameOptions, value) -> {
        ConfigClient.snowTrackDistance = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.snow.snowtrackdistance", String.format("%.0f", option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.snow.snowtrackdistance.info"));
    private final ProgressOption PHYSICS_SNOW_TRACK_ENTITIES = new ProgressOption("physicsmod.menu.snow.snowtrackentities", 1.0, 60.0, 1.0f, gameOptions -> ConfigClient.snowTrackEntities, (gameOptions, value) -> {
        ConfigClient.snowTrackEntities = value.intValue();
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.snow.snowtrackentities", String.format("%.0f", option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.snow.snowtrackentities.info"));
    private final CycleOption<Boolean> PHYSICS_GRASSY_SNOW = CycleOption.createOnOff("physicsmod.menu.snow.grasssnowy", gameOptions -> ConfigClient.grassSnowy, (gameOptions, option, value) -> {
        ConfigClient.grassSnowy = value;
        ConfigClient.save();
        class_310.method_1551().field_1769.method_3279();
    }).setTooltip(minecraft -> graphicsStatus -> class_2561.method_43471((String)"physicsmod.menu.snow.grasssnowy.info"));
    private final CycleOption<Boolean> PHYSICS_SNOW_SMOOTH_SHADING = CycleOption.createOnOff("physicsmod.menu.snow.snowsmoothshading", gameOptions -> ConfigClient.snowSmoothShading, (gameOptions, option, value) -> {
        ConfigClient.snowSmoothShading = value;
        ConfigClient.save();
        class_310.method_1551().field_1769.method_3279();
    }).setTooltip(minecraft -> graphicsStatus -> class_2561.method_43471((String)"physicsmod.menu.snow.snowsmoothshading.info"));
    private final CycleOption<SnowType> PHYSICS_SNOW_TYPE = CycleOption.create("physicsmod.menu.snow.snowtype", (Object[])SnowType.values(), model -> class_2561.method_43471((String)((SnowType)((Object)((Object)model))).toString()), gameOptions -> {
        int val = ConfigClient.snowType;
        if (val >= SnowType.values().length) {
            return SnowType.values()[0];
        }
        return SnowType.values()[val];
    }, (gameOptions, option, model) -> {
        SnowType type = (SnowType)((Object)((Object)model));
        ConfigClient.snowType = type.ordinal();
        ConfigClient.save();
        class_310.method_1551().field_1769.method_3279();
    });
    private final CycleOption<SnowQuality> PHYSICS_SNOW_QUALITY = CycleOption.create("physicsmod.menu.snow.snowquality", (Object[])SnowQuality.values(), model -> class_2561.method_43471((String)((SnowQuality)((Object)((Object)model))).toString()), gameOptions -> {
        int val = ConfigClient.snowQuality;
        if (val >= SnowQuality.values().length) {
            return SnowQuality.values()[0];
        }
        return SnowQuality.values()[val];
    }, (gameOptions, option, model) -> {
        SnowQuality type = (SnowQuality)((Object)((Object)model));
        ConfigClient.snowQuality = type.ordinal();
        ConfigClient.save();
        class_310.method_1551().field_1769.method_3279();
    });
    private final ProgressOption PHYSICS_SNOW_LOD = new ProgressOption("physicsmod.menu.snow.levelofdetail", 0.5, 10.0, 0.01f, gameOptions -> ConfigClient.snowLOD, (gameOptions, value) -> {
        ConfigClient.snowLOD = value.floatValue();
        ConfigClient.save();
        this.thicknessChanged = true;
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.snow.levelofdetail", String.format("%.2f", option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.snow.levelofdetail.info"));
    private static final int MAX_INFO_WIDTH = 300;
    private LegacyOptionsList list;
    private List<class_5481> info;

    public SnowSettingsScreen(class_437 parent, class_315 options) {
        super(parent, options, (class_2561)class_2561.method_43471((String)"physicsmod.menu.snow.title.pro"));
        this.info = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)"physicsmod.menu.snow.warning"), 300);
        this.PHYSICS_SNOW_QUALITY.setTooltip(minecraft -> graphicsStatus -> class_2561.method_43471((String)"physicsmod.menu.snow.snowquality.info"));
    }

    protected void method_25426() {
        this.list = new LegacyOptionsList(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
        this.list.addSmall(this.PHYSICS_SNOW, this.PHYSICS_SNOW_TRACKS);
        this.list.addBig(this.PHYSICS_SNOW_THICKNESS);
        this.list.addBig(this.PHYSICS_SNOW_LOD);
        this.list.addSmall(this.PHYSICS_SNOW_TRACK_ENTITIES, this.PHYSICS_SNOW_TRACK_DISTANCE);
        this.list.addSmall(this.PHYSICS_SNOW_TYPE, this.PHYSICS_SNOW_SMOOTH_SHADING);
        this.list.addSmall(this.PHYSICS_SNOW_QUALITY, this.PHYSICS_GRASSY_SNOW);
        this.field_22786.add(this.list);
        this.method_37063((class_364)ButtonSettings.builder(this.field_22789 / 2 + 5, this.field_22790 - 27, 75, 20, class_5244.field_24334, button -> {
            this.method_25419();
            this.field_22787.method_1507(this.field_21335);
        }));
        this.method_37063((class_364)ButtonSettings.builder(this.field_22789 / 2 - 80, this.field_22790 - 27, 75, 20, (class_2561)class_2561.method_43471((String)"physicsmod.gui.reset"), button -> PopupWidget.create(class_2477.method_10517().method_4679("physicsmod.menu.snow.reset"), (class_437)this, widget -> this.method_37063((class_364)widget), widget -> this.method_37066((class_364)widget), response -> {
            if (response == PopupWidget.PopupResponse.YES) {
                ConfigClient.resetSnowSettings();
                this.list.method_25396().clear();
                this.field_22787.method_1507((class_437)new SnowSettingsScreen(this.field_21335, this.field_21336));
                class_310.method_1551().field_1769.method_3279();
            } else {
                this.list.method_25396().clear();
                this.field_22787.method_1507((class_437)new SnowSettingsScreen(this.field_21335, this.field_21336));
            }
        })));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.list.method_25394(matrices, mouseX, mouseY, delta);
        SnowSettingsScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)15, (int)0xFFFFFF);
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, -75.0f);
        int lineY = 0;
        for (class_5481 sequence : this.info) {
            SnowSettingsScreen.method_35720((class_4587)matrices, (class_327)this.field_22793, (class_5481)sequence, (int)((this.field_22789 - 300) / 2), (int)(187 + lineY), (int)0xFFFF55);
            lineY += 10;
        }
        matrices.method_22909();
        super.method_25394(matrices, mouseX, mouseY, delta);
        BaseRenderer.renderSettingsTooltip(this.list, matrices, mouseX, mouseY, this.field_22789, this.field_22790);
    }

    public void method_25419() {
        super.method_25419();
        if (this.thicknessChanged) {
            class_310.method_1551().field_1769.method_3279();
        }
    }

    public static enum SnowType {
        Round("physicsmod.enum.snowtype.round"),
        Cube("physicsmod.enum.snowtype.cube");

        private String translationId;

        private SnowType(String translationId) {
            this.translationId = translationId;
        }

        public String toString() {
            return this.translationId;
        }
    }

    public static enum SnowQuality {
        Medium("physicsmod.enum.snowquality.medium"),
        High("physicsmod.enum.snowquality.high");

        private String translationId;

        private SnowQuality(String translationId) {
            this.translationId = translationId;
        }

        public String toString() {
            return this.translationId;
        }
    }
}

