/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.ocean.OceanLayer;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.LabelOption;
import net.diebuddies.physics.settings.gui.PopupWidget;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.diebuddies.physics.settings.ux.BaseRenderer;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4667;
import net.minecraft.class_5244;

public class OceanSettingsScreen
extends class_4667 {
    private final CycleOption<Boolean> PHYSICS_OCEAN = CycleOption.createOnOff("physicsmod.menu.ocean.oceanphysics", gameOptions -> ConfigClient.oceanPhysics, (gameOptions, option, value) -> {
        ConfigClient.oceanPhysics = value;
        class_310.method_1551().field_1769.method_3279();
    });
    private final CycleOption<Boolean> PHYSICS_OCEAN_HITBOX = CycleOption.createOnOff("physicsmod.menu.ocean.hitbox", gameOptions -> ConfigClient.oceanAdjustHitbox, (gameOptions, option, value) -> {
        ConfigClient.oceanAdjustHitbox = value;
    }).setTooltip(minecraft -> graphicsStatus -> class_2561.method_43471((String)"physicsmod.menu.ocean.hitbox.info"));
    private final CycleOption<Boolean> PHYSICS_OCEAN_RIPPLES = CycleOption.createOnOff("physicsmod.menu.ocean.ripples", gameOptions -> ConfigClient.oceanRipples, (gameOptions, option, value) -> {
        ConfigClient.oceanRipples = value;
        class_310.method_1551().field_1769.method_3279();
    }).setTooltip(minecraft -> graphicsStatus -> class_2561.method_43471((String)"physicsmod.menu.ocean.ripples.info"));
    private final ProgressOption PHYSICS_OCEAN_DETAIL = new ProgressOption("physicsmod.menu.ocean.detail", 0.0, 1.0, 0.01f, gameOptions -> ConfigClient.oceanDetail, (gameOptions, value) -> {
        ConfigClient.oceanDetail = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.detail", String.format("%.2f", option.get((class_315)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_FOAM_AMOUNT = new ProgressOption("physicsmod.menu.ocean.foamamount", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.oceanFoamAmount, (gameOptions, value) -> {
        ConfigClient.oceanFoamAmount = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.foamamount", String.format("%.2f", option.get((class_315)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_FOAM_OPACITY = new ProgressOption("physicsmod.menu.ocean.foamopacity", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.oceanFoamOpacity, (gameOptions, value) -> {
        ConfigClient.oceanFoamOpacity = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.foamopacity", String.format("%.2f", option.get((class_315)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_BLOCK_RANGE = new ProgressOption("physicsmod.menu.ocean.blockrange", 2.0, 96.0, 1.0f, gameOptions -> ConfigClient.oceanBlockRange, (gameOptions, value) -> {
        ConfigClient.oceanBlockRange = value.byteValue();
        OceanLayer.updateRange(ConfigClient.oceanBlockRange);
        class_310.method_1551().field_1769.method_3279();
        this.checkOceanWarning();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.blockrange", Integer.toString((int)option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.ocean.blockrange.info"));
    private final ProgressOption PHYSICS_OCEAN_WEATHER_CLEAR = new ProgressOption("physicsmod.menu.ocean.weather.clear", 0.0, 3.0, 0.01f, gameOptions -> ConfigClient.oceanWeatherClear, (gameOptions, value) -> {
        ConfigClient.oceanWeatherClear = value.floatValue();
        this.checkOceanWarning();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.weather.clear", String.format("%.2f", option.get((class_315)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_WEATHER_RAIN = new ProgressOption("physicsmod.menu.ocean.weather.rain", 0.0, 3.0, 0.01f, gameOptions -> ConfigClient.oceanWeatherRain, (gameOptions, value) -> {
        ConfigClient.oceanWeatherRain = value.floatValue();
        this.checkOceanWarning();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.weather.rain", String.format("%.2f", option.get((class_315)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_WEATHER_THUNDER = new ProgressOption("physicsmod.menu.ocean.weather.thunder", 0.0, 3.0, 0.01f, gameOptions -> ConfigClient.oceanWeatherThunder, (gameOptions, value) -> {
        ConfigClient.oceanWeatherThunder = value.floatValue();
        this.checkOceanWarning();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.weather.thunder", String.format("%.2f", option.get((class_315)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_WAVE_HEIGHT = new ProgressOption("physicsmod.menu.ocean.waveheight", 0.0, 2.0, 0.01f, gameOptions -> ConfigClient.oceanWaveHeightMultiplier, (gameOptions, value) -> {
        ConfigClient.oceanWaveHeightMultiplier = value.floatValue();
        this.checkOceanWarning();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.waveheight", String.format("%.2f", option.get((class_315)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_WAVE_SPEED = new ProgressOption("physicsmod.menu.ocean.wavespeed", 0.0, 3.0, 0.01f, gameOptions -> ConfigClient.oceanBaseSpeed, (gameOptions, value) -> {
        ConfigClient.oceanBaseSpeed = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.wavespeed", String.format("%.2f", option.get((class_315)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_WAVE_HORIZONTAL_SCALE = new ProgressOption("physicsmod.menu.ocean.wavehorizontalscale", 0.1, 2.0, 0.01f, gameOptions -> ConfigClient.oceanHorizontalWaveScale, (gameOptions, value) -> {
        ConfigClient.oceanHorizontalWaveScale = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.wavehorizontalscale", String.format("%.2f", option.get((class_315)gameOptions))));
    private final ProgressOption PHYSICS_OCEAN_PARTICLE_ALPHA = new ProgressOption("physicsmod.menu.ocean.particlealpha", 0.0, 1.0, 0.01f, gameOptions -> ConfigClient.oceanParticleAlpha, (gameOptions, value) -> {
        ConfigClient.oceanParticleAlpha = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.ocean.particlealpha", String.format("%.2f", option.get((class_315)gameOptions))));
    private final CycleOption<Boolean> PHYSICS_OCEAN_STICKY = CycleOption.createOnOff("physicsmod.menu.ocean.sticky", gameOptions -> ConfigClient.oceanStickyEntities, (gameOptions, option, value) -> {
        ConfigClient.oceanStickyEntities = value;
    });
    private final CycleOption<Boolean> PHYSICS_OCEAN_PARTICLES = CycleOption.createOnOff("physicsmod.menu.ocean.particles", gameOptions -> ConfigClient.oceanParticles, (gameOptions, option, value) -> {
        ConfigClient.oceanParticles = value;
    });
    private LegacyOptionsList list;
    private class_2561 title;

    public OceanSettingsScreen(class_437 parent, class_315 options) {
        super(parent, options, (class_2561)class_2561.method_43471((String)"physicsmod.menu.ocean.title"));
        this.checkOceanWarning();
    }

    private void checkOceanWarning() {
        this.title = OceanWorld.getMaxOceanHeight() * 0.5f > (float)ConfigClient.oceanBlockRange ? class_2561.method_43471((String)"physicsmod.menu.ocean.title.warning") : class_2561.method_43471((String)"physicsmod.menu.ocean.title");
    }

    protected void method_25426() {
        this.list = new LegacyOptionsList(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
        this.list.renderBackgroundWhenIngame = false;
        this.list.addSmall(this.PHYSICS_OCEAN, this.PHYSICS_OCEAN_HITBOX);
        this.list.addSmall(this.PHYSICS_OCEAN_FOAM_AMOUNT, this.PHYSICS_OCEAN_FOAM_OPACITY);
        this.list.addBig(this.PHYSICS_OCEAN_RIPPLES);
        this.list.addBig(this.PHYSICS_OCEAN_BLOCK_RANGE);
        this.list.addBig(new LabelOption(class_2477.method_10517().method_4679("physicsmod.menu.ocean.wavetitle")));
        this.list.addSmall(this.PHYSICS_OCEAN_DETAIL, this.PHYSICS_OCEAN_WAVE_HEIGHT);
        this.list.addSmall(this.PHYSICS_OCEAN_WAVE_SPEED, this.PHYSICS_OCEAN_WAVE_HORIZONTAL_SCALE);
        this.list.addBig(new LabelOption(class_2477.method_10517().method_4679("physicsmod.menu.ocean.entities")));
        this.list.addSmall(this.PHYSICS_OCEAN_PARTICLES, this.PHYSICS_OCEAN_PARTICLE_ALPHA);
        this.list.addBig(this.PHYSICS_OCEAN_STICKY);
        this.list.addBig(new LabelOption(class_2477.method_10517().method_4679("physicsmod.menu.ocean.weather")));
        this.list.addBig(this.PHYSICS_OCEAN_WEATHER_CLEAR);
        this.list.addBig(this.PHYSICS_OCEAN_WEATHER_RAIN);
        this.list.addBig(this.PHYSICS_OCEAN_WEATHER_THUNDER);
        this.field_22786.add(this.list);
        this.method_37063((class_364)ButtonSettings.builder(this.field_22789 / 2 + 5, this.field_22790 - 27, 75, 20, class_5244.field_24334, button -> {
            this.method_25419();
            this.field_22787.method_1507(this.field_21335);
        }));
        this.method_37063((class_364)ButtonSettings.builder(this.field_22789 / 2 - 80, this.field_22790 - 27, 75, 20, (class_2561)class_2561.method_43471((String)"physicsmod.gui.reset"), button -> PopupWidget.create(class_2477.method_10517().method_4679("physicsmod.menu.ocean.reset"), (class_437)this, widget -> this.method_37063((class_364)widget), widget -> this.method_37066((class_364)widget), response -> {
            if (response == PopupWidget.PopupResponse.YES) {
                ConfigClient.resetOceanSettings();
                OceanLayer.updateRange(ConfigClient.oceanBlockRange);
                class_310.method_1551().field_1769.method_3279();
                this.list.method_25396().clear();
                this.field_22787.method_1507((class_437)new OceanSettingsScreen(this.field_21335, this.field_21336));
            } else {
                this.list.method_25396().clear();
                this.field_22787.method_1507((class_437)new OceanSettingsScreen(this.field_21335, this.field_21336));
            }
        })));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.list.method_25394(matrices, mouseX, mouseY, delta);
        OceanSettingsScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.title, (int)(this.field_22789 / 2), (int)15, (int)0xFFFFFF);
        super.method_25394(matrices, mouseX, mouseY, delta);
        BaseRenderer.renderSettingsTooltip(this.list, matrices, mouseX, mouseY, this.field_22789, this.field_22790);
    }

    public void method_25419() {
        ConfigClient.save();
        super.method_25419();
    }
}

