/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.diebuddies.physics.settings.ux.BaseRenderer;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class LiquidSettingsScreen
extends class_4667 {
    private static final CycleOption<Boolean> PHYSICS_LIQUIDS = CycleOption.createOnOff("physicsmod.menu.liquid.liquidphysics", gameOptions -> ConfigClient.liquidPhysics, (gameOptions, option, value) -> {
        ConfigClient.liquidPhysics = value;
        ConfigClient.save();
        if (!ConfigClient.liquidPhysics) {
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                ObjectArrayList liquids = new ObjectArrayList(mod.getPhysicsWorld().getLiquids());
                for (Liquid liquid : liquids) {
                    mod.getPhysicsWorld().removeLiquid(liquid);
                }
            }
        }
    });
    private static final ProgressOption PHYSICS_LIQUID_CPU_THREADS = new ProgressOption("physicsmod.menu.liquid.liquidthreads", 1.0, Runtime.getRuntime().availableProcessors(), 1.0f, gameOptions -> ConfigClient.liquidThreads, (gameOptions, value) -> {
        ConfigClient.liquidThreads = Math.max(value.intValue(), 1);
        ConfigClient.save();
        if (Liquid.threads != null) {
            for (int i = 0; i < Liquid.threads.length; ++i) {
                Liquid.threads[i].cancel();
            }
        }
        Liquid.threads = null;
        Liquid.initThreads();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.liquidthreads", Integer.toString((int)option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.liquid.liquidthreads.info"));
    private static final ProgressOption PHYSICS_LIQUID_DENSITY = new ProgressOption("physicsmod.menu.liquid.waterdensity", 3.0, 8.0, 1.0f, gameOptions -> ConfigClient.waterDensity, (gameOptions, value) -> {
        ConfigClient.waterDensity = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.waterdensity", Integer.toString((int)option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.liquid.waterdensity.info"));
    private static final ProgressOption PHYSICS_LIQUID_SOURCE_DISTANCE = new ProgressOption("physicsmod.menu.liquid.liquidsourcedistance", 1.0, 40.0, 0.1f, gameOptions -> ConfigClient.liquidSourceDistance, (gameOptions, value) -> {
        ConfigClient.liquidSourceDistance = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.liquidsourcedistance", String.format("%.0f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimeliquids", 0.0, 100.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeLiquids, (gameOptions, value) -> {
        ConfigClient.particleLifetimeLiquids = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimeliquids", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_VARIANCE_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimevarianceliquids", 0.0, 30.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeVarianceLiquids, (gameOptions, value) -> {
        ConfigClient.particleLifetimeVarianceLiquids = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimevarianceliquids", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final int MAX_INFO_WIDTH = 300;
    private LegacyOptionsList list;
    private List<class_5481> info;

    public LiquidSettingsScreen(class_437 parent, class_315 options) {
        super(parent, options, (class_2561)class_2561.method_43471((String)"physicsmod.menu.liquid.title.pro"));
        this.info = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)"physicsmod.menu.liquid.warning"), 300);
    }

    protected void method_25426() {
        this.list = new LegacyOptionsList(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
        this.list.addBig(PHYSICS_LIQUIDS);
        this.list.addSmall(PHYSICS_LIQUID_DENSITY, PHYSICS_LIQUID_CPU_THREADS);
        this.list.addBig(PHYSICS_LIQUID_SOURCE_DISTANCE);
        this.list.addSmall(PHYSICS_LIFETIME_LIQUID, PHYSICS_LIFETIME_VARIANCE_LIQUID);
        this.field_22786.add(this.list);
        this.method_37063((class_364)ButtonSettings.builder(this.field_22789 / 2 - 50, this.field_22790 - 27, 100, 20, class_5244.field_24334, button -> this.field_22787.method_1507(this.field_21335)));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.list.method_25394(matrices, mouseX, mouseY, delta);
        LiquidSettingsScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)15, (int)0xFFFFFF);
        super.method_25394(matrices, mouseX, mouseY, delta);
        int lineY = 0;
        for (class_5481 sequence : this.info) {
            LiquidSettingsScreen.method_35720((class_4587)matrices, (class_327)this.field_22793, (class_5481)sequence, (int)((this.field_22789 - 300) / 2), (int)(137 + lineY), (int)0xFFFF55);
            lineY += 10;
        }
        BaseRenderer.renderSettingsTooltip(this.list, matrices, mouseX, mouseY, this.field_22789, this.field_22790);
    }

    private /* synthetic */ void lambda$init$20(class_4185 button) {
        this.field_22787.method_1507(this.field_21335);
    }

    private static /* synthetic */ void lambda$init$19(class_4185 button) {
        class_156.method_668().method_670("https://minecraftphysicsmod.com/pro");
    }
}

