/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.liquid;

import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.math.Math;
import net.diebuddies.opengl.Pack;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.liquid.LiquidController;
import net.diebuddies.physics.liquid.SimpleTextureDimension;
import net.minecraft.class_1044;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.joml.Vector3d;

public class WaterController
implements LiquidController {
    private class_2338 pos;
    private class_238 aabb;
    private int density;
    private boolean continous;
    private int spawnAmount;
    private int spawnCorner;

    public WaterController(class_2338 pos, int density, boolean continous, int spawnAmount) {
        this.density = density;
        this.continous = continous;
        this.spawnAmount = spawnAmount;
        this.pos = pos;
        this.aabb = new class_238(pos);
    }

    @Override
    public void init(Liquid liquid) {
        SimpleTextureDimension dimension;
        liquid.blockPos = this.pos;
        liquid.density = this.density;
        liquid.damping = 0.0f;
        liquid.range = 1.5;
        liquid.sourceAlive = this.continous;
        liquid.gridSize = this.density;
        liquid.origin = new Vector3d((this.aabb.field_1323 + this.aabb.field_1320) * 0.5, (this.aabb.field_1322 + this.aabb.field_1325) * 0.5, (this.aabb.field_1321 + this.aabb.field_1324) * 0.5);
        if (StarterClient.iris) {
            liquid.materialID = Iris.getMaterialID(class_2246.field_10382.method_9564());
        } else if (StarterClient.optifabric) {
            liquid.materialID = (short)Optifine.getMaterialID(class_2246.field_10382.method_9564());
        }
        int color = class_1163.method_4961((class_1920)liquid.world.getWorld(), (class_2338)this.pos);
        liquid.color = Pack.color((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        class_1044 texture = class_310.method_1551().method_1531().method_4619(new class_2960("minecraft:textures/block/water_flow.png"));
        if (texture instanceof SimpleTextureDimension && (dimension = (SimpleTextureDimension)texture).getWidth() != dimension.getHeight()) {
            liquid.textureScale.y = (float)dimension.getWidth() / (float)dimension.getHeight();
        }
        liquid.textureScale.mul(0.66666f);
        liquid.textureID = texture.method_4624();
        double diameter = 1.0 / (double)liquid.density;
        double radius = diameter * 0.5;
        for (int i = 0; i < this.spawnAmount; ++i) {
            for (int x = 0; x < liquid.density; ++x) {
                for (int y = 0; y < liquid.density; ++y) {
                    for (int z = 0; z < liquid.density; ++z) {
                        double xo = diameter * (double)x + radius + this.aabb.field_1323;
                        double yo = diameter * (double)y + radius + this.aabb.field_1322;
                        double zo = diameter * (double)z + radius + this.aabb.field_1321;
                        liquid.spawnParticle(radius, xo, yo, zo);
                    }
                }
            }
        }
    }

    @Override
    public void update(Liquid liquid, double diff) {
        if (StarterClient.iris) {
            liquid.materialID = Iris.getMaterialID(class_2246.field_10382.method_9564());
        } else if (StarterClient.optifabric) {
            liquid.materialID = (short)Optifine.getMaterialID(class_2246.field_10382.method_9564());
        }
        if (liquid.sourceAlive) {
            double diameter = 1.0 / (double)liquid.density;
            double radius = diameter * 0.5;
            boolean x = (this.spawnCorner & 1) == 1;
            boolean y = (this.spawnCorner & 2) == 1;
            boolean z = (this.spawnCorner & 4) == 1;
            int amount = java.lang.Math.round(Math.remap(this.density, 3.0f, 7.0f, 1.0f, 4.0f));
            for (int i = 0; i < amount; ++i) {
                double xo = Math.clamp((double)x, radius, 1.0 - radius) + this.aabb.field_1323;
                double yo = Math.clamp((double)y, radius, 1.0 - radius) + this.aabb.field_1322;
                double zo = Math.clamp((double)z, radius, 1.0 - radius) + this.aabb.field_1321;
                liquid.spawnParticle(radius, xo, yo, zo);
                ++this.spawnCorner;
                this.spawnCorner %= 8;
            }
        }
    }
}

