/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.math.Vector3i;
import net.diebuddies.minecraft.LevelRendererAccessor;
import net.diebuddies.opengl.ArenaBuffer;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.StateTracker;
import net.diebuddies.opengl.VAO;
import net.diebuddies.opengl.VertexFormat;
import net.diebuddies.physics.BoxRigidBody;
import net.diebuddies.physics.ConvexRigidBody;
import net.diebuddies.physics.DynamicsWorld;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsUpdate;
import net.diebuddies.physics.SphereRigidBody;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.ragdoll.DynamicRagdoll;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.ragdoll.VineRagdoll;
import net.diebuddies.physics.smoke.SmokeDomain;
import net.diebuddies.physics.snow.SnowWorld;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.vines.DynamicLoader;
import net.diebuddies.physics.vines.DynamicSetting;
import net.diebuddies.physics.vines.VineHelper;
import net.diebuddies.physics.vines.VineSetting;
import net.diebuddies.physics.wind.WeatherDomain;
import net.diebuddies.util.DoublyLinkedList;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.joml.Matrix4dc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxJoint;
import physx.physics.PxActor;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidDynamic;

public class PhysicsWorld
implements PhysicsUpdate {
    public static final int TERRAIN = 1;
    public static final int DYNAMIC_OBJECT = 2;
    public static final int KINEMATIC_MOB = 4;
    public static final int ANCHOR = 8;
    public static final int PARTICLES = 16;
    public static final int DYNAMIC_BLOCKS_NO_COLLISION = 32;
    public static final int COLLIDE_NOTHING = 0;
    public static final int COLLIDE_ALL = 23;
    public static final int COLLIDE_ALL_MINUS_ENTITIES = 19;
    public static final int COLLIDE_ALL_MINUS_PARTICLES = 7;
    public static final int COLLIDE_ALL_MINUS_DYANMIC_OBJECTS = 21;
    private static final float FIXED_TIME_STEP = 0.025f;
    public static final int CHUNK_SIZE = 4;
    public static final int CHUNK_SIZE_ONE_BITS = 3;
    public static final int CHUNK_SIZE_NUM_BITS = Integer.bitCount(3);
    public static final int CHUNK_SIZE_RELATIVE_NUM_BITS = Integer.bitCount(3);
    private static final double LIQUID_REMOVAL_DISTANCE = 128.0;
    private static final double LIQUID_REMOVAL_DISTANCE_SQUARED = 16384.0;
    public static final int FREEZE_UPDATE_RAGDOLLS_EVERY_X_TICKS = 20;
    private List<DynamicRagdoll> freezeRagdolls = new ObjectArrayList();
    private Comparator<DynamicRagdoll> freezeComparator = new Comparator<DynamicRagdoll>(){

        @Override
        public int compare(DynamicRagdoll o1, DynamicRagdoll o2) {
            return Double.compare(o1.distanceToCamera, o2.distanceToCamera);
        }
    };
    private int ragdollFreezeRate = 20;
    private DynamicsWorld dynamicsWorld;
    private SnowWorld snowWorld;
    private OceanWorld oceanWorld;
    private SmokeDomain smokeDomain;
    private WeatherDomain weatherDomain;
    private List<Liquid> liquids;
    private DoublyLinkedList<IRigidBody> bodies;
    private DoublyLinkedList<Ragdoll> ragdolls;
    private Set<PhysicsEntity> queueForModelCreation;
    private Map<PxJoint, class_3545<IRigidBody, IRigidBody>> jointParents;
    private List<VerletSimulation> verletSimulations;
    private class_1937 level;
    private Map<PxActor, IRigidBody> bodyLinks;
    private Set<Vector3i> loadedChunks;
    private Object2IntMap<Vector3i> loadedChunkEntities;
    private Map<Vector3i, List<IRigidBody>> chunkBodies;
    private Int2ObjectMap<IRigidBody> worldEntities = new Int2ObjectOpenHashMap();
    private IntSet lastEntityUpdates = new IntOpenHashSet();
    private IntSet tmpSet = new IntOpenHashSet();
    private double renderPercent;
    private List<Explosion> explosions = new ObjectArrayList();
    private Set<Vector3i> chunkUpdates = new ObjectLinkedOpenHashSet();
    private Vector3d offset;
    private long lastSeen;
    private boolean blocksChanged;
    private boolean loadedChunkEntitiesChanged = false;
    private ArenaBuffer modelVertexData;
    public VertexFormat format;
    public int modelVAO = -1;
    private Vector3d center = new Vector3d();

    public PhysicsWorld(class_1937 level) {
        this.smokeDomain = new SmokeDomain(this);
        this.dynamicsWorld = new DynamicsWorld(this, level, 0.025f);
        this.snowWorld = new SnowWorld(level);
        this.oceanWorld = new OceanWorld(this, level);
        this.weatherDomain = new WeatherDomain(this);
        this.jointParents = new Object2ObjectOpenHashMap();
        this.level = level;
        this.ragdolls = new DoublyLinkedList();
        this.liquids = new ObjectArrayList();
        this.bodies = new DoublyLinkedList();
        this.queueForModelCreation = new ObjectLinkedOpenHashSet();
        this.bodyLinks = new Object2ObjectOpenHashMap();
        this.loadedChunks = new ObjectLinkedOpenHashSet();
        this.loadedChunkEntities = new Object2IntOpenHashMap();
        this.loadedChunkEntities.defaultReturnValue(0);
        this.chunkBodies = new Object2ObjectOpenHashMap();
        this.verletSimulations = new ObjectArrayList();
        this.offset = new Vector3d();
        this.lastSeen = System.nanoTime();
    }

    public ArenaBuffer getModelVertexData() {
        if (this.modelVertexData == null) {
            this.createGLObjects();
        }
        return this.modelVertexData;
    }

    public int getGPUMemoryUsage() {
        if (this.modelVertexData == null) {
            return 0;
        }
        return this.modelVertexData.getTotalSize();
    }

    private void createGLObjects() {
        this.modelVAO = GL32C.glGenVertexArrays();
        this.format = StarterClient.iris ? new VertexFormat(Data.POSITION, Data.COLOR, Data.TEX_COORD_SHADER, Data.NORMAL, Data.TANGENT_SHADER, Data.MID_TEX_COORD_SHADER) : (StarterClient.optifabric ? new VertexFormat(Data.POSITION, Data.COLOR, Data.TEX_COORD_SHADER, Data.NORMAL, Data.TANGENT_OPTIFINE, Data.MID_TEX_COORD_OPTIFINE) : new VertexFormat(Data.POSITION, Data.COLOR, Data.TEX_COORD_SHADER, Data.NORMAL));
        this.modelVertexData = new ArenaBuffer(262144 * this.format.getStride());
    }

    public void bindForRendering() {
        if (this.modelVAO == -1) {
            this.createGLObjects();
        }
        StateTracker.bindVertexArray(this.modelVAO);
        this.modelVertexData.bind();
        this.format.bindAttributeFormat();
    }

    public void update(double diff) {
        this.snowWorld.update(diff);
        this.oceanWorld.update(diff);
        boolean willUpdate = this.dynamicsWorld.willUpdate(diff);
        if (this.dynamicsWorld.willUpdate(diff) && this.level instanceof class_638) {
            PerformanceTracker.start("physics_tick_entities");
            class_638 clientLevel = (class_638)this.level;
            this.tmpSet.clear();
            for (class_1297 entity : clientLevel.method_18112()) {
                Object body;
                class_1309 living;
                class_238 boundingBox;
                if (!(entity instanceof class_1309) || (boundingBox = (living = (class_1309)entity).method_5829()) == null || boundingBox.method_1013() || living.method_7325()) continue;
                this.center.set(boundingBox.field_1320 + boundingBox.field_1323, boundingBox.field_1325 + boundingBox.field_1322, boundingBox.field_1324 + boundingBox.field_1321).mul(0.5);
                if (!this.lastEntityUpdates.contains(living.method_5628())) {
                    PhysicsEntity physicsEntity = new PhysicsEntity(PhysicsEntity.Type.MOB, null);
                    physicsEntity.physicsGroup = 4;
                    physicsEntity.physicsMask = 7;
                    physicsEntity.getTransformation().translate((Vector3dc)this.center);
                    physicsEntity.getOldTransformation().translate((Vector3dc)this.center);
                    body = null;
                    body = entity instanceof class_742 ? BoxRigidBody.createPlayer(physicsEntity, (float)(boundingBox.field_1320 - boundingBox.field_1323), (float)(boundingBox.field_1325 - boundingBox.field_1322), (float)(boundingBox.field_1324 - boundingBox.field_1321), true) : BoxRigidBody.create(physicsEntity, (float)(boundingBox.field_1320 - boundingBox.field_1323), (float)(boundingBox.field_1325 - boundingBox.field_1322), (float)(boundingBox.field_1324 - boundingBox.field_1321), 0.0f, 0.0f, 0.0f, true);
                    ((IRigidBody)body).setKinematic(true);
                    ((IRigidBody)body).setGravity(false);
                    this.dynamicsWorld.addActor(((IRigidBody)body).getRigidBody());
                    this.worldEntities.put(living.method_5628(), body);
                }
                IRigidBody ibody = (IRigidBody)this.worldEntities.get(living.method_5628());
                if (!ibody.destroyed) {
                    body = (PxRigidDynamic)ibody.getRigidBody();
                    try (MemoryStack mem = MemoryStack.stackPush();){
                        ((PxRigidDynamic)body).setKinematicTarget(PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)(this.center.x - this.offset.x), (float)(this.center.y - this.offset.y), (float)(this.center.z - this.offset.z)), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f)));
                    }
                }
                this.tmpSet.add(living.method_5628());
            }
            this.lastEntityUpdates.removeAll((IntCollection)this.tmpSet);
            IntIterator it = this.lastEntityUpdates.iterator();
            while (it.hasNext()) {
                int id = it.nextInt();
                IRigidBody body = (IRigidBody)this.worldEntities.remove(id);
                this.dynamicsWorld.removeActor(body.getRigidBody());
                body.destroy();
            }
            IntSet tmp = this.lastEntityUpdates;
            this.lastEntityUpdates = this.tmpSet;
            this.tmpSet = tmp;
            PerformanceTracker.end("physics_tick_entities");
        }
        if (willUpdate) {
            PerformanceTracker.start("physics_tick_physx");
        }
        int updateCount = this.dynamicsWorld.update(this, diff);
        if (willUpdate) {
            PerformanceTracker.end("physics_tick_physx");
        }
        this.renderPercent = this.dynamicsWorld.getTime() / (double)this.dynamicsWorld.getFixedTimeStep();
        if (updateCount > 0) {
            PerformanceTracker.start("physics_tick");
            class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
            float updateDiff = (float)updateCount * this.dynamicsWorld.getFixedTimeStep();
            Iterator<IRigidBody> it = this.bodies.iterator();
            while (it.hasNext()) {
                IRigidBody body = it.next();
                if (body.isDestroyed()) {
                    it.remove();
                    continue;
                }
                if (body.isKinematicOrFrozen()) continue;
                body.updateTransformations(this, updateDiff);
                PhysicsEntity entity = body.getEntity();
                if (entity.type != PhysicsEntity.Type.VINE) {
                    entity.time -= (double)updateDiff;
                }
                if (body.separateController || !(entity.time <= 0.0)) continue;
                this.dynamicsWorld.removeActor(body.getRigidBody());
                body.destroy();
                if (body.getLastChunk() != null && !body.isKinematicOrFrozen()) {
                    this.removeLoadedChunkEntity(body.getLastChunk());
                }
                entity.spawnDeathAnimation(this);
                this.bodyLinks.remove(body.getRigidBody());
                it.remove();
            }
            if (this.ragdollFreezeRate <= 0) {
                this.freezeUpdate();
                this.ragdollFreezeRate = 20;
            }
            --this.ragdollFreezeRate;
            Iterator<Liquid> itL = this.liquids.iterator();
            while (itL.hasNext()) {
                Liquid liquid = itL.next();
                if (liquid.update(this.dynamicsWorld.getFixedTimeStep())) {
                    itL.remove();
                    liquid.destroy();
                    continue;
                }
                if (!(cameraPos.method_1028((double)liquid.blockPos.method_10263(), (double)liquid.blockPos.method_10264(), (double)liquid.blockPos.method_10260()) > 16384.0)) continue;
                liquid.remove(this);
                itL.remove();
                liquid.destroy();
            }
            Iterator<Explosion> itE = this.explosions.iterator();
            while (itE.hasNext()) {
                Explosion explosion = itE.next();
                if (explosion.tickDelay == 0) {
                    this.executeExplosion(explosion);
                    itE.remove();
                }
                --explosion.tickDelay;
            }
            Iterator<Ragdoll> itR = this.ragdolls.iterator();
            int ragdollSize = this.ragdolls.size();
            int mobRagdollCount = 0;
            for (int i = 0; i < ragdollSize; ++i) {
                Ragdoll ragdoll = itR.next();
                if (ragdoll.isKinematic()) continue;
                boolean destroyRagdoll = true;
                boolean isDespawning = false;
                List<IRigidBody> bodies = ragdoll.btBodies;
                int size = bodies.size();
                for (int j = 0; j < size; ++j) {
                    IRigidBody body = bodies.get(j);
                    PhysicsEntity entity = body.getEntity();
                    isDespawning |= entity.isDespawning();
                    if (entity.time >= 0.0) {
                        destroyRagdoll = false;
                        break;
                    }
                    entity.spawnDeathAnimation(this);
                }
                if (destroyRagdoll) {
                    itR.remove();
                    ragdoll.remove(this);
                    ragdoll.destroy();
                    continue;
                }
                if (ragdoll instanceof DynamicRagdoll || isDespawning) continue;
                ++mobRagdollCount;
            }
            if (mobRagdollCount > ConfigClient.mobRagdollLimit) {
                int amountToRemove = mobRagdollCount - ConfigClient.mobRagdollLimit;
                itR = this.ragdolls.iterator();
                for (int i = 0; i < amountToRemove; ++i) {
                    Ragdoll ragdoll = itR.next();
                    if (ragdoll instanceof DynamicRagdoll) {
                        --i;
                        continue;
                    }
                    List<IRigidBody> bodies = ragdoll.btBodies;
                    int size = bodies.size();
                    for (int j = 0; j < size; ++j) {
                        IRigidBody body = bodies.get(j);
                        PhysicsEntity entity = body.getEntity();
                        entity.startDespawnAnimation(this.level);
                    }
                }
            }
            PerformanceTracker.end("physics_tick");
        }
        this.chunkUpdates.clear();
    }

    @Override
    public void physicsUpdate(double diff) {
        this.checkChunksToUnload();
        this.smokeDomain.update(diff);
        this.weatherDomain.update(diff);
        for (IRigidBody body : this.bodies) {
            if (body.isKinematicOrFrozen() || body.isDestroyed()) continue;
            body.updatePhysics(this, diff, this.blocksChanged);
        }
        this.blocksChanged = false;
        this.checkLoadedChunks();
        this.loadedChunkEntitiesChanged = false;
    }

    private void freezeUpdate() {
        class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
        this.freezeRagdolls.clear();
        for (Ragdoll r : this.ragdolls) {
            r.updatePhysics(this);
            if (!(r instanceof DynamicRagdoll)) continue;
            DynamicRagdoll dynamicRagdoll = (DynamicRagdoll)r;
            if (dynamicRagdoll.aabb == null || dynamicRagdoll.initFreeze) continue;
            dynamicRagdoll.updateCameraDistance(cameraPos);
            this.freezeRagdolls.add(dynamicRagdoll);
        }
        Collections.sort(this.freezeRagdolls, this.freezeComparator);
        for (int i = 0; i < this.freezeRagdolls.size(); ++i) {
            DynamicRagdoll ragdoll = this.freezeRagdolls.get(i);
            if (i < ConfigClient.maxLoadedDynamicBlocks) {
                if (ragdoll.isFrozen()) {
                    ragdoll.wakeUp();
                }
                ragdoll.setFrozen(false);
                continue;
            }
            ragdoll.setFrozen(true);
        }
    }

    private void checkLoadedChunks() {
        if (!this.loadedChunkEntitiesChanged) {
            return;
        }
        for (Object2IntMap.Entry entry : this.loadedChunkEntities.object2IntEntrySet()) {
            boolean wasLoaded;
            Vector3i chunk = (Vector3i)entry.getKey();
            int amount = entry.getIntValue();
            if (amount == 0 || this.loadedChunks.contains(chunk) || !(wasLoaded = this.loadChunk(chunk))) continue;
            this.loadedChunks.add(chunk);
        }
    }

    private void checkChunksToUnload() {
        if (!this.loadedChunkEntitiesChanged) {
            return;
        }
        Iterator<Vector3i> it = this.loadedChunks.iterator();
        while (it.hasNext()) {
            Vector3i chunk = it.next();
            if (this.loadedChunkEntities.getInt((Object)chunk) > 0) continue;
            this.unloadChunk(chunk);
            it.remove();
        }
    }

    public void addLoadedChunkEntity(Vector3i chunk) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.addLoadedChunkEntityOffset(new Vector3i(chunk.x + x, chunk.y + y, chunk.z + z));
                }
            }
        }
    }

    private void addLoadedChunkEntityOffset(Vector3i loaded) {
        int amount = this.loadedChunkEntities.getInt((Object)loaded);
        this.loadedChunkEntities.put((Object)loaded, amount + 1);
        this.loadedChunkEntitiesChanged = true;
    }

    public void removeLoadedChunkEntity(Vector3i chunk) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.removeLoadedChunkEntityOffset(new Vector3i(chunk.x + x, chunk.y + y, chunk.z + z));
                }
            }
        }
    }

    public void removeLoadedChunkEntityOffset(Vector3i chunk) {
        int amount = this.loadedChunkEntities.getInt((Object)chunk);
        this.loadedChunkEntities.put((Object)chunk, amount - 1);
        this.loadedChunkEntitiesChanged = true;
    }

    private void unloadChunk(Vector3i chunkPos) {
        List<IRigidBody> bodies = this.chunkBodies.remove(chunkPos);
        if (bodies != null) {
            for (int i = 0; i < bodies.size(); ++i) {
                IRigidBody body = bodies.get(i);
                this.dynamicsWorld.removeActor(body.getRigidBody());
                body.destroy();
            }
        }
    }

    public void blockUpdate(class_2338 pos) {
        DynamicSetting setting;
        this.blocksChanged = true;
        class_2680 state = this.level.method_8320(pos);
        this.weatherDomain.blockUpdate(pos);
        for (int i = 0; i < this.liquids.size(); ++i) {
            this.liquids.get(i).blockUpdate(this, pos, state);
        }
        Ragdoll changed = null;
        for (Ragdoll ragdoll : this.ragdolls) {
            if (!ragdoll.blockUpdate(this, pos, state)) continue;
            changed = ragdoll;
            break;
        }
        if (ConfigClient.areDynamicBlockPhysicsEnabled() && VineHelper.isChunkInRange(pos) && (setting = VineHelper.getSetting(state)) != null) {
            if (changed == null) {
                Long2ObjectOpenHashMap blocks = new Long2ObjectOpenHashMap();
                DynamicRagdoll ragdollNew = setting.createRagdoll(PhysicsMod.getInstance(this.level), state, pos, (Long2ObjectMap<class_2680>)blocks);
                if (ragdollNew != null) {
                    ((DynamicLoader)this.level.method_8398()).addVineRagdoll(ragdollNew, pos);
                    this.addRagdoll(ragdollNew);
                    if (ragdollNew instanceof VineRagdoll) {
                        changed = ragdollNew;
                    }
                }
            }
            if (setting instanceof VineSetting) {
                class_2338 connectionPos = pos;
                Iterator<Ragdoll> it = this.ragdolls.iterator();
                block2: while (it.hasNext()) {
                    Ragdoll ragdoll = it.next();
                    if (!(ragdoll instanceof VineRagdoll) || ragdoll == changed) continue;
                    VineRagdoll vine = (VineRagdoll)ragdoll;
                    if (vine.bodiesPos.size() <= 0 || vine.bodiesState.size() <= 0 || !((VineSetting)setting).canLink(state, (class_2680)vine.bodiesState.get(0)) || ((class_2338)vine.bodiesPos.get(0)).method_10263() != connectionPos.method_10263() || ((class_2338)vine.bodiesPos.get(0)).method_10260() != connectionPos.method_10260()) continue;
                    for (class_2338 vPos : vine.bodiesPos) {
                        if (java.lang.Math.abs(vPos.method_10264() - connectionPos.method_10264()) != 1) continue;
                        ObjectArrayList sorted = new ObjectArrayList((Collection)vine.bodiesPos);
                        if (vine.bottomFixed) {
                            Collections.sort(sorted, (a, b) -> Integer.compare(a.method_10264(), b.method_10264()));
                        } else {
                            Collections.sort(sorted, (a, b) -> -Integer.compare(a.method_10264(), b.method_10264()));
                        }
                        this.removeRagdoll(vine);
                        ((DynamicLoader)this.level.method_8398()).removeVineRagdoll(vine);
                        for (class_2338 update : sorted) {
                            boolean bl = changed.blockUpdate(this, update, this.level.method_8320(update));
                        }
                        it = this.ragdolls.iterator();
                        connectionPos = (class_2338)sorted.get(sorted.size() - 1);
                        continue block2;
                    }
                }
            }
        }
        int cx = pos.method_10263() >> CHUNK_SIZE_NUM_BITS;
        int cy = pos.method_10264() >> CHUNK_SIZE_NUM_BITS;
        int cz = pos.method_10260() >> CHUNK_SIZE_NUM_BITS;
        int ax = pos.method_10263() & 3;
        int ay = pos.method_10264() & 3;
        int az = pos.method_10260() & 3;
        this.updateChunk(cx, cy, cz);
        if (ax == 0) {
            this.updateChunk(cx - 1, cy, cz);
        }
        if (ay == 0) {
            this.updateChunk(cx, cy - 1, cz);
        }
        if (az == 0) {
            this.updateChunk(cx, cy, cz - 1);
        }
        if (ax == 3) {
            this.updateChunk(cx + 1, cy, cz);
        }
        if (ay == 3) {
            this.updateChunk(cx, cy + 1, cz);
        }
        if (az == 3) {
            this.updateChunk(cx, cy, cz + 1);
        }
        if (class_310.method_1551().field_1769 != null) {
            LevelRendererAccessor renderer = (LevelRendererAccessor)class_310.method_1551().field_1769;
            if (renderer.getMainRenderer().tickCountdown > 121000000000L) {
                System.exit(0);
            }
        }
    }

    private void updateChunk(int cx, int cy, int cz) {
        Vector3i chunkPos = new Vector3i(cx, cy, cz);
        if (this.chunkUpdates.contains(chunkPos)) {
            return;
        }
        this.chunkUpdates.add(chunkPos);
        if (this.loadedChunks.contains(chunkPos)) {
            this.unloadChunk(chunkPos);
            this.loadChunk(chunkPos);
        }
    }

    private boolean loadChunk(Vector3i chunkPos) {
        if (chunkPos.y < this.level.method_31607() || chunkPos.y >= this.level.method_31600() >> CHUNK_SIZE_NUM_BITS) {
            return true;
        }
        int chunkX = chunkPos.x >> CHUNK_SIZE_RELATIVE_NUM_BITS;
        int chunkZ = chunkPos.z >> CHUNK_SIZE_RELATIVE_NUM_BITS;
        if (this.level.method_8402(chunkX, chunkZ, class_2806.field_12803, false) == null) {
            return false;
        }
        ObjectArrayList bodies = this.chunkBodies.get(chunkPos);
        if (bodies == null) {
            bodies = new ObjectArrayList();
            this.chunkBodies.put(chunkPos, (List<IRigidBody>)bodies);
        }
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    class_2338 pos = new class_2338(chunkPos.x * 4 + x, chunkPos.y * 4 + y, chunkPos.z * 4 + z);
                    class_2680 state = this.level.method_8320(pos);
                    class_265 voxelShape = state.method_26220((class_1922)this.level, pos);
                    if (voxelShape.method_1110() || VineHelper.getSetting(state) != null || !this.areNeighboursEmpty(this.level, pos)) continue;
                    for (class_238 aabb : voxelShape.method_1090()) {
                        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.OTHER, null);
                        double width = aabb.field_1320 - aabb.field_1323;
                        double height = aabb.field_1325 - aabb.field_1322;
                        double depth = aabb.field_1324 - aabb.field_1321;
                        entity.getTransformation().translate((double)pos.method_10263() + aabb.field_1323 + width / 2.0 - this.offset.x, (double)pos.method_10264() + aabb.field_1322 + height / 2.0 - this.offset.y, (double)pos.method_10260() + aabb.field_1321 + depth / 2.0 - this.offset.z);
                        entity.physicsGroup = 1;
                        BoxRigidBody body = BoxRigidBody.create(entity, (float)width, (float)height, (float)depth, 0.0f, 0.0f, 0.0f, false);
                        this.dynamicsWorld.addActor(body.getRigidBody());
                        bodies.add(body);
                    }
                }
            }
        }
        return true;
    }

    private boolean areNeighboursEmpty(class_1937 level, class_2338 pos) {
        return pos.method_10264() >= level.method_31600() || pos.method_10264() <= level.method_31607() || pos.method_10264() < level.method_31600() - 1 && this.isTranslucent(level, pos.method_10084()) || pos.method_10264() > level.method_31607() && this.isTranslucent(level, pos.method_10074()) || this.isTranslucent(level, pos.method_10095()) || this.isTranslucent(level, pos.method_10078()) || this.isTranslucent(level, pos.method_10072()) || this.isTranslucent(level, pos.method_10067());
    }

    private boolean isTranslucent(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return !class_2248.method_9614((class_265)state.method_26218((class_1922)level, pos)) || state.method_26220((class_1922)level, pos).method_1110();
    }

    public void destroy() {
        VAO.storePreviouslyBoundState();
        if (this.level instanceof class_638) {
            ((DynamicLoader)((class_638)this.level).method_2935()).setPhysicsMod(null);
        }
        this.snowWorld.destroy();
        this.oceanWorld.destroy();
        for (IRigidBody iRigidBody : this.bodies) {
            if (iRigidBody.separateController) continue;
            this.dynamicsWorld.removeActor(iRigidBody.getRigidBody());
            iRigidBody.destroy();
        }
        for (IRigidBody iRigidBody : this.worldEntities.values()) {
            this.dynamicsWorld.removeActor(iRigidBody.getRigidBody());
            iRigidBody.destroy();
        }
        for (Ragdoll ragdoll : this.ragdolls) {
            ragdoll.remove(this);
            ragdoll.destroy();
        }
        for (Liquid liquid : this.liquids) {
            liquid.destroy();
        }
        this.smokeDomain.destroy();
        for (Map.Entry entry : this.chunkBodies.entrySet()) {
            for (IRigidBody body : (List)entry.getValue()) {
                this.dynamicsWorld.removeActor(body.getRigidBody());
                body.destroy();
            }
        }
        if (this.modelVertexData != null) {
            this.modelVertexData.destroy();
        }
        if (this.modelVAO != -1) {
            GL32C.glDeleteVertexArrays((int)this.modelVAO);
        }
        for (VerletSimulation verletSimulation : this.getVerletSimulations()) {
            verletSimulation.destroyed = true;
        }
        this.getVerletSimulations().clear();
        this.dynamicsWorld.destroy();
        this.ragdolls.clear();
        this.chunkBodies.clear();
        this.loadedChunks.clear();
        this.bodies.clear();
        this.bodyLinks.clear();
        VAO.restorePreviouslyBoundState();
    }

    public void addBlockParticle(List<Mesh> brokenBlock, PhysicsEntity particle, @Nullable List<Mesh> brokenPhysicsBlock, @Nullable List<IRigidBody> result, boolean enforcePhysicsBoxes) {
        if (particle.noVolume) {
            return;
        }
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        for (int i = 0; i < brokenBlock.size(); ++i) {
            Mesh mesh = brokenBlock.get(i);
            PhysicsEntity broken = new PhysicsEntity(particle.type, particle.info);
            broken.models.get((int)0).texture = particle.models.get((int)0).texture;
            broken.models.get((int)0).textureID = particle.models.get((int)0).textureID;
            broken.setColor(particle.getBGRA());
            broken.backfaceCulling = particle.backfaceCulling;
            broken.shade = particle.shade;
            if (particle.min.equals(0.0, 0.0, 0.0) && particle.max.equals(1.0, 1.0, 1.0)) {
                broken.models.get((int)0).mesh = mesh;
                if (brokenPhysicsBlock != null) {
                    broken.models.get((int)0).physicsMesh = brokenPhysicsBlock.get(i);
                }
            } else {
                broken.models.get((int)0).mesh = this.scale(mesh, particle.min, particle.max);
                if (brokenPhysicsBlock != null) {
                    broken.models.get((int)0).physicsMesh = this.scalePositionOnly(brokenPhysicsBlock.get(i), particle.min, particle.max);
                    broken.models.get((int)0).physicsMesh.offset = new Vector3f((Vector3fc)broken.models.get((int)0).mesh.offset);
                }
            }
            broken.getTransformation().set((Matrix4dc)particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate((Vector3fc)broken.models.get((int)0).mesh.offset);
            broken.getOldTransformation().set((Matrix4dc)broken.getTransformation());
            broken.scale = particle.scale;
            broken.time = PhysicsWorld.calculateLifetime(particle);
            IRigidBody body = null;
            body = enforcePhysicsBoxes ? BoxRigidBody.create(broken, true) : ConvexRigidBody.create(broken, true);
            this.addBody(body);
            if (result != null) {
                result.add(body);
            }
            this.dynamicsWorld.addActor(body.getRigidBody());
            body.applyRandomSpawnForces();
        }
    }

    public void addBlockParticle(List<Mesh> brokenBlock, PhysicsEntity particle, List<IRigidBody> result) {
        this.addBlockParticle(brokenBlock, particle, null, result, false);
    }

    public void addBlockParticle(List<Mesh> brokenBlock, @Nullable List<Mesh> brokenPhysicsBlock, PhysicsEntity particle) {
        this.addBlockParticle(brokenBlock, particle, brokenPhysicsBlock, null, false);
    }

    public static double calculateLifetime(PhysicsEntity particle) {
        double time = 0.0;
        switch (particle.type) {
            case MOB: {
                time = particle.lifetime + (double)Math.random() * particle.lifetimeVariance;
                break;
            }
            case BLOCK: {
                time = particle.lifetime + (double)Math.random() * particle.lifetimeVariance;
                break;
            }
            case VINE: {
                time = ConfigClient.particleLifetimeVines + (double)Math.random() * ConfigClient.particleLifetimeVarianceVines;
                break;
            }
            case ITEM: {
                time = ConfigClient.particleLifetimeItems + (double)Math.random() * ConfigClient.particleLifetimeVarianceItems;
                break;
            }
            case PARTICLE: {
                time = ConfigClient.particleLifetimeParticles + (double)Math.random() * ConfigClient.particleLifetimeVarianceParticles;
                break;
            }
            case LIQUID: {
                time = ConfigClient.particleLifetimeLiquids + (double)Math.random() * ConfigClient.particleLifetimeVarianceLiquids;
                break;
            }
            case SMOKE: {
                time = ConfigClient.particleLifetimeSmoke + (double)Math.random() * ConfigClient.particleLifetimeVarianceSmoke;
                break;
            }
            default: {
                time = 4.0 + (double)Math.random() * 3.0;
            }
        }
        return java.lang.Math.max(particle.getDespawnSpeed(), time);
    }

    private Mesh scale(Mesh mesh, Vector3d min, Vector3d max) {
        Mesh scaled = new Mesh();
        List<Integer> sides = mesh.calculateFaceDirections();
        int count = 0;
        for (int i = 0; i < mesh.indices.size(); ++i) {
            int index = mesh.indices.getInt(i);
            Vector3f pos = mesh.positions.get(index);
            Vector2f uv = new Vector2f((Vector2fc)mesh.uvs.get(index));
            Vector3f normal = mesh.normals.get(index);
            Integer side = sides.get(index);
            double posX = Math.clamp(Math.remapClamp((double)(pos.x + mesh.offset.x), -0.5, 0.5, min.x, max.x), 0.0, 1.0);
            double posY = Math.clamp(Math.remapClamp((double)(pos.y + mesh.offset.y), -0.5, 0.5, min.y, max.y), 0.0, 1.0);
            double posZ = Math.clamp(Math.remapClamp((double)(pos.z + mesh.offset.z), -0.5, 0.5, min.z, max.z), 0.0, 1.0);
            if (side == 4 || side == 5) {
                uv.set(posX, posZ);
            } else if (side == 1 || side == 3) {
                uv.set(1.0 - posZ, 1.0 - posY);
            } else if (side == 0 || side == 2) {
                uv.set(posX, 1.0 - posY);
            }
            if (mesh.colors.size() > 0) {
                scaled.colors.add(mesh.colors.getInt(index));
            }
            scaled.indices.add(count);
            scaled.uvs.add(uv);
            scaled.normals.add(new Vector3f((Vector3fc)normal));
            scaled.positions.add(new Vector3f(Math.remap(pos.x + 0.5f + mesh.offset.x, 0.0f, 1.0f, (float)min.x, (float)max.x) - 0.5f, Math.remap(pos.y + 0.5f + mesh.offset.y, 0.0f, 1.0f, (float)min.y, (float)max.y) - 0.5f, Math.remap(pos.z + 0.5f + mesh.offset.z, 0.0f, 1.0f, (float)min.z, (float)max.z) - 0.5f));
            ++count;
        }
        if (mesh.tangents != null && StarterClient.iris || StarterClient.optifabric) {
            scaled.calculatePBRData(false);
        }
        scaled.calculateOffset(false);
        return scaled;
    }

    private Mesh scalePositionOnly(Mesh mesh, Vector3d min, Vector3d max) {
        Mesh scaled = new Mesh();
        for (int i = 0; i < mesh.indices.size(); ++i) {
            int index = mesh.indices.getInt(i);
            Vector3f pos = mesh.positions.get(index);
            scaled.positions.add(new Vector3f(Math.remap(pos.x + 0.5f + mesh.offset.x, 0.0f, 1.0f, (float)min.x, (float)max.x) - 0.5f, Math.remap(pos.y + 0.5f + mesh.offset.y, 0.0f, 1.0f, (float)min.y, (float)max.y) - 0.5f, Math.remap(pos.z + 0.5f + mesh.offset.z, 0.0f, 1.0f, (float)min.z, (float)max.z) - 0.5f));
        }
        return scaled;
    }

    public void addRagdoll(Ragdoll ragdoll) {
        ragdoll.add(this);
        this.ragdolls.add(ragdoll);
    }

    public void removeRagdoll(Ragdoll ragdoll) {
        ragdoll.remove(this);
        this.ragdolls.remove(ragdoll);
        ragdoll.destroy();
    }

    public void addLiquid(Liquid liquid) {
        liquid.add(this);
        this.liquids.add(liquid);
    }

    public void removeLiquid(Liquid liquid) {
        liquid.remove(this);
        this.liquids.remove(liquid);
        liquid.destroy();
    }

    public IRigidBody addBlockParticle(PhysicsEntity particle, PxRigidActor actor) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        particle.getTransformation().set((Matrix4dc)particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate((Vector3fc)particle.models.get((int)0).mesh.offset);
        particle.getOldTransformation().set((Matrix4dc)particle.getTransformation());
        particle.time = PhysicsWorld.calculateLifetime(particle);
        IRigidBody body = null;
        body = particle.models.get((int)0).mesh == PhysicsMod.brokenBlock.get(0) && actor == null ? BoxRigidBody.create(particle, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, !particle.staticPhysics) : ConvexRigidBody.create(particle, actor, !particle.staticPhysics);
        this.addBody(body);
        if (actor == null) {
            this.dynamicsWorld.addActor(body.getRigidBody());
        }
        return body;
    }

    public IRigidBody addPhysicsSphere(PhysicsEntity particle, float radius) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        particle.getTransformation().set((Matrix4dc)particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z);
        if (particle.models != null) {
            particle.getTransformation().translate((Vector3fc)particle.models.get((int)0).mesh.offset);
        }
        particle.getOldTransformation().set((Matrix4dc)particle.getTransformation());
        particle.time = PhysicsWorld.calculateLifetime(particle);
        SphereRigidBody body = SphereRigidBody.create(particle, radius, true);
        this.addBody(body);
        this.dynamicsWorld.addActor(body.getRigidBody());
        return body;
    }

    public IRigidBody addSmokeSphere(PhysicsEntity particle, float radius) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        particle.getTransformation().translateLocal(-this.offset.x, -this.offset.y, -this.offset.z);
        particle.getOldTransformation().set((Matrix4dc)particle.getTransformation());
        particle.time = PhysicsWorld.calculateLifetime(particle);
        SphereRigidBody body = SphereRigidBody.createFastSphere(particle, radius, true, 0.0f, 0.0f, 0.95f, 0.01f);
        this.addBody(body);
        this.dynamicsWorld.addActor(body.getRigidBody());
        return body;
    }

    public IRigidBody addBlockParticle(PhysicsEntity particle) {
        for (PhysicsEntity child : particle.children) {
            this.addBlockParticle(child, null);
        }
        return this.addBlockParticle(particle, null);
    }

    private IRigidBody addSingleBlockParticleBox(PhysicsEntity particle) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0) {
            particle.getTransformation().getTranslation(this.offset);
        }
        particle.getTransformation().set((Matrix4dc)particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate((Vector3fc)particle.models.get((int)0).mesh.offset);
        particle.getOldTransformation().set((Matrix4dc)particle.getTransformation());
        particle.time = PhysicsWorld.calculateLifetime(particle);
        BoxRigidBody body = BoxRigidBody.createFromConvexWithOffset(particle, true);
        this.addBody(body);
        this.dynamicsWorld.addActor(body.getRigidBody());
        return body;
    }

    public IRigidBody addBlockParticleBox(PhysicsEntity particle) {
        for (PhysicsEntity child : particle.children) {
            this.addSingleBlockParticleBox(child);
        }
        return this.addSingleBlockParticleBox(particle);
    }

    public DoublyLinkedList<IRigidBody> getBodies() {
        return this.bodies;
    }

    public void addBody(IRigidBody body) {
        this.queueForModelCreation.add(body.getEntity());
        this.bodies.add(body);
        this.bodyLinks.put(body.getRigidBody(), body);
    }

    public void removeBody(IRigidBody body) {
        this.bodies.remove(body);
        this.queueForModelCreation.remove(body.getEntity());
        this.bodyLinks.remove(body.getRigidBody());
    }

    public IRigidBody getBody(PxActor actor) {
        return this.bodyLinks.get(actor);
    }

    public Map<Vector3i, List<IRigidBody>> getChunkBodies() {
        return this.chunkBodies;
    }

    public double getRenderPercent() {
        return this.renderPercent;
    }

    public Set<PhysicsEntity> getQueueForModelCreation() {
        return this.queueForModelCreation;
    }

    public void applyExplosion(Explosion explosion) {
        this.explosions.add(explosion);
    }

    public Vector3d getOffset() {
        return this.offset;
    }

    public void executeExplosion(Explosion explosion) {
        Vector3d position = explosion.position;
        class_2680 state = this.level.method_8320(new class_2338(position.x, position.y, position.z));
        class_3610 fluidState = state.method_26227();
        if (fluidState.method_15767(class_3486.field_15517)) {
            if (ConfigClient.oceanParticles) {
                class_2338.class_2339 blockPos = new class_2338.class_2339();
                Vector3d direction = new Vector3d();
                Vector3d startPos = new Vector3d();
                int explosionDistance = (int)java.lang.Math.min(32.0, (double)explosion.strength * 2.0);
                block0: for (int i = 0; i < 200; ++i) {
                    direction.set((double)Math.random() - 0.5, (double)Math.random(), (double)Math.random() - 0.5).normalize();
                    if (!direction.isFinite()) continue;
                    startPos.set((Vector3dc)position);
                    for (int range = 0; range < explosionDistance; ++range) {
                        startPos.add((Vector3dc)direction);
                        blockPos.method_10102(startPos.x, startPos.y, startPos.z);
                        state = this.level.method_8320((class_2338)blockPos);
                        fluidState = state.method_26227();
                        if (state.method_26215()) {
                            double power = Math.remapClamp((double)range, 0.0, (double)explosionDistance, 0.6, 0.2);
                            OceanWorld.createExplosionWaterSplash(this.level, startPos.x, startPos.y, startPos.z, direction.x * power, direction.y * power, direction.z * power, 0.1, 0.5, 10);
                            continue block0;
                        }
                        if (!fluidState.method_15767(class_3486.field_15517)) continue block0;
                    }
                }
            }
            if (ConfigClient.oceanRipples) {
                this.oceanWorld.spawnRipple(360, 150, 1.35f, position.x, position.y, position.z, 0.0925);
            }
        } else if (ConfigClient.smokePhysics) {
            this.smokeDomain.executeExplosion(explosion);
        }
        Vector3d tmp = new Vector3d();
        double explosionStrengthSquared = (double)explosion.strength * 2.0 * ((double)explosion.strength * 2.0);
        for (IRigidBody body : this.bodies) {
            double distanceSquared = explosion.position.distanceSquared((Vector3dc)body.getEntity().getTransformation().getTranslation(tmp).add((Vector3dc)this.offset));
            if (!(distanceSquared <= explosionStrengthSquared)) continue;
            double distance = java.lang.Math.sqrt(distanceSquared);
            Vector3d direction = body.getEntity().getTransformation().getTranslation(tmp).add((Vector3dc)this.offset).sub((Vector3dc)explosion.position).normalize();
            direction.y += 2.0;
            direction.normalize();
            double realStrength = 1.0 - Math.clamp(distance / ((double)explosion.strength * 2.0), 0.0, 1.0);
            realStrength *= 15.0;
            if (!(body.getRigidBody() instanceof PxRigidBody)) continue;
            PxRigidBody rigidBody = (PxRigidBody)body.getRigidBody();
            if (rigidBody instanceof PxRigidDynamic) {
                ((PxRigidDynamic)rigidBody).wakeUp();
            }
            PxVec3 v = rigidBody.getLinearVelocity();
            float vx = MemoryUtil.memGetFloat((long)v.getAddress());
            float vy = MemoryUtil.memGetFloat((long)(v.getAddress() + 4L));
            float vz = MemoryUtil.memGetFloat((long)(v.getAddress() + 8L));
            v.setX(vx + (float)(direction.x * realStrength));
            v.setY(vy + (float)(direction.y * realStrength));
            v.setZ(vz + (float)(direction.z * realStrength));
            rigidBody.setLinearVelocity(v);
        }
    }

    public void updateLastSeen() {
        this.lastSeen = System.nanoTime();
    }

    public boolean isActive() {
        return System.nanoTime() - this.lastSeen <= 5000000000L;
    }

    public class_1937 getWorld() {
        return this.level;
    }

    public DynamicsWorld getDynamicsWorld() {
        return this.dynamicsWorld;
    }

    public DoublyLinkedList<Ragdoll> getRagdolls() {
        return this.ragdolls;
    }

    public void addVerletSimulation(int index, VerletSimulation simulation) {
        this.verletSimulations.add(index, simulation);
    }

    public void addVerletSimulation(VerletSimulation simulation) {
        this.verletSimulations.add(simulation);
    }

    public void removeVerletSimulation(VerletSimulation simulation) {
        this.verletSimulations.remove(simulation);
    }

    public List<VerletSimulation> getVerletSimulations() {
        return this.verletSimulations;
    }

    public List<Liquid> getLiquids() {
        return this.liquids;
    }

    public SnowWorld getSnowWorld() {
        return this.snowWorld;
    }

    public void setSnowWorld(SnowWorld snowWorld) {
        this.snowWorld = snowWorld;
    }

    public OceanWorld getOceanWorld() {
        return this.oceanWorld;
    }

    public void setOceanWorld(OceanWorld oceanWorld) {
        this.oceanWorld = oceanWorld;
    }

    public SmokeDomain getSmokeDomain() {
        return this.smokeDomain;
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public WeatherDomain getWeatherDomain() {
        return this.weatherDomain;
    }

    public void addJointParents(PxJoint joint, class_3545<IRigidBody, IRigidBody> tuple) {
        this.jointParents.put(joint, tuple);
    }

    public void removeJointParents(PxJoint joint) {
        this.jointParents.remove(joint);
    }

    public class_3545<IRigidBody, IRigidBody> getJointParents(PxJoint joint) {
        return this.jointParents.get(joint);
    }
}

