/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.vines;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.diebuddies.compat.Sodium;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.minecraft.ChunkHelper;
import net.diebuddies.minecraft.ClientChunkCacheAccessor;
import net.diebuddies.mixins.vines.StorageInvoker;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.ocean.thread.OceanChunkCreator;
import net.diebuddies.physics.ragdoll.DynamicRagdoll;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.snow.IChunk;
import net.diebuddies.physics.snow.SnowSearcher;
import net.diebuddies.physics.snow.SnowWorld;
import net.diebuddies.physics.snow.thread.ChunkCreator;
import net.diebuddies.physics.snow.thread.SnowChunkCreator;
import net.diebuddies.physics.vines.DynamicLoader;
import net.diebuddies.physics.vines.DynamicSetting;
import net.diebuddies.physics.vines.FastBlockSearcher;
import net.diebuddies.physics.vines.FastBlockSearcherConsumer;
import net.diebuddies.physics.vines.MultiSearcherConsumer;
import net.diebuddies.physics.vines.VineHelper;
import net.diebuddies.physics.vines.VineSearcher;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2837;
import net.minecraft.class_2841;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_631;
import net.minecraft.class_638;
import net.minecraft.class_6603;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_631.class})
public class MixinClientChunkManager
implements DynamicLoader,
ClientChunkCacheAccessor {
    @Shadow
    @Final
    protected volatile class_631.class_3681 field_16246;
    @Shadow
    @Final
    protected class_638 field_16525;
    @Unique
    protected Long2ObjectMap<List<DynamicRagdoll>> loadedVines = new Long2ObjectOpenHashMap();
    @Unique
    protected PhysicsMod mod;
    @Unique
    protected LongSet loadedChunksSodiumFix = new LongOpenHashSet();

    @Override
    public void chunkPosChanged() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        ObjectOpenHashSet affectedChunks = new ObjectOpenHashSet();
        while (it.hasNext()) {
            boolean shouldBeLoaded;
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            boolean isLoaded = this.loadedVines.containsKey(chunkIndex);
            if (isLoaded == (shouldBeLoaded = VineHelper.isChunkInRange(chunkX, chunkZ))) continue;
            if (isLoaded) {
                this.unloadDynamicBlockChunk(chunkX, chunkZ, (ObjectSet<Vector3i>)affectedChunks, true);
            } else {
                this.loadDynamicBlockChunk(((class_631)this).method_12126(chunkX, chunkZ, false), chunkX, chunkZ, (ObjectSet<Vector3i>)affectedChunks);
            }
            for (Vector3i affectedChunk : affectedChunks) {
                if (StarterClient.sodium) {
                    Sodium.scheduleChunkRebuild(class_310.method_1551().field_1769, affectedChunk.x, affectedChunk.y, affectedChunk.z, true);
                    continue;
                }
                class_310.method_1551().field_1769.method_3295(affectedChunk.x, affectedChunk.y, affectedChunk.z, true);
            }
            affectedChunks.clear();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"updateViewRadius"})
    public void updateLoadDistance(int loadDistance, CallbackInfo info) {
        int properLoadDistance = Math.max(loadDistance, 2) + 3;
        LongIterator itLoaded = this.loadedChunksSodiumFix.iterator();
        while (itLoaded.hasNext()) {
            int chunkZ;
            long chunkIndex = itLoaded.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            if (this.isInRadius(properLoadDistance, chunkX, chunkZ = ChunkHelper.getChunkZ(chunkIndex))) continue;
            itLoaded.remove();
        }
        if (this.mod != null) {
            ObjectIterator it = this.loadedVines.long2ObjectEntrySet().iterator();
            while (it.hasNext()) {
                int chunkZ;
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
                long chunkIndex = entry.getLongKey();
                List ragdolls = (List)entry.getValue();
                int chunkX = ChunkHelper.getChunkX(chunkIndex);
                if (this.isInRadius(properLoadDistance, chunkX, chunkZ = ChunkHelper.getChunkZ(chunkIndex))) continue;
                this.unloadRagdolls(ragdolls, false);
                it.remove();
            }
            if (ConfigClient.areSnowPhysicsEnabled()) {
                VAO.storePreviouslyBoundState();
                this.unloadAllSnow();
                this.loadAllSnow();
                VAO.restorePreviouslyBoundState();
            }
            if (ConfigClient.areOceanPhysicsEnabled()) {
                VAO.storePreviouslyBoundState();
                this.unloadAllOcean();
                this.loadAllOcean();
                VAO.restorePreviouslyBoundState();
            }
        }
    }

    @Unique
    public boolean isInRadius(int radius, int chunkX, int chunkZ) {
        return Math.abs(chunkX - this.field_16246.field_19204) <= radius && Math.abs(chunkZ - this.field_16246.field_19205) <= radius;
    }

    @Inject(at={@At(value="HEAD")}, method={"drop"})
    public void drop(int chunkX, int chunkZ, CallbackInfo info) {
        long chunkIndex = ChunkHelper.calcChunkIndex(chunkX, chunkZ);
        this.loadedChunksSodiumFix.remove(chunkIndex);
        if (this.mod != null) {
            this.unloadDynamicBlockChunk(chunkX, chunkZ);
            if (ConfigClient.areSnowPhysicsEnabled()) {
                this.mod.getPhysicsWorld().getSnowWorld().removeChunkColumn(chunkX, chunkZ);
            }
            if (ConfigClient.areOceanPhysicsEnabled()) {
                this.mod.getPhysicsWorld().getOceanWorld().removeChunkColumn(chunkX, chunkZ);
            }
        }
    }

    @Unique
    protected void unloadDynamicBlockChunk(int chunkX, int chunkZ) {
        this.unloadDynamicBlockChunk(chunkX, chunkZ, null, false);
    }

    @Unique
    protected void unloadDynamicBlockChunk(int chunkX, int chunkZ, ObjectSet<Vector3i> affectedChunks, boolean removeOneFrameLater) {
        long chunkIndex = ChunkHelper.calcChunkIndex(chunkX, chunkZ);
        List ragdolls = (List)this.loadedVines.remove(chunkIndex);
        if (affectedChunks != null && ragdolls != null) {
            for (DynamicRagdoll ragdoll : ragdolls) {
                for (class_2338 pos : ragdoll.getBlockPositions()) {
                    affectedChunks.add((Object)new Vector3i(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10264()), class_4076.method_18675((int)pos.method_10260())));
                }
            }
        }
        this.unloadRagdolls(ragdolls, removeOneFrameLater);
    }

    @Unique
    protected void unloadRagdolls(List<DynamicRagdoll> ragdolls, boolean removeOneFrameLater) {
        if (ragdolls != null) {
            for (DynamicRagdoll ragdoll : ragdolls) {
                if (removeOneFrameLater) {
                    this.mod.sodiumRemoveRagdolls.add(ragdoll);
                    continue;
                }
                this.mod.physicsWorld.removeRagdoll(ragdoll);
            }
        }
    }

    @Override
    public void unloadAllRagdolls() {
        for (List ragdolls : this.loadedVines.values()) {
            this.unloadRagdolls(ragdolls, false);
        }
        this.loadedVines.clear();
    }

    @Override
    public void loadAllRagdolls() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        while (it.hasNext()) {
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            class_2818 chunk = ((class_631)this).method_2857(chunkX, chunkZ, null, false);
            if (!VineHelper.isChunkInRange(chunkX, chunkZ)) continue;
            this.loadDynamicBlockChunk(chunk, chunkX, chunkZ);
        }
    }

    @Override
    public void unloadAllSnow() {
        if (this.mod != null) {
            this.mod.getPhysicsWorld().getSnowWorld().removeAll();
            this.mod.getPhysicsWorld().getSnowWorld().destroy();
            IChunk.updateChunkSize();
            this.mod.getPhysicsWorld().setSnowWorld(new SnowWorld((class_1937)this.field_16525));
        }
    }

    @Override
    public void loadAllSnow() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        while (it.hasNext()) {
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            class_2818 chunk = ((class_631)this).method_2857(chunkX, chunkZ, null, false);
            this.loadSnowChunk(chunk, chunkX, chunkZ);
        }
    }

    @Override
    public void unloadAllOcean() {
        if (this.mod != null) {
            this.mod.getPhysicsWorld().getOceanWorld().removeAll();
            this.mod.getPhysicsWorld().getOceanWorld().destroy();
            this.mod.getPhysicsWorld().setOceanWorld(new OceanWorld(this.mod.getPhysicsWorld(), (class_1937)this.field_16525));
        }
    }

    @Override
    public void loadAllOcean() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        while (it.hasNext()) {
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            class_2818 chunk = ((class_631)this).method_2857(chunkX, chunkZ, null, false);
            this.loadOceanChunk(chunk, chunkX, chunkZ);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"replaceWithPacketData"})
    public void replaceWithPacketDataHead(int x, int z, class_2540 buf, class_2487 nbt, Consumer<class_6603.class_6605> consumer, CallbackInfoReturnable<class_2818> info) {
        StorageInvoker storageInvoker = (StorageInvoker)this.field_16246;
        if (!storageInvoker.invokeInRange(x, z)) {
            return;
        }
        int storageIndex = storageInvoker.invokeGetIndex(x, z);
        class_2818 levelChunk = storageInvoker.invokeGetChunk(storageIndex);
        if (levelChunk != null) {
            class_1923 chunkPos = levelChunk.method_12004();
            int chunkX = chunkPos.field_9181;
            int chunkZ = chunkPos.field_9180;
            if (chunkX != x || chunkZ != z) {
                long chunkIndex = ChunkHelper.calcChunkIndex(x, z);
                this.loadedChunksSodiumFix.remove(chunkIndex);
                if (this.mod != null) {
                    this.unloadDynamicBlockChunk(chunkX, chunkZ);
                    if (ConfigClient.areSnowPhysicsEnabled()) {
                        this.mod.getPhysicsWorld().getSnowWorld().removeChunkColumn(chunkX, chunkZ);
                    }
                    if (ConfigClient.areOceanPhysicsEnabled()) {
                        this.mod.getPhysicsWorld().getOceanWorld().removeChunkColumn(chunkX, chunkZ);
                    }
                }
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"replaceWithPacketData"})
    public void replaceWithPacketData(int x, int z, class_2540 buf, class_2487 nbt, Consumer<class_6603.class_6605> consumer, CallbackInfoReturnable<class_2818> info) {
        class_2818 chunk = (class_2818)info.getReturnValue();
        if (chunk == null) {
            return;
        }
        long chunkIndex = ChunkHelper.calcChunkIndex(x, z);
        this.loadedChunksSodiumFix.add(chunkIndex);
        if (this.mod != null) {
            this.loadCombinedPhysicsChunk(chunk, x, z);
        }
    }

    @Unique
    protected void loadCombinedPhysicsChunk(class_2818 chunk, int x, int z) {
        boolean dynamicBlocks;
        boolean snow = ConfigClient.areSnowPhysicsEnabled();
        boolean ocean = ConfigClient.areOceanPhysicsEnabled();
        boolean bl = dynamicBlocks = ConfigClient.areDynamicBlockPhysicsEnabled() && VineHelper.isChunkInRange(x, z);
        if (chunk != null && (snow || ocean || dynamicBlocks)) {
            long chunkIndex = ChunkHelper.calcChunkIndex(x, z);
            class_2826[] sections = chunk.method_12006();
            SnowWorld snowWorld = this.mod.getPhysicsWorld().getSnowWorld();
            OceanWorld oceanWorld = this.mod.getPhysicsWorld().getOceanWorld();
            ObjectArrayList loadSnowChunks = new ObjectArrayList();
            ObjectArrayList loadOceanChunks = new ObjectArrayList();
            Long2ObjectLinkedOpenHashMap vines = new Long2ObjectLinkedOpenHashMap();
            ObjectArrayList consumers = new ObjectArrayList();
            for (int i = 0; i < sections.length; ++i) {
                class_2826 section = sections[i];
                class_2837 class_28372 = section.method_12265().field_34560.comp_119();
                Object2ObjectOpenHashMap snowBlocks = new Object2ObjectOpenHashMap();
                int y = i + chunk.method_12200().method_31607() / 16;
                if (!section.method_38292()) {
                    if (snow && class_28372.method_19525(SnowSearcher::isPhysicsSnow)) {
                        consumers.add(new SnowSearcher(snowWorld, (Map<Vector3i, class_2680>)snowBlocks, x * 16, i * 16 + chunk.method_12200().method_31607(), z * 16, (class_2837<class_2680>)class_28372));
                    }
                    if (ocean) {
                        loadOceanChunks.add(new OceanChunkCreator((class_2841<class_2680>)section.method_12265().method_39957(), x, y, z));
                    }
                    if (dynamicBlocks && class_28372.method_19525(VineSearcher::isPhysicsDynamicBlock)) {
                        consumers.add(new VineSearcher((Long2ObjectMap<class_2680>)vines, (class_2837<class_2680>)class_28372, section.method_12259()));
                    }
                    if (!consumers.isEmpty()) {
                        ((FastBlockSearcher)section.method_12265().field_34560.comp_118()).getAllFast(new MultiSearcherConsumer((class_2837<class_2680>)class_28372, (List<FastBlockSearcherConsumer>)consumers));
                    }
                    consumers.clear();
                } else if (ocean) {
                    loadOceanChunks.add(new OceanChunkCreator(0, x, y, z));
                }
                if (!snow) continue;
                SnowChunkCreator creator = new SnowChunkCreator(snowWorld, (Map<Vector3i, class_2680>)snowBlocks, x, y, z);
                loadSnowChunks.add(creator);
            }
            if (!loadSnowChunks.isEmpty()) {
                snowWorld.addChunkColumn((List<ChunkCreator>)loadSnowChunks, x, z);
            }
            if (!loadOceanChunks.isEmpty()) {
                oceanWorld.addChunkColumn((List<OceanChunkCreator>)loadOceanChunks, x, z);
            }
            if (dynamicBlocks) {
                List<DynamicRagdoll> ragdolls = this.searchConnections(x, z, (Long2ObjectMap<class_2680>)vines);
                this.unloadDynamicBlockChunk(x, z);
                for (Ragdoll ragdoll : ragdolls) {
                    this.mod.physicsWorld.addRagdoll(ragdoll);
                }
                this.loadedVines.put(chunkIndex, ragdolls);
            }
        }
    }

    @Unique
    protected boolean isValidStorageChunk(@Nullable class_2818 levelChunk, int x, int z) {
        if (levelChunk == null) {
            return false;
        }
        class_1923 chunkPos = levelChunk.method_12004();
        return chunkPos.field_9181 == x && chunkPos.field_9180 == z;
    }

    @Unique
    protected void loadSnowChunk(class_2818 chunk, int x, int z) {
        if (ConfigClient.areSnowPhysicsEnabled() && chunk != null) {
            class_2826[] sections = chunk.method_12006();
            SnowWorld snowWorld = this.mod.getPhysicsWorld().getSnowWorld();
            ObjectArrayList loadChunks = new ObjectArrayList();
            for (int i = 0; i < sections.length; ++i) {
                class_2826 section = sections[i];
                Object2ObjectOpenHashMap snow = new Object2ObjectOpenHashMap();
                class_2837 palette = section.method_12265().field_34560.comp_119();
                if (!section.method_38292() && palette.method_19525(SnowSearcher::isPhysicsSnow)) {
                    SnowSearcher consumer = new SnowSearcher(snowWorld, (Map<Vector3i, class_2680>)snow, x * 16, i * 16 + chunk.method_12200().method_31607(), z * 16, (class_2837<class_2680>)palette);
                    ((FastBlockSearcher)section.method_12265().field_34560.comp_118()).getAllFast(consumer);
                }
                int y = i + chunk.method_12200().method_31607() / 16;
                SnowChunkCreator creator = new SnowChunkCreator(snowWorld, (Map<Vector3i, class_2680>)snow, x, y, z);
                loadChunks.add(creator);
            }
            if (!loadChunks.isEmpty()) {
                snowWorld.addChunkColumn((List<ChunkCreator>)loadChunks, x, z);
            }
        }
    }

    @Unique
    protected void loadOceanChunk(class_2818 chunk, int x, int z) {
        if (ConfigClient.areOceanPhysicsEnabled() && chunk != null) {
            class_2826[] sections = chunk.method_12006();
            OceanWorld oceanWorld = this.mod.getPhysicsWorld().getOceanWorld();
            ObjectArrayList loadChunks = new ObjectArrayList();
            for (int i = 0; i < sections.length; ++i) {
                class_2826 section = sections[i];
                int y = i + chunk.method_12200().method_31607() / 16;
                if (!section.method_38292()) {
                    loadChunks.add(new OceanChunkCreator((class_2841<class_2680>)section.method_12265().method_39957(), x, y, z));
                    continue;
                }
                loadChunks.add(new OceanChunkCreator(0, x, y, z));
            }
            if (!loadChunks.isEmpty()) {
                oceanWorld.addChunkColumn((List<OceanChunkCreator>)loadChunks, x, z);
            }
        }
    }

    @Unique
    protected void loadDynamicBlockChunk(class_2818 chunk, int x, int z) {
        this.loadDynamicBlockChunk(chunk, x, z, null);
    }

    @Unique
    protected void loadDynamicBlockChunk(class_2818 chunk, int x, int z, ObjectSet<Vector3i> affectedChunks) {
        long chunkIndex = ChunkHelper.calcChunkIndex(x, z);
        if (ConfigClient.areDynamicBlockPhysicsEnabled() && chunk != null) {
            class_2826[] sections = chunk.method_12006();
            Long2ObjectLinkedOpenHashMap vines = new Long2ObjectLinkedOpenHashMap();
            for (int i = 0; i < sections.length; ++i) {
                class_2826 section = sections[i];
                boolean bl = false;
                class_2837 palette = section.method_12265().field_34560.comp_119();
                if (!section.method_38292() && palette.method_19525(VineSearcher::isPhysicsDynamicBlock)) {
                    VineSearcher consumer = new VineSearcher((Long2ObjectMap<class_2680>)vines, (class_2837<class_2680>)palette, section.method_12259());
                    ((FastBlockSearcher)section.method_12265().field_34560.comp_118()).getAllFast(consumer);
                    bl |= consumer.affected;
                }
                if (!bl || affectedChunks == null) continue;
                affectedChunks.add((Object)new Vector3i(x, i + chunk.method_12200().method_31607() / 16, z));
            }
            List<DynamicRagdoll> ragdolls = this.searchConnections(x, z, (Long2ObjectMap<class_2680>)vines);
            this.unloadDynamicBlockChunk(x, z);
            for (Ragdoll ragdoll : ragdolls) {
                this.mod.physicsWorld.addRagdoll(ragdoll);
            }
            this.loadedVines.put(chunkIndex, ragdolls);
        }
    }

    @Override
    public void addVineRagdoll(DynamicRagdoll ragdoll, class_2338 pos) {
        long chunkIndex = ChunkHelper.calcChunkIndex(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260()));
        List ragdolls = (List)this.loadedVines.get(chunkIndex);
        if (ragdolls == null) {
            ragdolls = new ObjectArrayList();
            this.loadedVines.put(chunkIndex, (Object)ragdolls);
        }
        ragdolls.add(ragdoll);
    }

    @Override
    public void removeVineRagdoll(DynamicRagdoll ragdoll) {
        class_2338 pos;
        long chunkIndex;
        List ragdolls;
        if (ragdoll.getBlockPositions().size() > 0 && (ragdolls = (List)this.loadedVines.get(chunkIndex = ChunkHelper.calcChunkIndex(class_4076.method_18675((int)(pos = ragdoll.getBlockPositions().get(0)).method_10263()), class_4076.method_18675((int)pos.method_10260())))) != null) {
            ragdolls.remove(ragdoll);
        }
    }

    @Unique
    protected List<DynamicRagdoll> searchConnections(int chunkX, int chunkZ, Long2ObjectMap<class_2680> vines) {
        ObjectArrayList ragdolls = new ObjectArrayList();
        while (vines.size() > 0) {
            DynamicRagdoll ragdoll;
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)vines.long2ObjectEntrySet().iterator().next();
            long index = entry.getLongKey();
            class_2680 current = (class_2680)entry.getValue();
            int x = (int)(index >> 60) & 0xF;
            int y = (int)(index & 0xFFFFFFFFFFFFFFL);
            int z = (int)(index >> 56) & 0xF;
            DynamicSetting setting = VineHelper.getSetting(current);
            if (setting == null || (ragdoll = setting.createRagdoll(this.mod, current, new class_2338(x + chunkX * 16, y, z + chunkZ * 16), vines)) == null) continue;
            ragdolls.add(ragdoll);
        }
        return ragdolls;
    }

    @Override
    public void setPhysicsMod(PhysicsMod physicsMod) {
        if (this.mod != null) {
            if (this.mod != physicsMod) {
                VAO.storePreviouslyBoundState();
                this.unloadAllRagdolls();
                this.unloadAllSnow();
                this.unloadAllOcean();
                this.mod = physicsMod;
                if (physicsMod != null) {
                    this.loadAllRagdolls();
                    this.loadAllSnow();
                    this.loadAllOcean();
                }
                VAO.restorePreviouslyBoundState();
            }
        } else {
            this.mod = physicsMod;
            if (physicsMod != null) {
                VAO.storePreviouslyBoundState();
                this.loadAllRagdolls();
                this.loadAllSnow();
                this.loadAllOcean();
                VAO.restorePreviouslyBoundState();
            }
        }
    }

    @Override
    public class_631.class_3681 getStorage() {
        return this.field_16246;
    }
}

