/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import net.coderbot.iris.shaderpack.preprocessor.JcppProcessor;
import net.diebuddies.compat.Iris;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={JcppProcessor.class})
public class MixinJcppProcessor {
    @ModifyVariable(at=@At(value="HEAD"), method={"glslPreprocessSource"}, remap=false, ordinal=0)
    private static String glslPreprocessSource(String source) {
        if (Iris.preprocessStage != null && source != null) {
            if (source.contains("#define PHYSICS_OCEAN_SUPPORT")) {
                source = StringUtils.replace((String)source, (String)"#define PHYSICS_OCEAN_SUPPORT", (String)"#define PHYSICS_OCEAN");
                switch (Iris.preprocessStage) {
                    case VERTEX: {
                        Iris.vertexShaderSupportsOcean = true;
                        break;
                    }
                    case GEOMETRY: {
                        Iris.geometryShaderSupportsOcean = true;
                        break;
                    }
                    case FRAGMENT: {
                        Iris.fragmentShaderSupportsOcean = true;
                        break;
                    }
                }
            } else {
                if (source.contains("#define PHYSICS_OCEAN_INJECTION")) {
                    source = StringUtils.replace((String)source, (String)"#define PHYSICS_OCEAN_INJECTION", (String)"#define PHYSICS_OCEAN");
                }
                switch (Iris.preprocessStage) {
                    case VERTEX: {
                        Iris.vertexShaderSupportsOcean = false;
                        break;
                    }
                    case GEOMETRY: {
                        Iris.geometryShaderSupportsOcean = false;
                        break;
                    }
                    case FRAGMENT: {
                        Iris.fragmentShaderSupportsOcean = false;
                        break;
                    }
                }
            }
        } else {
            Iris.vertexShaderSupportsOcean = false;
            Iris.geometryShaderSupportsOcean = false;
            Iris.fragmentShaderSupportsOcean = false;
        }
        return source;
    }
}

