/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigCloth;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.Cloth;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.diebuddies.physics.verlet.constraints.OceanPhysicsDisplacementConstraint;
import net.diebuddies.physics.verlet.constraints.WorldConstraint;
import net.diebuddies.util.PlayerLevelPacked;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_922;
import net.minecraft.class_972;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_972.class})
public class MixinCapeFeatureRenderer {
    @Unique
    private Map<PlayerLevelPacked, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    @Unique
    private Matrix4f localT = new Matrix4f();
    @Unique
    private class_742 player;
    @Unique
    private boolean renderedCape;
    @Unique
    private class_4597 multiBufferSource;
    @Unique
    private PlayerLevelPacked tmp = new PlayerLevelPacked(null, null);

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void physicsmod$renderHead(class_4587 matrixStack, class_4597 multiBufferSource, int light, class_742 player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
        this.player = player;
        this.renderedCape = false;
        this.multiBufferSource = multiBufferSource;
    }

    @Inject(at={@At(value="RETURN")}, method={"render"})
    private void physicsmod$renderTail(class_4587 matrixStack, class_4597 multiBufferSource, int light, class_742 player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
        this.physicsmod$removeOldSimulations();
        boolean renderCloth = true;
        if (!renderCloth || !this.physicsmod$shouldRenderPhysicsCape(player) || this.renderedCape || !this.physicsmod$hasPhysicsCape(player)) {
            // empty if block
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/PlayerModel;renderCloak(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V"))
    private void physicsmod$renderCloak(class_591 playerModel, class_4587 poseStack, class_4588 vertexConsumer, int light, int overlay) {
        this.physicsmod$removeOldSimulations();
        boolean renderCloth = true;
        if (renderCloth && this.physicsmod$shouldRenderPhysicsCape(this.player)) {
            if (!this.physicsmod$hasPhysicsCape(this.player)) {
                this.physicsmod$renderPhysicsCape(this.player, light);
            }
        } else {
            ((class_591)((class_972)this).method_17165()).method_2823(poseStack, vertexConsumer, light, class_4608.field_21444);
        }
        this.renderedCape = true;
    }

    @Unique
    private boolean physicsmod$shouldRenderPhysicsCape(class_742 player) {
        return !PhysicsMod.hudRendering && ConfigClient.capePhysics && player != null && player.method_3125() && !player.method_5767() && this.physicsmod$hasMojangCape(player);
    }

    @Unique
    private boolean physicsmod$hasMojangCape(class_742 player) {
        return player.method_3119() != null;
    }

    @Unique
    private boolean physicsmod$hasPhysicsCape(class_742 player) {
        return ConfigCloth.hasCategory((class_1297)player, "Back");
    }

    @Unique
    private void physicsmod$removeOldSimulations() {
        Iterator<Map.Entry<PlayerLevelPacked, VerletSimulation>> it = this.simulations.entrySet().iterator();
        while (it.hasNext()) {
            if (!it.next().getValue().destroyed) continue;
            it.remove();
        }
    }

    @Unique
    private void physicsmod$renderPhysicsCape(class_742 player, int light) {
        class_1799 itemStack = player.method_6118(class_1304.field_6174);
        class_1937 level = player.method_5770();
        if (!(level instanceof class_638)) {
            return;
        }
        this.tmp.e1 = player.method_7334().getName();
        this.tmp.e2 = level;
        VerletSimulation simulation = this.simulations.get(this.tmp);
        if (!itemStack.method_31574(class_1802.field_8833)) {
            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            boolean renderFast = false;
            if (camera.method_19328().method_10262((class_2382)player.method_24515()) > (double)(ConfigClient.clothEntityRange * ConfigClient.clothEntityRange)) {
                renderFast = true;
            }
            Cloth cloth = PhysicsMod.defaultCape;
            class_922 renderer = (class_922)class_310.method_1551().method_1561().method_3953((class_1297)player);
            class_583 model = renderer.method_4038();
            if (renderFast || !cloth.rules.isDynamic()) {
                class_630 modelPart = ModelPartConstraint.getPart((class_3879)model, "body");
                int textureID = class_310.method_1551().method_1531().method_4619(player.method_3119()).method_4624();
                if (cloth != null && modelPart != null) {
                    PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, textureID, (class_1309)player, modelPart, light));
                }
            } else {
                if (simulation == null) {
                    boolean alwaysInstantlyUpdate;
                    class_583 entityModel;
                    if (model instanceof class_583 && !ModelPartConstraint.exists((class_583<class_1309>)(entityModel = model), "body")) {
                        return;
                    }
                    int quality = player == class_310.method_1551().field_1724 ? 90 : 45;
                    simulation = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(level.method_27983().method_29177())), quality, 0.855);
                    ModelPartConstraint modelPartConstraint = new ModelPartConstraint(simulation, cloth.rules.getIgnoreParts(), (class_1309)player, "body", (class_3879)model);
                    class_4587 modelMatrix = new class_4587();
                    ModelPartConstraint.entityTransformation(modelMatrix, simulation, (class_1309)player, (class_3879)model, 1.0f);
                    modelPartConstraint.modelPartTransformation(modelMatrix);
                    Matrix4d partTransformation = new Matrix4d();
                    partTransformation.set((Matrix4fc)modelMatrix.method_23760().method_23761());
                    simulation.getConstraints().clear();
                    simulation.addConstraint(new OceanPhysicsDisplacementConstraint((class_1297)player));
                    simulation.addConstraint(modelPartConstraint);
                    simulation.addConstraint(new WorldConstraint((class_1297)player));
                    simulation.brightness = light;
                    int textureID = class_310.method_1551().method_1531().method_4619(player.method_3119()).method_4624();
                    simulation.addCloth(PhysicsMod.defaultCape, textureID, partTransformation, false);
                    simulation.setOffset(new Vector3d(player.method_23317(), player.method_23318(), player.method_23321()).add((Vector3dc)simulation.getOffset()), false);
                    simulation.setTransformation(partTransformation);
                    simulation.setBufferTransformation(partTransformation);
                    simulation.updateOffsets();
                    PhysicsWorld physicsWorld = PhysicsMod.getInstance((class_1937)level).physicsWorld;
                    modelPartConstraint.initAsyncData(physicsWorld, simulation);
                    modelPartConstraint.changeInstantly = true;
                    modelPartConstraint.updateAfter(0.0, simulation);
                    simulation.downloadData();
                    simulation.alwaysFetchInstantly = alwaysInstantlyUpdate = player == class_310.method_1551().field_1724;
                    this.simulations.put(new PlayerLevelPacked(player.method_7334().getName(), player.method_5770()), simulation);
                    if (alwaysInstantlyUpdate) {
                        physicsWorld.addVerletSimulation(0, simulation);
                    } else {
                        physicsWorld.addVerletSimulation(simulation);
                    }
                } else if (!simulation.destroyed) {
                    simulation.active = true;
                    simulation.brightness = light;
                }
                if (cloth != simulation.cloth) {
                    simulation.destroyed = true;
                }
                if (StarterClient.optifabric) {
                    PhysicsMod.optifineClothCompat.add(simulation);
                } else {
                    simulation.renderSlow(player.method_5770());
                }
            }
        }
    }
}

