/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer_physics.cst.node;

import io.github.douira.glsl_transformer_physics.cst.node.StringNode;

public class Directive
extends StringNode {
    private final DirectiveType type;

    public Directive(DirectiveType type, String content) {
        super(Directive.cleanContent(content));
        if (type == null) {
            throw new IllegalArgumentException("Non-null type must be used to construct a directive!");
        }
        if (type == DirectiveType.EMPTY) {
            throw new IllegalArgumentException("The EMPTY type may only be used with the corresponding constructor!");
        }
        this.type = type;
    }

    public Directive() {
        super("");
        this.type = DirectiveType.EMPTY;
    }

    private static String cleanContent(String content) {
        return content == null ? null : content.trim().replace("\n", "\\\n");
    }

    @Override
    protected String getPrinted() {
        if (this.type == DirectiveType.EMPTY) {
            return "#\n";
        }
        return ("#" + this.type.name().toLowerCase() + " " + this.getContent()).trim() + "\n";
    }

    public static enum DirectiveType {
        DEFINE,
        INCLUDE,
        UNDEF,
        IF,
        IFDEF,
        IFNDEF,
        ELSE,
        ELIF,
        ENDIF,
        ERROR,
        LINE,
        EMPTY;

    }
}

