/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer_physics.ast.transform;

import io.github.douira.glsl_transformer_physics.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer_physics.ast.transform.EnumASTTransformer;
import io.github.douira.glsl_transformer_physics.ast.transform.TriFullTransformation;
import io.github.douira.glsl_transformer_physics.ast.transform.TriRootOnlyTransformation;
import io.github.douira.glsl_transformer_physics.job_parameter.JobParameters;
import io.github.douira.glsl_transformer_physics.util.TriConsumer;
import io.github.douira.glsl_transformer_physics.util.Triple;
import java.util.EnumMap;
import java.util.function.Consumer;
import physics.org.antlr.v4.runtime.RecognitionException;

public class TriASTTransformer<T extends JobParameters, E extends Enum<E>>
extends EnumASTTransformer<T, E> {
    private final E aType;
    private final E bType;
    private final E cType;
    private final Class<E> enumClass;

    public TriASTTransformer(Consumer<EnumMap<E, TranslationUnit>> transformation, Class<E> enumClass, E aType, E bType, E cType) {
        super(transformation, enumClass);
        this.aType = aType;
        this.bType = bType;
        this.cType = cType;
        this.enumClass = enumClass;
    }

    public TriASTTransformer(Class<E> enumClass, E aType, E bType, E cType) {
        super(enumClass);
        this.aType = aType;
        this.bType = bType;
        this.cType = cType;
        this.enumClass = enumClass;
    }

    public TriASTTransformer(TriConsumer<TranslationUnit, TranslationUnit, TranslationUnit> transformation, Class<E> enumClass, E aType, E bType, E cType) {
        this(enumClass, aType, bType, cType);
        this.setTransformation(transformation);
    }

    public TriASTTransformer(TriRootOnlyTransformation<TranslationUnit> transformation, Class<E> enumClass, E aType, E bType, E cType) {
        this(enumClass, aType, bType, cType);
        this.setTransformation(transformation);
    }

    public TriASTTransformer(TriFullTransformation<TranslationUnit, T> transformation, Class<E> enumClass, E aType, E bType, E cType) {
        this(enumClass, aType, bType, cType);
        this.setTransformation(transformation);
    }

    public void setTransformation(TriConsumer<TranslationUnit, TranslationUnit, TranslationUnit> transformation) {
        super.setTransformation((N map) -> transformation.accept((TranslationUnit)map.get(this.aType), (TranslationUnit)map.get(this.bType), (TranslationUnit)map.get(this.cType)));
    }

    @Override
    public void setTransformation(TriRootOnlyTransformation<TranslationUnit> transformation) {
        super.setTransformation((N map) -> {
            TranslationUnit a = (TranslationUnit)map.get(this.aType);
            TranslationUnit b = (TranslationUnit)map.get(this.bType);
            TranslationUnit c = (TranslationUnit)map.get(this.cType);
            transformation.accept(a, b, c, a == null ? null : a.getRoot(), b == null ? null : b.getRoot(), c == null ? null : c.getRoot());
        });
    }

    @Override
    public void setTransformation(TriFullTransformation<TranslationUnit, T> transformation) {
        super.setTransformation((N map) -> {
            TranslationUnit a = (TranslationUnit)map.get(this.aType);
            TranslationUnit b = (TranslationUnit)map.get(this.bType);
            TranslationUnit c = (TranslationUnit)map.get(this.cType);
            transformation.accept(a, b, c, a == null ? null : a.getRoot(), b == null ? null : b.getRoot(), c == null ? null : c.getRoot(), this.getJobParameters());
        });
    }

    @Override
    public void setEnumType(Class<E> enumClass) {
        throw new UnsupportedOperationException("The tri enum map types may not be changed.");
    }

    public EnumMap<E, String> transform(String a, String b, String c) throws RecognitionException {
        EnumMap<E, String> items = new EnumMap<E, String>(this.enumClass);
        items.put(this.aType, a);
        items.put(this.bType, b);
        items.put(this.cType, c);
        return (EnumMap)this.transform(items);
    }

    public EnumMap<E, String> transform(String a, String b, String c, T parameters) throws RecognitionException {
        return this.withJobParameters(parameters, () -> this.transform(a, b, c));
    }

    @Override
    public Triple<String> transform(Triple<String> str) throws RecognitionException {
        EnumMap<E, String> result = this.transform((String)str.a, (String)str.b, (String)str.c);
        return new Triple<String>(result.get(this.aType), result.get(this.bType), result.get(this.cType));
    }

    @Override
    public Triple<String> transform(Triple<String> str, T parameters) throws RecognitionException {
        return this.withJobParameters(parameters, () -> this.transform(str));
    }
}

