/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer_physics.ast.query.index;

import io.github.douira.glsl_transformer_physics.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer_physics.ast.node.basic.InnerASTNode;
import io.github.douira.glsl_transformer_physics.ast.node.basic.ListASTNode;
import io.github.douira.glsl_transformer_physics.ast.query.index.NodeIndex;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class SuperclassNodeIndex
extends NodeIndex {
    public SuperclassNodeIndex(Supplier<Set<ASTNode>> bucketConstructor) {
        super(bucketConstructor);
    }

    public SuperclassNodeIndex() {
    }

    public static SuperclassNodeIndex withHashSetBuckets() {
        return new SuperclassNodeIndex(HashSet::new);
    }

    public static SuperclassNodeIndex withLinkedHashSetBuckets() {
        return new SuperclassNodeIndex(LinkedHashSet::new);
    }

    protected void iterateClasses(ASTNode node, BiConsumer<Class<? extends ASTNode>, ASTNode> consumer) {
        for (Class<?> nodeClass = node.getClass(); nodeClass != null && nodeClass != InnerASTNode.class && nodeClass != ASTNode.class && nodeClass != ListASTNode.class; nodeClass = nodeClass.getSuperclass()) {
            consumer.accept(nodeClass, node);
        }
    }

    @Override
    public void add(ASTNode node) {
        this.iterateClasses(node, (nodeClass, toAdd) -> {
            Set set = (Set)this.index.get(nodeClass);
            if (set == null) {
                set = (Set)this.bucketConstructor.get();
                this.index.put(nodeClass, set);
            }
            set.add(toAdd);
        });
    }

    @Override
    public void remove(ASTNode node) {
        this.iterateClasses(node, (nodeClass, toAdd) -> {
            Set set = (Set)this.index.get(nodeClass);
            if (set == null) {
                return;
            }
            set.remove(toAdd);
        });
    }
}

