/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer_physics.ast.query.index;

import io.github.douira.glsl_transformer_physics.ast.node.Identifier;
import io.github.douira.glsl_transformer_physics.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer_physics.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer_physics.ast.query.index.Index;
import io.github.douira.glsl_transformer_physics.ast.query.index.PermutermTrie;
import io.github.douira.glsl_transformer_physics.ast.query.index.PrefixQueryable;
import io.github.douira.glsl_transformer_physics.ast.query.index.PrefixSuffixTrie;
import io.github.douira.glsl_transformer_physics.ast.query.index.PrefixTrie;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Stream;
import physics.org.apache.commons.collections4.trie.PatriciaTrie;

public class IdentifierIndex<I extends PatriciaTrie<Set<Identifier>>>
implements Index<Identifier>,
PrefixQueryable<Identifier> {
    public final I index;

    public IdentifierIndex(I index) {
        this.index = index;
    }

    @Override
    public void add(Identifier node) {
        String name = node.getName();
        HashSet<Identifier> set = (HashSet<Identifier>)((PatriciaTrie)this.index).get(name);
        if (set == null) {
            set = new HashSet<Identifier>();
            ((PatriciaTrie)this.index).put(name, set);
        }
        set.add(node);
    }

    @Override
    public void remove(Identifier node) {
        String name = node.getName();
        Set set = (Set)((PatriciaTrie)this.index).get(name);
        if (set == null) {
            return;
        }
        set.remove(node);
        if (set.isEmpty()) {
            ((PatriciaTrie)this.index).remove(name);
        }
    }

    public Set<Identifier> get(String key) {
        Set result = (Set)((PatriciaTrie)this.index).get(key);
        return result == null ? Collections.emptySet() : result;
    }

    public Stream<Identifier> getStream(String key) {
        Set result = (Set)((PatriciaTrie)this.index).get(key);
        return result == null ? Stream.empty() : result.stream();
    }

    public <T extends ASTNode> Stream<T> getAncestors(String key, Class<T> ancestorType) {
        return this.getStream(key).map(id -> id.getAncestor(ancestorType)).filter(Objects::nonNull);
    }

    public Stream<ReferenceExpression> getReferenceExpressions(String key) {
        return this.getStream(key).map(id -> id.getAncestor(ReferenceExpression.class)).filter(Objects::nonNull);
    }

    public ReferenceExpression getOneReferenceExpression(String key) {
        return this.getReferenceExpressions(key).findFirst().orElse(null);
    }

    public Identifier getOne(String key) {
        Iterator iterator = ((Set)((PatriciaTrie)this.index).get(key)).iterator();
        return iterator.hasNext() ? (Identifier)iterator.next() : null;
    }

    public boolean has(String key) {
        Set result = (Set)((PatriciaTrie)this.index).get(key);
        return result != null && !result.isEmpty();
    }

    public boolean rename(String oldName, String newName) {
        if (oldName.equals(newName)) {
            return false;
        }
        Identifier.validateContents(newName);
        Set set = (Set)((PatriciaTrie)this.index).get(oldName);
        if (set == null) {
            return false;
        }
        ((PatriciaTrie)this.index).remove(oldName);
        Set existing = (Set)((PatriciaTrie)this.index).get(newName);
        if (existing == null) {
            ((PatriciaTrie)this.index).put(newName, set);
        } else {
            existing.addAll(set);
        }
        for (Identifier id : set) {
            id.setNameInternal(newName);
        }
        return true;
    }

    public SortedMap<String, Set<Identifier>> prefixMap(String key) {
        return ((PatriciaTrie)this.index).prefixMap(key);
    }

    @Override
    public Stream<Set<Identifier>> prefixQuery(String key) {
        return ((PatriciaTrie)this.index).prefixMap(key).values().stream();
    }

    @Override
    public Stream<Identifier> prefixQueryFlat(String key) {
        return this.prefixQuery(key).flatMap(Collection::stream);
    }

    public static IdentifierIndex<PrefixTrie<Identifier>> withPrefix() {
        return new IdentifierIndex<PrefixTrie<Identifier>>(new PrefixTrie());
    }

    public static IdentifierIndex<PrefixSuffixTrie<Identifier>> withPrefixSuffix() {
        return new IdentifierIndex<PrefixSuffixTrie<Identifier>>(new PrefixSuffixTrie());
    }

    public static IdentifierIndex<PermutermTrie<Identifier>> withPermuterm() {
        return new IdentifierIndex<PermutermTrie<Identifier>>(new PermutermTrie());
    }
}

