/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer_physics.ast.print;

import io.github.douira.glsl_transformer_physics.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer_physics.ast.print.DelegateTokenProcessor;
import io.github.douira.glsl_transformer_physics.ast.print.SimplePrinter;
import io.github.douira.glsl_transformer_physics.ast.print.TokenProcessor;
import io.github.douira.glsl_transformer_physics.ast.print.token.PrintToken;
import java.util.HashMap;
import java.util.Map;
import physics.org.antlr.v4.runtime.misc.Interval;

public class LineAnnotator
extends DelegateTokenProcessor {
    private int sourceLine = 1;
    private int annotatedLine = 1;
    private int outputLine = 1;
    private static int SOURCE_TYPE = 1;
    private static int SYNTHETIC_TYPE = 0;
    private int currentSourceState = -1;
    private Map<ASTNode, Integer> currentLines = new HashMap<ASTNode, Integer>();

    public LineAnnotator(TokenProcessor delegate) {
        super(delegate);
    }

    public LineAnnotator() {
        super(new SimplePrinter());
    }

    @Override
    public void appendToken(PrintToken token) {
        Interval nodeSourceLines = token.getSource().getSourceLines();
        boolean isSource = this.isSourceInterval(nodeSourceLines);
        if (this.outputLine == 1) {
            this.annotateLine((isSource ? nodeSourceLines.a : this.outputLine) - 1, isSource);
        }
        super.appendToken(token);
        if (token.endsWithNewline()) {
            ++this.outputLine;
            ++this.sourceLine;
        }
    }

    private void annotateLine(int line, boolean fromSource) {
        int sourceType;
        int n = sourceType = fromSource ? SOURCE_TYPE : SYNTHETIC_TYPE;
        if (line != this.outputLine || sourceType != this.currentSourceState) {
            this.appendDirectly("#line " + line + (sourceType != this.currentSourceState ? " " + sourceType : "") + "\n");
            ++this.outputLine;
        }
    }

    private boolean isSourceInterval(Interval sourceLines) {
        return sourceLines != ASTNode.SYNTHETIC_SOURCE;
    }
}

