/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.mixin.ui.ScreenInvoker;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import io.wispforest.owo.ui.util.OwoNinePatchRenderers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_8001;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class Drawer
extends class_332 {
    private static boolean recording = false;
    private static final Drawer INSTANCE = new Drawer();
    private final DebugDrawer debug = new DebugDrawer();
    public static final class_2960 PANEL_TEXTURE = new class_2960("owo", "textures/gui/panel.png");
    public static final class_2960 DARK_PANEL_TEXTURE = new class_2960("owo", "textures/gui/dark_panel.png");

    private Drawer() {
    }

    public static void drawRectOutline(class_4587 matrices, int x, int y, int width, int height, int color) {
        Drawer.method_25294((class_4587)matrices, (int)x, (int)y, (int)(x + width), (int)(y + 1), (int)color);
        Drawer.method_25294((class_4587)matrices, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)color);
        Drawer.method_25294((class_4587)matrices, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)color);
        Drawer.method_25294((class_4587)matrices, (int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)color);
    }

    public static void drawGradientRect(class_4587 matrices, int x, int y, int width, int height, int topLeftColor, int topRightColor, int bottomRightColor, int bottomLeftColor) {
        class_287 buffer = class_289.method_1348().method_1349();
        Matrix4f matrix = matrices.method_23760().method_23761();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(matrix, (float)(x + width), (float)y, 0.0f).method_39415(topRightColor).method_1344();
        buffer.method_22918(matrix, (float)x, (float)y, 0.0f).method_39415(topLeftColor).method_1344();
        buffer.method_22918(matrix, (float)x, (float)(y + height), 0.0f).method_39415(bottomLeftColor).method_1344();
        buffer.method_22918(matrix, (float)(x + width), (float)(y + height), 0.0f).method_39415(bottomRightColor).method_1344();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289.method_1348().method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    public static void drawPanel(class_4587 matrices, int x, int y, int width, int height, boolean dark) {
        (dark ? OwoNinePatchRenderers.DARK_PANEL : OwoNinePatchRenderers.LIGHT_PANEL).draw(matrices, x, y, width, height);
    }

    public static void drawText(class_4587 matrices, class_2561 text, float x, float y, float scale, int color) {
        Drawer.drawText(matrices, text, x, y, scale, color, TextAnchor.TOP_LEFT);
    }

    public static void drawText(class_4587 matrices, class_2561 text, float x, float y, float scale, int color, TextAnchor anchorPoint) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        matrices.method_22903();
        matrices.method_22905(scale, scale, 1.0f);
        switch (anchorPoint) {
            case TOP_RIGHT: {
                x -= (float)textRenderer.method_27525((class_5348)text) * scale;
                break;
            }
            case BOTTOM_LEFT: {
                Objects.requireNonNull(textRenderer);
                y -= 9.0f * scale;
                break;
            }
            case BOTTOM_RIGHT: {
                x -= (float)textRenderer.method_27525((class_5348)text) * scale;
                Objects.requireNonNull(textRenderer);
                y -= 9.0f * scale;
            }
        }
        textRenderer.method_30883(matrices, text, x * (1.0f / scale), y * (1.0f / scale), color);
        matrices.method_22909();
    }

    public static void drawTooltip(class_4587 matrices, int x, int y, List<class_5684> tooltip) {
        ((ScreenInvoker)((Object)Drawer.utilityScreen())).owo$renderTooltipFromComponents(matrices, tooltip, x, y, class_8001.field_41687);
    }

    public static UtilityScreen utilityScreen() {
        return UtilityScreen.get();
    }

    public static DebugDrawer debug() {
        return Drawer.INSTANCE.debug;
    }

    public static void recordQuads() {
        recording = true;
    }

    public static boolean recording() {
        return recording;
    }

    public static void submitQuads() {
        recording = false;
        class_289.method_1348().method_1350();
    }

    public static class DebugDrawer {
        private DebugDrawer() {
        }

        public void drawInsets(class_4587 matrices, int x, int y, int width, int height, Insets insets, int color) {
            class_332.method_25294((class_4587)matrices, (int)(x - insets.left()), (int)(y - insets.top()), (int)(x + width + insets.right()), (int)y, (int)color);
            class_332.method_25294((class_4587)matrices, (int)(x - insets.left()), (int)(y + height), (int)(x + width + insets.right()), (int)(y + height + insets.bottom()), (int)color);
            class_332.method_25294((class_4587)matrices, (int)(x - insets.left()), (int)y, (int)x, (int)(y + height), (int)color);
            class_332.method_25294((class_4587)matrices, (int)(x + width), (int)y, (int)(x + width + insets.right()), (int)(y + height), (int)color);
        }

        public void drawInspector(class_4587 matrices, ParentComponent root, double mouseX, double mouseY, boolean onlyHovered) {
            RenderSystem.disableDepthTest();
            class_310 client = class_310.method_1551();
            class_327 textRenderer = client.field_1772;
            ArrayList<Component> children = new ArrayList<Component>();
            if (!onlyHovered) {
                root.collectChildren(children);
            } else if (root.childAt((int)mouseX, (int)mouseY) != null) {
                children.add(root.childAt((int)mouseX, (int)mouseY));
            }
            for (Component child : children) {
                if (child instanceof ParentComponent) {
                    ParentComponent parentComponent = (ParentComponent)child;
                    this.drawInsets(matrices, parentComponent.x(), parentComponent.y(), parentComponent.width(), parentComponent.height(), ((Insets)parentComponent.padding().get()).inverted(), -1492325155);
                }
                Insets margins = (Insets)child.margins().get();
                this.drawInsets(matrices, child.x(), child.y(), child.width(), child.height(), margins, -1476398280);
                Drawer.drawRectOutline(matrices, child.x(), child.y(), child.width(), child.height(), -12930817);
                if (!onlyHovered) continue;
                int inspectorX = child.x() + 1;
                int inspectorY = child.y() + child.height() + ((Insets)child.margins().get()).bottom() + 1;
                Objects.requireNonNull(textRenderer);
                int inspectorHeight = 9 * 2 + 4;
                if (inspectorY > client.method_22683().method_4502() - inspectorHeight) {
                    if ((inspectorY -= child.fullSize().height() + inspectorHeight + 1) < 0) {
                        inspectorY = 1;
                    }
                    if (child instanceof ParentComponent) {
                        ParentComponent parentComponent = (ParentComponent)child;
                        inspectorX += ((Insets)parentComponent.padding().get()).left();
                        inspectorY += ((Insets)parentComponent.padding().get()).top();
                    }
                }
                class_2561 nameText = class_2561.method_30163((String)(child.getClass().getSimpleName() + (String)(child.id() != null ? " '" + child.id() + "'" : "")));
                class_5250 descriptor = class_2561.method_43470((String)(child.x() + "," + child.y() + " (" + child.width() + "," + child.height() + ") <" + margins.top() + "," + margins.bottom() + "," + margins.left() + "," + margins.right() + "> "));
                if (child instanceof ParentComponent) {
                    ParentComponent parentComponent = (ParentComponent)child;
                    Insets padding = (Insets)parentComponent.padding().get();
                    descriptor.method_27693(" >" + padding.top() + "," + padding.bottom() + "," + padding.left() + "," + padding.right() + "<");
                }
                int width = Math.max(textRenderer.method_27525((class_5348)nameText), textRenderer.method_27525((class_5348)descriptor));
                class_332.method_25294((class_4587)matrices, (int)inspectorX, (int)inspectorY, (int)(inspectorX + width + 3), (int)(inspectorY + inspectorHeight), (int)-1493172224);
                Drawer.drawRectOutline(matrices, inspectorX, inspectorY, width + 3, inspectorHeight, -1493172224);
                textRenderer.method_30883(matrices, nameText, (float)(inspectorX + 2), (float)(inspectorY + 2), 0xFFFFFF);
                float f = inspectorX + 2;
                Objects.requireNonNull(textRenderer);
                textRenderer.method_30883(matrices, (class_2561)descriptor, f, (float)(inspectorY + 9 + 2), 0xFFFFFF);
            }
            RenderSystem.enableDepthTest();
        }
    }

    public static enum TextAnchor {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;

    }

    public static class UtilityScreen
    extends class_437 {
        private static UtilityScreen INSTANCE;

        private UtilityScreen() {
            super((class_2561)class_2561.method_43473());
        }

        public void method_25418(class_4587 matrices, @Nullable class_2583 style, int x, int y) {
            super.method_25418(matrices, style, x, y);
        }

        public static UtilityScreen get() {
            if (INSTANCE == null) {
                INSTANCE = new UtilityScreen();
                class_310 client = class_310.method_1551();
                INSTANCE.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
            }
            return INSTANCE;
        }

        static {
            WindowResizeCallback.EVENT.register((client, window) -> {
                if (INSTANCE == null) {
                    return;
                }
                INSTANCE.method_25423(client, window.method_4486(), window.method_4502());
            });
        }
    }
}

