/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.Owo;
import io.wispforest.owo.renderdoc.RenderDoc;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.CursorAdapter;
import io.wispforest.owo.ui.util.Drawer;
import java.util.function.BiFunction;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class OwoUIAdapter<R extends ParentComponent>
implements class_364,
class_4068,
class_6379 {
    private static boolean isRendering = false;
    public final R rootComponent;
    public final CursorAdapter cursorAdapter;
    protected boolean disposed = false;
    protected boolean captureFrame = false;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    public boolean enableInspector = false;
    public boolean globalInspector = false;
    public int inspectorZOffset = 1000;

    protected OwoUIAdapter(int x, int y, int width, int height, R rootComponent) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.cursorAdapter = CursorAdapter.ofClientWindow();
        this.rootComponent = rootComponent;
    }

    public static <R extends ParentComponent> OwoUIAdapter<R> create(class_437 screen, BiFunction<Sizing, Sizing, R> rootComponentMaker) {
        ParentComponent rootComponent = (ParentComponent)rootComponentMaker.apply(Sizing.fill(100), Sizing.fill(100));
        OwoUIAdapter<ParentComponent> adapter = new OwoUIAdapter<ParentComponent>(0, 0, screen.field_22789, screen.field_22790, rootComponent);
        screen.method_37063(adapter);
        screen.method_20086(adapter);
        return adapter;
    }

    public static <R extends ParentComponent> OwoUIAdapter<R> createWithoutScreen(int x, int y, int width, int height, BiFunction<Sizing, Sizing, R> rootComponentMaker) {
        ParentComponent rootComponent = (ParentComponent)rootComponentMaker.apply(Sizing.fill(100), Sizing.fill(100));
        return new OwoUIAdapter<ParentComponent>(x, y, width, height, rootComponent);
    }

    public void inflateAndMount() {
        this.rootComponent.inflate(Size.of(this.width, this.height));
        this.rootComponent.mount(null, this.x, this.y);
    }

    public void moveAndResize(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.inflateAndMount();
    }

    public void dispose() {
        this.cursorAdapter.dispose();
    }

    public boolean toggleInspector() {
        this.enableInspector = !this.enableInspector;
        return this.enableInspector;
    }

    public boolean toggleGlobalInspector() {
        this.globalInspector = !this.globalInspector;
        return this.globalInspector;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        try {
            isRendering = true;
            if (this.captureFrame) {
                RenderDoc.startFrameCapture();
            }
            float delta = class_310.method_1551().method_1534();
            class_1041 window = class_310.method_1551().method_22683();
            this.rootComponent.update(delta, mouseX, mouseY);
            RenderSystem.enableDepthTest();
            GlStateManager._enableScissorTest();
            GlStateManager._scissorBox((int)0, (int)0, (int)window.method_4489(), (int)window.method_4506());
            this.rootComponent.draw(matrices, mouseX, mouseY, partialTicks, delta);
            GlStateManager._disableScissorTest();
            RenderSystem.disableDepthTest();
            this.rootComponent.drawTooltip(matrices, mouseX, mouseY, partialTicks, delta);
            Component hovered = this.rootComponent.childAt(mouseX, mouseY);
            if (!this.disposed && hovered != null) {
                this.cursorAdapter.applyStyle(hovered.cursorStyle());
            }
            if (this.enableInspector) {
                matrices.method_46416(0.0f, 0.0f, (float)this.inspectorZOffset);
                Drawer.debug().drawInspector(matrices, (ParentComponent)this.rootComponent, mouseX, mouseY, !this.globalInspector);
                matrices.method_46416(0.0f, 0.0f, (float)(-this.inspectorZOffset));
            }
            if (this.captureFrame) {
                RenderDoc.endFrameCapture();
            }
        }
        finally {
            isRendering = false;
            this.captureFrame = false;
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.rootComponent.isInBoundingBox(mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.rootComponent.onMouseDown(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.rootComponent.onMouseUp(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return this.rootComponent.onMouseScroll(mouseX, mouseY, amount);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.rootComponent.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (Owo.DEBUG && keyCode == 340) {
            if ((modifiers & 2) != 0) {
                this.toggleInspector();
            } else if ((modifiers & 4) != 0) {
                this.toggleGlobalInspector();
            }
        }
        if (Owo.DEBUG && keyCode == 82 && RenderDoc.isAvailable() && (modifiers & 4) != 0 && (modifiers & 2) != 0) {
            this.captureFrame = true;
        }
        return this.rootComponent.onKeyPress(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        return this.rootComponent.onCharTyped(chr, modifiers);
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }

    public static boolean isRendering() {
        return isRendering;
    }
}

