/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1664;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2535;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.w3c.dom.Element;

public class EntityComponent<E extends class_1297>
extends BaseComponent {
    protected final class_898 dispatcher;
    protected final class_4597.class_4598 entityBuffers;
    protected final E entity;
    protected float mouseRotation = 0.0f;
    protected float scale = 1.0f;
    protected boolean lookAtCursor = false;
    protected boolean allowMouseRotation = false;
    protected boolean scaleToFit = false;
    protected Consumer<class_4587> transform;

    protected EntityComponent(Sizing sizing, E entity) {
        this.transform = matrixStack -> {};
        class_310 client = class_310.method_1551();
        this.dispatcher = client.method_1561();
        this.entityBuffers = client.method_22940().method_23000();
        this.entity = entity;
        this.sizing(sizing);
    }

    protected EntityComponent(Sizing sizing, class_1299<E> type, @Nullable class_2487 nbt) {
        this.transform = matrixStack -> {};
        class_310 client = class_310.method_1551();
        this.dispatcher = client.method_1561();
        this.entityBuffers = client.method_22940().method_23000();
        this.entity = type.method_5883((class_1937)client.field_1687);
        if (nbt != null) {
            this.entity.method_5651(nbt);
        }
        this.entity.method_30634(client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321());
        this.sizing(sizing);
    }

    @Override
    public void draw(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        matrices.method_22903();
        matrices.method_46416((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, 100.0f);
        matrices.method_22905(75.0f * this.scale * (float)this.width / 64.0f, -75.0f * this.scale * (float)this.height / 64.0f, 75.0f * this.scale);
        matrices.method_46416(0.0f, this.entity.method_17682() / -2.0f, 0.0f);
        this.transform.accept(matrices);
        if (this.lookAtCursor) {
            float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
            float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.x) - (float)this.width / 2.0f) / 40.0f));
            E e = this.entity;
            if (e instanceof class_1309) {
                class_1309 living = (class_1309)e;
                living.field_6259 = -yRotation;
            }
            ((class_1297)this.entity).field_5982 = -yRotation;
            ((class_1297)this.entity).field_6004 = xRotation * 0.65f;
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrices.method_22907(class_7833.field_40714.rotationDegrees(xRotation * 0.15f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(yRotation * 0.15f));
        } else {
            matrices.method_22907(class_7833.field_40714.rotationDegrees(35.0f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-45.0f + this.mouseRotation));
        }
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.15f, 1.0f, 0.0f), (Vector3f)new Vector3f(0.15f, -1.0f, 0.0f));
        this.dispatcher.method_3948(false);
        this.dispatcher.method_3954(this.entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrices, (class_4597)this.entityBuffers, 0xF000F0);
        this.dispatcher.method_3948(true);
        this.entityBuffers.method_22993();
        class_308.method_24211();
        matrices.method_22909();
    }

    @Override
    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        if (this.allowMouseRotation && button == 0) {
            this.mouseRotation = (float)((double)this.mouseRotation + deltaX);
            super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
            return true;
        }
        return super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
    }

    public E entity() {
        return this.entity;
    }

    public EntityComponent<E> allowMouseRotation(boolean allowMouseRotation) {
        this.allowMouseRotation = allowMouseRotation;
        return this;
    }

    public boolean allowMouseRotation() {
        return this.allowMouseRotation;
    }

    public EntityComponent<E> lookAtCursor(boolean lookAtCursor) {
        this.lookAtCursor = lookAtCursor;
        return this;
    }

    public boolean lookAtCursor() {
        return this.lookAtCursor;
    }

    public EntityComponent<E> scale(float scale) {
        this.scale = scale;
        return this;
    }

    public float scale() {
        return this.scale;
    }

    public EntityComponent<E> scaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
        if (scaleToFit) {
            float xScale = 0.5f / this.entity.method_17681();
            float yScale = 0.5f / this.entity.method_17682();
            this.scale(Math.min(xScale, yScale));
        }
        return this;
    }

    public boolean scaleToFit() {
        return this.scaleToFit;
    }

    public EntityComponent<E> transform(Consumer<class_4587> transform) {
        this.transform = transform;
        return this;
    }

    public Consumer<class_4587> transform() {
        return this.transform;
    }

    @Override
    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.MOUSE_CLICK;
    }

    public static RenderablePlayerEntity createRenderablePlayer(GameProfile profile) {
        return new RenderablePlayerEntity(profile);
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "scale", UIParsing::parseFloat, this::scale);
        UIParsing.apply(children, "look-at-cursor", UIParsing::parseBool, this::lookAtCursor);
        UIParsing.apply(children, "mouse-rotation", UIParsing::parseBool, this::allowMouseRotation);
        UIParsing.apply(children, "scale-to-fit", UIParsing::parseBool, this::scaleToFit);
    }

    public static EntityComponent<?> parse(Element element) {
        UIParsing.expectAttributes(element, "type");
        class_2960 entityId = UIParsing.parseIdentifier(element.getAttributeNode("type"));
        class_1299 entityType = (class_1299)class_7923.field_41177.method_17966(entityId).orElseThrow(() -> new UIModelParsingException("Unknown entity type " + entityId));
        return new EntityComponent(Sizing.content(), entityType, null);
    }

    protected static class RenderablePlayerEntity
    extends class_746 {
        protected class_2960 skinTextureId = null;
        protected String model = null;

        public RenderablePlayerEntity(GameProfile profile) {
            super(class_310.method_1551(), class_310.method_1551().field_1687, new class_634(class_310.method_1551(), null, new class_2535(class_2598.field_11942), null, profile, class_310.method_1551().method_47601().method_47706(false, Duration.ZERO)), null, null, false, false);
            this.field_3937.method_1582().method_4652(this.method_7334(), (type, identifier, texture) -> {
                if (type != MinecraftProfileTexture.Type.SKIN) {
                    return;
                }
                this.skinTextureId = identifier;
                this.model = texture.getMetadata("model");
                if (this.model == null) {
                    this.model = "default";
                }
            }, true);
        }

        public boolean method_3127() {
            return this.skinTextureId != null;
        }

        public class_2960 method_3117() {
            return this.skinTextureId != null ? this.skinTextureId : super.method_3117();
        }

        public boolean method_7348(class_1664 modelPart) {
            return true;
        }

        public String method_3121() {
            return this.model != null ? this.model : super.method_3121();
        }

        @Nullable
        protected class_640 method_3123() {
            return null;
        }
    }
}

