/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.registration;

import io.wispforest.owo.registration.ComplexRegistryAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

public class RegistryHelper<T> {
    private static final Map<class_2378<?>, RegistryHelper<?>> INSTANCES = new HashMap();
    private final class_2378<T> registry;
    private final Map<class_2960, Consumer<T>> actions = new HashMap<class_2960, Consumer<T>>();
    private final List<ComplexRegistryAction> complexActions = new ArrayList<ComplexRegistryAction>();

    public static <T> RegistryHelper<T> get(class_2378<T> registry) {
        return INSTANCES.computeIfAbsent(registry, objects -> new RegistryHelper(registry));
    }

    @ApiStatus.Internal
    public RegistryHelper(class_2378<T> registry) {
        this.registry = registry;
        RegistryEntryAddedCallback.event(registry).register((rawId, id, object) -> {
            if (this.actions.containsKey(id)) {
                this.actions.remove(id).accept(object);
            }
            ArrayList<Runnable> actionsToExecute = new ArrayList<Runnable>();
            this.complexActions.removeIf(action -> action.update(id, actionsToExecute));
            actionsToExecute.forEach(Runnable::run);
        });
    }

    public void runWhenPresent(class_2960 id, Consumer<T> action) {
        if (RegistryHelper.isContained(this.registry, id)) {
            action.accept(this.registry.method_10223(id));
        } else {
            this.actions.put(id, action);
        }
    }

    public void runWhenPresent(ComplexRegistryAction action) {
        if (!action.preCheck(this.registry)) {
            this.complexActions.add(action);
        }
    }

    private static <T> boolean isContained(class_2378<T> registry, class_2960 identifier) {
        return registry.method_10250(identifier);
    }
}

