/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.command.debug;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.wispforest.owo.Owo;
import io.wispforest.owo.ops.TextOps;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2203;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7923;

public class DumpdataCommand {
    private static final int GENERAL_PURPLE = 12157951;
    private static final int KEY_BLUE = 9745405;
    private static final int VALUE_BLUE = 9755391;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dumpdata").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"item").executes(DumpdataCommand.withRootPath(DumpdataCommand::executeItem))).then(class_2170.method_9244((String)"nbt_path", (ArgumentType)class_2203.method_9360()).executes(DumpdataCommand.withPathArg(DumpdataCommand::executeItem))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"block").executes(DumpdataCommand.withRootPath(DumpdataCommand::executeBlock))).then(class_2170.method_9244((String)"nbt_path", (ArgumentType)class_2203.method_9360()).executes(DumpdataCommand.withPathArg(DumpdataCommand::executeBlock))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"entity").executes(DumpdataCommand.withRootPath(DumpdataCommand::executeEntity))).then(class_2170.method_9244((String)"nbt_path", (ArgumentType)class_2203.method_9360()).executes(DumpdataCommand.withPathArg(DumpdataCommand::executeEntity)))));
    }

    private static Command<class_2168> withRootPath(DataDumper dumper) {
        return context -> dumper.dump((CommandContext<class_2168>)context, class_2203.method_9360().method_9362(new StringReader("")));
    }

    private static Command<class_2168> withPathArg(DataDumper dumper) {
        return context -> {
            class_2203.class_2209 path = class_2203.method_9358((CommandContext)context, (String)"nbt_path");
            return dumper.dump((CommandContext<class_2168>)context, path);
        };
    }

    private static int executeItem(CommandContext<class_2168> context, class_2203.class_2209 path) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1799 stack = source.method_44023().method_6047();
        DumpdataCommand.informationHeader(source, "Item");
        DumpdataCommand.sendIdentifier(source, stack.method_7909(), class_7923.field_41178);
        if (stack.method_7909().method_7846()) {
            DumpdataCommand.feedback(source, (class_2561)TextOps.withColor("Durability: \u00a7" + stack.method_7909().method_7841(), TextOps.color(class_124.field_1080), 9745405));
        } else {
            DumpdataCommand.feedback(source, (class_2561)TextOps.withFormatting("Not damageable", class_124.field_1080));
        }
        if (((class_2168)context.getSource()).method_44023().method_6047().method_7985()) {
            DumpdataCommand.feedback(source, (class_2561)TextOps.withFormatting("NBT" + DumpdataCommand.formatPath(path) + ": ", class_124.field_1080).method_10852(class_2512.method_32270((class_2520)DumpdataCommand.getPath((class_2520)stack.method_7969(), path))));
        } else {
            DumpdataCommand.feedback(source, (class_2561)TextOps.withFormatting("No NBT", class_124.field_1080));
        }
        DumpdataCommand.feedback(source, (class_2561)TextOps.withFormatting("-----------------------", class_124.field_1080));
        return 0;
    }

    private static int executeEntity(CommandContext<class_2168> context, class_2203.class_2209 path) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        class_3966 target = class_1675.method_18075((class_1297)player, (class_243)player.method_5836(0.0f), (class_243)player.method_5836(0.0f).method_1019(player.method_5828(0.0f).method_1021(5.0)), (class_238)player.method_5829().method_18804(player.method_5828(0.0f).method_1021(5.0)).method_1014(1.0), entity -> true, (double)25.0);
        if (target == null || target.method_17783() != class_239.class_240.field_1331) {
            source.method_9213((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)class_2561.method_43470((String)"You're not looking at an entity")));
            return 1;
        }
        class_1297 entity2 = target.method_17782();
        DumpdataCommand.informationHeader(source, "Entity");
        DumpdataCommand.sendIdentifier(source, entity2.method_5864(), class_7923.field_41177);
        DumpdataCommand.feedback(source, (class_2561)TextOps.withFormatting("NBT" + DumpdataCommand.formatPath(path) + ": ", class_124.field_1080).method_10852(class_2512.method_32270((class_2520)DumpdataCommand.getPath((class_2520)entity2.method_5647(new class_2487()), path))));
        DumpdataCommand.feedback(source, (class_2561)TextOps.withFormatting("-----------------------", class_124.field_1080));
        return 0;
    }

    private static int executeBlock(CommandContext<class_2168> context, class_2203.class_2209 path) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        class_239 target = player.method_5745(5.0, 0.0f, false);
        if (target.method_17783() != class_239.class_240.field_1332) {
            source.method_9213((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)class_2561.method_43470((String)"You're not looking at a block")));
            return 1;
        }
        class_2338 pos = ((class_3965)target).method_17777();
        class_2680 blockState = player.method_14220().method_8320(pos);
        String blockStateString = blockState.toString();
        DumpdataCommand.informationHeader(source, "Block");
        DumpdataCommand.sendIdentifier(source, blockState.method_26204(), class_7923.field_41175);
        if (blockStateString.contains("[")) {
            String[] stateInfo;
            DumpdataCommand.feedback(source, (class_2561)TextOps.withFormatting("State properties: ", class_124.field_1080));
            String stateString = blockStateString.split(Pattern.quote("["))[1];
            stateString = stateString.substring(0, stateString.length() - 1);
            for (String property : stateInfo = stateString.replaceAll("=", ": \u00a7").split(",")) {
                DumpdataCommand.feedback(source, (class_2561)TextOps.withColor("    " + property, 9745405, 9755391));
            }
        } else {
            DumpdataCommand.feedback(source, (class_2561)TextOps.withFormatting("No state properties", class_124.field_1080));
        }
        class_2586 blockEntity = player.method_14220().method_8321(pos);
        if (blockEntity != null) {
            DumpdataCommand.feedback(source, (class_2561)TextOps.withFormatting("Block Entity NBT" + DumpdataCommand.formatPath(path) + ": ", class_124.field_1080).method_10852(class_2512.method_32270((class_2520)DumpdataCommand.getPath((class_2520)blockEntity.method_38244(), path))));
        } else {
            DumpdataCommand.feedback(source, (class_2561)TextOps.withFormatting("No block entity", class_124.field_1080));
        }
        DumpdataCommand.feedback(source, (class_2561)TextOps.withFormatting("-----------------------", class_124.field_1080));
        return 0;
    }

    private static <T> void sendIdentifier(class_2168 source, T object, class_2378<T> registry) {
        String[] id = registry.method_10221(object).toString().split(":");
        DumpdataCommand.feedback(source, (class_2561)TextOps.withColor("Identifier: \u00a7" + id[0] + ":\u00a7" + id[1], TextOps.color(class_124.field_1080), 9745405, 9755391));
    }

    private static void informationHeader(class_2168 source, String name) {
        DumpdataCommand.feedback(source, (class_2561)TextOps.withColor("---[\u00a7 " + name + " Information \u00a7]---", TextOps.color(class_124.field_1080), 12157951, TextOps.color(class_124.field_1080)));
    }

    private static void feedback(class_2168 source, class_2561 message) {
        source.method_9226(message, false);
    }

    private static String formatPath(class_2203.class_2209 path) {
        return path.toString().isBlank() ? "" : "(" + path + ")";
    }

    private static class_2520 getPath(class_2520 nbt, class_2203.class_2209 path) throws CommandSyntaxException {
        return (class_2520)path.method_9366(nbt).iterator().next();
    }

    @FunctionalInterface
    private static interface DataDumper {
        public int dump(CommandContext<class_2168> var1, class_2203.class_2209 var2) throws CommandSyntaxException;
    }
}

