/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.util;

import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackInfo;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.util.TimeUtil;
import java.net.URI;
import java.util.function.Function;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public final class GuiTrackUtils {
    private static final class_310 MINECRAFT = class_310.method_1551();

    public static String trimToWith(String string, int width) {
        Object newString = GuiTrackUtils.MINECRAFT.field_1772.method_27523(string, width);
        if (!((String)newString).equals(string)) {
            newString = (String)newString + "...";
        }
        return newString;
    }

    public static void addTrackInfo(class_4587 matrixStack, IAudioTrack track, int x, int y, int entryWidth, int leftMargin, int titleColor) {
        int textSize = entryWidth - 150 - leftMargin;
        IAudioTrackInfo info = track.getInfo();
        String title = GuiTrackUtils.trimToWith(info.getFixedTitle(), textSize);
        String author = GuiTrackUtils.trimToWith(info.getFixedAuthor(), textSize);
        String duration = GuiTrackUtils.getFormattedDuration(track);
        GuiTrackUtils.MINECRAFT.field_1772.method_1729(matrixStack, title, (float)(x + leftMargin), (float)(y + 5), titleColor);
        GuiTrackUtils.MINECRAFT.field_1772.method_1729(matrixStack, author, (float)(x + leftMargin + 4), (float)(y + 25), 14183708);
        GuiTrackUtils.MINECRAFT.field_1772.method_1729(matrixStack, duration, (float)(x + entryWidth - 140), (float)(y + 15), 0xFFFF00);
    }

    public static boolean openURI(String uri) {
        class_2583 style = class_2561.method_30163(null).method_10866();
        try {
            new URI(uri);
            style = style.method_10958(new class_2558(class_2558.class_2559.field_11749, uri));
        }
        catch (Exception ex) {
            style = style.method_10958(new class_2558(class_2558.class_2559.field_11746, uri));
        }
        return GuiTrackUtils.MINECRAFT.field_1755.method_25430(style);
    }

    public static String getFormattedDuration(IAudioTrack track) {
        long seconds;
        if (track == null) {
            seconds = 0L;
        } else {
            IAudioTrackInfo info = track.getInfo();
            if (info.isStream()) {
                return MusicPlayerLocalization.getTranslation("gui.track.duration_undefined", new Object[0]);
            }
            seconds = track.getDuration() / 1000L;
        }
        return TimeUtil.timeConversion(seconds);
    }

    public static String getFormattedPosition(IAudioTrack track) {
        return TimeUtil.timeConversion(track == null ? 0L : track.getPosition() / 1000L);
    }

    public static <T> T getValueOfPlayingTrack(Function<IAudioTrack, T> function) {
        return GuiTrackUtils.getValueOfNullableTrack(MusicPlayerManager.getPlayer().getTrackManager().getCurrentTrack(), function);
    }

    public static <T> T getValueOfNullableTrack(IAudioTrack track, Function<IAudioTrack, T> function) {
        if (track != null) {
            return function.apply(track);
        }
        return null;
    }
}

