/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist.search;

import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylist;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchList;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntryMusicTrack;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntryPlaylist;
import info.u_team.music_player.gui.playlist.search.SearchProvider;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackList;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.UButton;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class GuiMusicSearch
extends BetterScreen {
    private final Playlist playlist;
    private class_342 urlField;
    private class_342 searchField;
    private final GuiMusicSearchList searchList;
    private SearchProvider searchProvider;
    private String information;
    private int informationTicks;
    private int maxTicksInformation;

    public GuiMusicSearch(Playlist playlist) {
        super((class_2561)class_2561.method_43470((String)"musicsearch"));
        this.playlist = playlist;
        this.searchList = new GuiMusicSearchList();
        this.searchProvider = SearchProvider.YOUTUBE;
    }

    protected void method_25426() {
        ImageButton backButton = (ImageButton)this.method_37063((class_364)new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK));
        backButton.setPressable(() -> this.field_22787.method_1507((class_437)new GuiMusicPlaylist(this.playlist)));
        this.urlField = new class_342(this.field_22793, 10, 35, this.field_22789 / 2 - 10, 20, class_2561.method_30163((String)"")){

            public boolean method_25404(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
                GuiMusicSearch.this.keyFromTextField(this, this.method_1882(), key);
                return super.method_25404(key, p_keyPressed_2_, p_keyPressed_3_);
            }
        };
        this.urlField.method_1880(10000);
        this.method_25429((class_364)this.urlField);
        UButton openFileButton = (UButton)this.method_37063((class_364)new UButton(this.field_22789 / 2 + 10, 34, this.field_22789 / 4 - 15, 22, class_2561.method_30163((String)MusicPlayerLocalization.getTranslation("gui.search.load.file", new Object[0]))));
        openFileButton.setPressable(() -> {
            String response = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)MusicPlayerLocalization.getTranslation("gui.search.load.file", new Object[0]), null, null, (CharSequence)MusicPlayerLocalization.getTranslation("gui.search.music_files", new Object[0]), (boolean)false);
            if (response != null) {
                this.searchList.clear();
                this.addTrack(response);
            }
        });
        UButton openFolderButton = (UButton)this.method_37063((class_364)new UButton((int)((double)this.field_22789 * 0.75) + 5, 34, this.field_22789 / 4 - 15, 22, class_2561.method_30163((String)MusicPlayerLocalization.getTranslation("gui.search.load.folder", new Object[0]))));
        openFolderButton.setPressable(() -> {
            String response = TinyFileDialogs.tinyfd_selectFolderDialog((CharSequence)MusicPlayerLocalization.getTranslation("gui.search.load.folder", new Object[0]), (CharSequence)System.getProperty("user.home"));
            if (response != null) {
                this.searchList.clear();
                try (Stream<Path> stream = Files.list(Paths.get(response, new String[0]));){
                    stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> this.addTrack(path.toString()));
                }
                catch (IOException ex) {
                    this.setInformation(class_124.field_1061 + ex.getMessage(), 150);
                }
            }
        });
        ImageButton searchButton = (ImageButton)this.method_37063((class_364)new ImageButton(10, 76, 24, 24, this.searchProvider.getLogo()));
        searchButton.setPressable(() -> {
            this.searchProvider = SearchProvider.toggle(this.searchProvider);
            searchButton.setImage(this.searchProvider.getLogo());
        });
        this.searchField = new class_342(this.field_22793, 40, 78, this.field_22789 - 51, 20, class_2561.method_30163((String)"")){

            public boolean method_25404(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
                GuiMusicSearch.this.keyFromTextField(this, GuiMusicSearch.this.searchProvider.getPrefix() + this.method_1882(), key);
                return super.method_25404(key, p_keyPressed_2_, p_keyPressed_3_);
            }

            public boolean method_25407(boolean p_changeFocus_1_) {
                System.out.println("CHANGEED FOR Search FIELD to " + p_changeFocus_1_);
                return super.method_25407(p_changeFocus_1_);
            }
        };
        this.searchField.method_1880(1000);
        this.searchField.method_1876(true);
        this.method_25395((class_364)this.searchField);
        this.method_25429((class_364)this.searchField);
        UButton addAllButton = (UButton)this.method_37063((class_364)new UButton(this.field_22789 - 110, 105, 100, 20, class_2561.method_30163((String)MusicPlayerLocalization.getTranslation("gui.search.add_all", new Object[0]))));
        addAllButton.setPressable(() -> {
            List<GuiMusicSearchListEntryPlaylist> list = this.searchList.method_25396().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryPlaylist).map(entry -> (GuiMusicSearchListEntryPlaylist)((Object)((Object)entry))).collect(Collectors.toList());
            if (list.size() > 0) {
                list.forEach(entry -> this.playlist.add(entry.getTrackList()));
            } else {
                this.searchList.method_25396().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryMusicTrack).map(entry -> (GuiMusicSearchListEntryMusicTrack)((Object)((Object)entry))).filter(entry -> !entry.isPlaylistEntry()).forEach(entry -> this.playlist.add(entry.getTrack()));
            }
            this.setInformation(class_124.field_1060 + MusicPlayerLocalization.getTranslation("gui.search.added_all", new Object[0]), 150);
        });
        this.searchList.updateSettings(this.field_22789 - 24, this.field_22790, 130, this.field_22790 - 10, 12, this.field_22789 - 12);
        this.method_25429((class_364)this.searchList);
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        String urlFieldText = this.urlField.method_1882();
        boolean urlFieldFocus = this.urlField.method_25370() && this.method_25399() == this.urlField;
        String searchFieldText = this.searchField.method_1882();
        boolean searchFieldFocus = this.searchField.method_25370() && this.method_25399() == this.searchField;
        this.method_25423(minecraft, width, height);
        this.urlField.method_1852(urlFieldText);
        this.urlField.method_1876(urlFieldFocus);
        if (urlFieldFocus) {
            this.method_25395((class_364)this.urlField);
        }
        this.searchField.method_1852(searchFieldText);
        this.searchField.method_1876(searchFieldFocus);
        if (searchFieldFocus) {
            this.method_25395((class_364)this.searchField);
        }
    }

    public void method_25393() {
        this.urlField.method_1865();
        this.searchField.method_1865();
        ++this.informationTicks;
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25434(0);
        this.searchList.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        GuiMusicSearch.method_25300((class_4587)matrixStack, (class_327)this.field_22787.field_1772, (String)MusicPlayerLocalization.getTranslation("gui.search.header", new Object[0]), (int)(this.field_22789 / 2), (int)5, (int)0xFFFFFF);
        GuiMusicSearch.method_25303((class_4587)matrixStack, (class_327)this.field_22787.field_1772, (String)MusicPlayerLocalization.getTranslation("gui.search.search.uri", new Object[0]), (int)10, (int)20, (int)0xFFFFFF);
        GuiMusicSearch.method_25303((class_4587)matrixStack, (class_327)this.field_22787.field_1772, (String)MusicPlayerLocalization.getTranslation("gui.search.search.file", new Object[0]), (int)(10 + this.field_22789 / 2), (int)20, (int)0xFFFFFF);
        GuiMusicSearch.method_25303((class_4587)matrixStack, (class_327)this.field_22787.field_1772, (String)MusicPlayerLocalization.getTranslation("gui.search.search.search", new Object[0]), (int)10, (int)63, (int)0xFFFFFF);
        if (this.information != null && this.informationTicks <= this.maxTicksInformation) {
            GuiMusicSearch.method_25303((class_4587)matrixStack, (class_327)this.field_22787.field_1772, (String)this.information, (int)15, (int)110, (int)0xFFFFFF);
        }
        this.urlField.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.searchField.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.urlField.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)this.urlField);
            this.urlField.method_1876(true);
            this.searchField.method_1876(false);
            return true;
        }
        if (this.searchField.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)this.searchField);
            this.searchField.method_1876(true);
            this.urlField.method_1876(false);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void setInformation(String information, int maxTicksInformation) {
        this.information = information;
        this.maxTicksInformation = maxTicksInformation;
        this.informationTicks = 0;
    }

    private void keyFromTextField(class_342 field, String text, int key) {
        if (field.method_1885() && field.method_25370() && (key == 257 || key == 335)) {
            this.searchList.clear();
            this.addTrack(text);
            field.method_1852("");
        }
    }

    private void addTrack(String uri) {
        MusicPlayerManager.getPlayer().getTrackSearch().getTracks(uri, result -> this.field_22787.execute(() -> {
            if (result.hasError()) {
                this.setInformation(class_124.field_1061 + result.getErrorMessage(), 150);
            } else if (result.isList()) {
                IAudioTrackList list = result.getTrackList();
                if (!list.isSearch()) {
                    this.searchList.add(new GuiMusicSearchListEntryPlaylist(this, this.playlist, list));
                }
                list.getTracks().forEach(track -> this.searchList.add(new GuiMusicSearchListEntryMusicTrack(this, this.playlist, (IAudioTrack)track, !list.isSearch())));
            } else {
                IAudioTrack track2 = result.getTrack();
                this.searchList.add(new GuiMusicSearchListEntryMusicTrack(this, this.playlist, track2, false));
            }
        }));
    }
}

