/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.controls;

import info.u_team.music_player.gui.BetterNestedGui;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiMusicProgressBar;
import info.u_team.music_player.gui.controls.GuiVolumeSlider;
import info.u_team.music_player.gui.settings.GuiMusicPlayerSettings;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerColors;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.MusicPlayerUtils;
import info.u_team.music_player.musicplayer.settings.Repeat;
import info.u_team.music_player.musicplayer.settings.Settings;
import info.u_team.u_team_core.gui.elements.ImageActivatableButton;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ImageToggleButton;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class GuiControls
extends class_362
implements BetterNestedGui,
class_4068,
class_6379 {
    private final int middleX;
    private final int y;
    private final int width;
    private final int buttonSize;
    private final int halfButtonSize;
    private final List<class_339> buttons;
    private final List<class_339> disableButtons;
    private final List<class_364> children;
    private final ITrackManager manager;
    private final ImageToggleButton playButton;
    private final GuiMusicProgressBar songProgress;
    private final ScrollingText titleRender;
    private final ScrollingText authorRender;

    public GuiControls(class_437 gui, int y, int width) {
        boolean isIngame;
        this.y = y;
        this.width = width;
        this.middleX = width / 2;
        this.buttons = new ArrayList<class_339>();
        this.disableButtons = new ArrayList<class_339>();
        this.children = new ArrayList<class_364>();
        this.manager = MusicPlayerManager.getPlayer().getTrackManager();
        class_310 mc = class_310.method_1551();
        boolean isSettings = gui instanceof GuiMusicPlayerSettings;
        boolean small = isIngame = gui instanceof class_433;
        this.buttonSize = small ? 15 : 20;
        this.halfButtonSize = this.buttonSize / 2;
        this.playButton = this.addButton(new ImageToggleButton(this.middleX - this.halfButtonSize, y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_PLAY, MusicPlayerResources.TEXTURE_PAUSE, !this.manager.isPaused()));
        this.playButton.setPressable(() -> {
            boolean play = this.playButton.isToggled();
            this.manager.setPaused(!play);
        });
        ImageButton skipForwardButton = this.addButton(new ImageButton(this.middleX + this.halfButtonSize + 5, y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_SKIP_FORWARD));
        skipForwardButton.setPressable(() -> MusicPlayerUtils.skipForward());
        ImageButton skipBackButton = this.addButton(new ImageButton(this.middleX - (this.buttonSize + this.halfButtonSize + 5), y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_SKIP_BACK));
        skipBackButton.setPressable(() -> MusicPlayerUtils.skipBack());
        Settings settings = MusicPlayerManager.getSettingsManager().getSettings();
        ImageActivatableButton shuffleButton = this.addButton(new ImageActivatableButton(this.middleX - (2 * this.buttonSize + this.halfButtonSize + 10), y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_SHUFFLE, settings.isShuffle(), MusicPlayerColors.LIGHT_GREEN));
        shuffleButton.setPressable(() -> {
            settings.setShuffle(!settings.isShuffle());
            shuffleButton.setActivated(settings.isShuffle());
        });
        ImageActivatableButton repeatButton = this.addButton(new ImageActivatableButton(this.middleX + this.buttonSize + this.halfButtonSize + 10, y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_REPEAT, settings.getRepeat().isActive(), MusicPlayerColors.LIGHT_GREEN));
        repeatButton.setImage(settings.getRepeat().getResource());
        repeatButton.setPressable(() -> {
            settings.setRepeat(Repeat.forwardCycle(settings.getRepeat()));
            repeatButton.setActivated(settings.getRepeat().isActive());
            repeatButton.setImage(settings.getRepeat().getResource());
        });
        this.songProgress = new GuiMusicProgressBar(this.manager, this.middleX - (small ? 50 : 100), y + (small ? 20 : 30), small ? 100 : 200, small ? 3 : 5, small ? 0.5f : 1.0f);
        this.children.add((class_364)this.songProgress);
        if (!isSettings) {
            ImageButton settingsButton = this.addButtonNonDisable(new ImageButton(width - 16, 1, 15, 15, MusicPlayerResources.TEXTURE_SETTINGS));
            settingsButton.setPressable(() -> mc.method_1507((class_437)new GuiMusicPlayerSettings(gui)));
        }
        if (isIngame) {
            ImageButton guiButton = this.addButtonNonDisable(new ImageButton(width - 32, 1, 15, 15, MusicPlayerResources.TEXTURE_OPEN));
            guiButton.setPressable(() -> mc.method_1507((class_437)new GuiMusicPlayer()));
        }
        int volumeY = width - (70 + (isIngame ? 33 : (!isSettings ? 17 : 1)));
        this.addButtonNonDisable(new GuiVolumeSlider(volumeY, 1, 70, 15, class_2561.method_30163((String)(MusicPlayerLocalization.getTranslation("gui.controls.volume", new Object[0]) + ": ")), class_2561.method_30163((String)"%"), 0.0, 100.0, settings.getVolume(), false, true, false, 0.7f, slider -> {
            settings.setVolume(slider.getValueInt());
            MusicPlayerManager.getPlayer().setVolume(settings.getVolume());
        }));
        int textRenderWidth = this.middleX - (2 * this.buttonSize + this.halfButtonSize + 10) - (small ? 15 : 35);
        int textRenderY = small ? y : y + 2;
        this.titleRender = new ScrollingText(mc.field_1772, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedTitle()), small ? 10.0f : 25.0f, (float)textRenderY);
        this.titleRender.setWidth(textRenderWidth);
        this.titleRender.setStepSize(0.5f);
        this.titleRender.setColor(MusicPlayerColors.YELLOW);
        this.titleRender.setSpeedTime(35);
        this.authorRender = new ScrollingText(mc.field_1772, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedAuthor()), small ? 10.0f : 25.0f, (float)(textRenderY + 10));
        this.authorRender.setWidth(textRenderWidth);
        this.authorRender.setStepSize(0.5f);
        this.authorRender.setColor(MusicPlayerColors.YELLOW);
        this.authorRender.setScale(0.75f);
        this.authorRender.setSpeedTime(35);
        this.disableButtons.forEach(button -> {
            button.field_22763 = false;
        });
        this.buttons.forEach(this.children::add);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return true;
    }

    public void tick() {
        if (this.manager.getCurrentTrack() == null) {
            this.disableButtons.forEach(button -> {
                button.field_22763 = false;
            });
        } else {
            this.disableButtons.forEach(button -> {
                button.field_22763 = true;
            });
        }
        this.playButton.setToggled(!this.manager.isPaused());
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.buttons.forEach(button -> button.method_25394(matrixStack, mouseX, mouseY, partialTicks));
        this.songProgress.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.titleRender.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.authorRender.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.manager.getCurrentTrack() != null && button == 0 && (this.checkClick(this.titleRender, mouseX, mouseY) || this.checkClick(this.authorRender, mouseX, mouseY)) && GuiTrackUtils.openURI(this.manager.getCurrentTrack().getInfo().getURI())) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkClick(ScrollingText renderer, double mouseX, double mouseY) {
        if (!(mouseX >= (double)renderer.getX())) return false;
        if (!(mouseY >= (double)renderer.getY())) return false;
        if (!(mouseX < (double)(renderer.getX() + (float)renderer.getWidth()))) return false;
        float f = renderer.getY();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        if (!(mouseY < (double)(f + (float)(9 + 1) * renderer.getScale()))) return false;
        return true;
    }

    private <B extends class_339> B addButton(B button) {
        this.buttons.add(button);
        this.disableButtons.add(button);
        return button;
    }

    private <B extends class_339> B addButtonNonDisable(B button) {
        this.buttons.add(button);
        return button;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public ScrollingText getTitleRender() {
        return this.titleRender;
    }

    public ScrollingText getAuthorRender() {
        return this.authorRender;
    }

    public void copyTitleRendererState(ScrollingText renderer) {
        this.titleRender.copyState(renderer);
    }

    public void copyAuthorRendererState(ScrollingText renderer) {
        this.authorRender.copyState(renderer);
    }

    public void method_37020(class_6382 p_169152_) {
    }

    public boolean method_37303() {
        return false;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }
}

