/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod.quilt;

import com.google.common.collect.Lists;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.fabric.FabricMod;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.quiltmc.loader.api.ModContainer;
import org.quiltmc.loader.api.ModContributor;
import org.quiltmc.loader.api.ModMetadata;
import org.quiltmc.loader.api.QuiltLoader;

public class QuiltMod
extends FabricMod {
    protected final ModContainer container;
    protected final ModMetadata metadata;

    public QuiltMod(net.fabricmc.loader.api.ModContainer fabricModContainer, Set<String> modpackMods) {
        super(fabricModContainer, modpackMods);
        this.container = (ModContainer)QuiltLoader.getModContainer((String)fabricModContainer.getMetadata().getId()).get();
        this.metadata = this.container.metadata();
        if ("quilt_loader".equals(this.metadata.id())) {
            this.badges.add(Mod.Badge.LIBRARY);
        }
    }

    @Override
    @NotNull
    public List<String> getAuthors() {
        List<String> authors = this.metadata.contributors().stream().filter(contributor -> contributor.role().equals("Author") || contributor.role().equals("Owner")).map(ModContributor::name).collect(Collectors.toList());
        if (authors.isEmpty()) {
            this.metadata.contributors().stream().findFirst().ifPresent(modContributor -> authors.add(modContributor.name()));
        }
        if (authors.isEmpty()) {
            if ("minecraft".equals(this.getId())) {
                return Lists.newArrayList((Object[])new String[]{"Mojang Studios"});
            }
            if ("java".equals(this.getId())) {
                return Lists.newArrayList((Object[])new String[]{System.getProperty("java.vendor")});
            }
        }
        return authors;
    }

    @Override
    @NotNull
    public List<String> getContributors() {
        List<String> authors = this.metadata.contributors().stream().map(modContributor -> modContributor.name() + " (" + modContributor.role() + ")").collect(Collectors.toList());
        if ("minecraft".equals(this.getId()) && authors.isEmpty()) {
            return Lists.newArrayList();
        }
        return authors;
    }

    @Override
    @NotNull
    public List<String> getCredits() {
        return this.getContributors();
    }
}

