/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.event;

import com.terraformersmc.modmenu.api.ModMenuApi;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.ModMenuButtonWidget;
import com.terraformersmc.modmenu.gui.widget.ModMenuTexturedButtonWidget;
import com.terraformersmc.modmenu.mixin.IGridWidgetAccessor;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3675;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_7417;
import net.minecraft.class_7845;

public class ModMenuEventHandler {
    private static final class_2960 FABRIC_ICON_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/mods_button.png");
    private static class_304 MENU_KEY_BIND;

    public static void register() {
        MENU_KEY_BIND = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.modmenu.open_menu", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "category.modmenu.name"));
        ClientTickEvents.END_CLIENT_TICK.register(ModMenuEventHandler::onClientEndTick);
        ScreenEvents.AFTER_INIT.register(ModMenuEventHandler::afterScreenInit);
    }

    public static void afterScreenInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (screen instanceof class_442) {
            ModMenuEventHandler.afterTitleScreenInit(screen);
        } else if (screen instanceof class_433) {
            ModMenuEventHandler.afterGameMenuScreenInit(screen);
        }
    }

    private static void afterTitleScreenInit(class_437 screen) {
        List buttons = Screens.getButtons((class_437)screen);
        if (ModMenuConfig.MODIFY_TITLE_SCREEN.getValue()) {
            int modsButtonIndex = -1;
            int spacing = 24;
            int buttonsY = screen.field_22790 / 4 + 48;
            for (int i = 0; i < buttons.size(); ++i) {
                class_339 button2 = (class_339)buttons.get(i);
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.CLASSIC && button2.field_22764) {
                    ModMenuEventHandler.shiftButtons(button2, modsButtonIndex == -1, 24);
                    if (modsButtonIndex == -1) {
                        buttonsY = button2.method_46427();
                    }
                }
                if (!ModMenuEventHandler.buttonHasText(button2, "menu.online")) continue;
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.REPLACE_REALMS) {
                    buttons.set(i, new ModMenuButtonWidget(button2.method_46426(), button2.method_46427(), button2.method_25368(), button2.method_25364(), ModMenuApi.createModsButtonText(), screen));
                    continue;
                }
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.SHRINK) {
                    button2.method_25358(98);
                }
                modsButtonIndex = i + 1;
                if (!button2.field_22764) continue;
                buttonsY = button2.method_46427();
            }
            if (modsButtonIndex != -1) {
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.CLASSIC) {
                    buttons.add(modsButtonIndex, new ModMenuButtonWidget(screen.field_22789 / 2 - 100, buttonsY + 24, 200, 20, ModMenuApi.createModsButtonText(), screen));
                } else if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.SHRINK) {
                    buttons.add(modsButtonIndex, new ModMenuButtonWidget(screen.field_22789 / 2 + 2, buttonsY, 98, 20, ModMenuApi.createModsButtonText(), screen));
                } else if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.ICON) {
                    buttons.add(modsButtonIndex, new ModMenuTexturedButtonWidget(screen.field_22789 / 2 + 104, buttonsY, 20, 20, 0, 0, FABRIC_ICON_BUTTON_LOCATION, 32, 64, button -> class_310.method_1551().method_1507((class_437)new ModsScreen(screen)), ModMenuApi.createModsButtonText()));
                }
            }
        }
    }

    private static void afterGameMenuScreenInit(class_437 screen) {
        class_339 widget = (class_339)Screens.getButtons((class_437)screen).get(0);
        if (widget instanceof class_7845) {
            List<class_339> buttons = ((IGridWidgetAccessor)widget).getChildren();
            if (ModMenuConfig.MODIFY_GAME_MENU.getValue()) {
                int modsButtonIndex = -1;
                int spacing = 24;
                int buttonsY = screen.field_22790 / 4 + 8;
                ModMenuConfig.ModsButtonStyle style = ModMenuConfig.MODS_BUTTON_STYLE.getValue().forGameMenu();
                for (int i = 0; i < buttons.size(); ++i) {
                    class_339 button2 = buttons.get(i);
                    if (style == ModMenuConfig.ModsButtonStyle.CLASSIC && button2.field_22764) {
                        ModMenuEventHandler.shiftButtons(button2, modsButtonIndex == -1, 24);
                        if (modsButtonIndex == -1) {
                            buttonsY = button2.method_46427();
                        }
                    }
                    if (!ModMenuEventHandler.buttonHasText(button2, "menu.reportBugs")) continue;
                    modsButtonIndex = i + 1;
                    if (style == ModMenuConfig.ModsButtonStyle.SHRINK) {
                        buttons.set(i, (class_339)new ModMenuButtonWidget(button2.method_46426(), button2.method_46427(), button2.method_25368(), button2.method_25364(), ModMenuApi.createModsButtonText(), screen));
                        continue;
                    }
                    modsButtonIndex = i + 1;
                    if (!button2.field_22764) continue;
                    buttonsY = button2.method_46427();
                }
                if (modsButtonIndex != -1) {
                    if (style == ModMenuConfig.ModsButtonStyle.CLASSIC) {
                        buttons.add(modsButtonIndex, (class_339)new ModMenuButtonWidget(screen.field_22789 / 2 - 102, buttonsY + 24, 204, 20, ModMenuApi.createModsButtonText(), screen));
                    } else if (style == ModMenuConfig.ModsButtonStyle.ICON) {
                        buttons.add(modsButtonIndex, (class_339)new ModMenuTexturedButtonWidget(screen.field_22789 / 2 + 4 + 100 + 2, screen.field_22790 / 4 + 72 - 16, 20, 20, 0, 0, FABRIC_ICON_BUTTON_LOCATION, 32, 64, button -> class_310.method_1551().method_1507((class_437)new ModsScreen(screen)), ModMenuApi.createModsButtonText()));
                    }
                }
            }
        }
    }

    private static void onClientEndTick(class_310 client) {
        while (MENU_KEY_BIND.method_1436()) {
            client.method_1507((class_437)new ModsScreen(client.field_1755));
        }
    }

    private static boolean buttonHasText(class_339 button, String translationKey) {
        class_2561 text = button.method_25369();
        class_7417 textContent = text.method_10851();
        return textContent instanceof class_2588 && ((class_2588)textContent).method_11022().equals(translationKey);
    }

    private static void shiftButtons(class_339 button, boolean shiftUp, int spacing) {
        if (shiftUp) {
            button.method_46419(button.method_46427() - spacing / 2);
        } else if (!button.method_25369().equals(class_442.field_32271)) {
            button.method_46419(button.method_46427() + spacing / 2);
        }
    }
}

