/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr.loader;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import net.coderbot.iris.Iris;
import net.coderbot.iris.mixin.texture.AnimatedTextureAccessor;
import net.coderbot.iris.mixin.texture.AnimationMetadataSectionAccessor;
import net.coderbot.iris.mixin.texture.FrameInfoAccessor;
import net.coderbot.iris.mixin.texture.SpriteContentsAccessor;
import net.coderbot.iris.mixin.texture.TextureAtlasAccessor;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.mipmap.ChannelMipmapGenerator;
import net.coderbot.iris.texture.mipmap.CustomMipmapGenerator;
import net.coderbot.iris.texture.mipmap.LinearBlendFunction;
import net.coderbot.iris.texture.pbr.PBRAtlasTexture;
import net.coderbot.iris.texture.pbr.PBRSpriteHolder;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.SpriteContentsExtension;
import net.coderbot.iris.texture.pbr.TextureAtlasExtension;
import net.coderbot.iris.texture.pbr.loader.PBRTextureLoader;
import net.coderbot.iris.texture.util.ImageManipulationUtil;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import org.jetbrains.annotations.Nullable;

public class AtlasPBRLoader
implements PBRTextureLoader<class_1059> {
    public static final ChannelMipmapGenerator LINEAR_MIPMAP_GENERATOR = new ChannelMipmapGenerator(LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE);
    private Object2ObjectMap<class_1059, PBRAtlasTexture> normalAtlases = new Object2ObjectOpenHashMap();
    private Object2ObjectMap<class_1059, PBRAtlasTexture> specularAtlases = new Object2ObjectOpenHashMap();

    public void removeAtlasInformation(class_1059 class_10592) {
        this.normalAtlases.remove((Object)class_10592);
        this.specularAtlases.remove((Object)class_10592);
    }

    @Override
    public void load(class_1059 class_10592, class_3300 class_33002, PBRTextureLoader.PBRTextureConsumer pBRTextureConsumer) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.normalAtlases.containsKey((Object)class_10592)) {
            pBRTextureConsumer.acceptNormalTexture((class_1044)this.normalAtlases.get((Object)class_10592));
            bl = true;
        }
        if (this.specularAtlases.containsKey((Object)class_10592)) {
            pBRTextureConsumer.acceptNormalTexture((class_1044)this.specularAtlases.get((Object)class_10592));
            bl2 = true;
        }
        int n = ((TextureAtlasExtension)class_10592).getWidth();
        int n2 = ((TextureAtlasExtension)class_10592).getHeight();
        int n3 = AtlasPBRLoader.fetchAtlasMipLevel(class_10592);
        Object object2 = ((TextureAtlasAccessor)class_10592).getTexturesByName().values().iterator();
        while (object2.hasNext()) {
            PBRSpriteHolder pBRSpriteHolder;
            class_1058 class_10582;
            class_1058 class_10583 = object2.next();
            if (!bl && (class_10582 = this.createPBRSprite(class_10583, class_33002, class_10592, n, n2, n3, PBRType.NORMAL)) != null) {
                ((PBRAtlasTexture)((Object)this.normalAtlases.computeIfAbsent((Object)class_10592, object -> new PBRAtlasTexture(class_10592, PBRType.NORMAL)))).addSprite(class_10582);
                pBRSpriteHolder = ((SpriteContentsExtension)class_10583.method_45851()).getOrCreatePBRHolder();
                pBRSpriteHolder.setNormalSprite(class_10582);
            }
            if (bl2 || (class_10582 = this.createPBRSprite(class_10583, class_33002, class_10592, n, n2, n3, PBRType.SPECULAR)) == null) continue;
            ((PBRAtlasTexture)((Object)this.specularAtlases.computeIfAbsent((Object)class_10592, object -> new PBRAtlasTexture(class_10592, PBRType.SPECULAR)))).addSprite(class_10582);
            pBRSpriteHolder = ((SpriteContentsExtension)class_10583.method_45851()).getOrCreatePBRHolder();
            pBRSpriteHolder.setSpecularSprite(class_10582);
        }
        if (this.normalAtlases.containsKey((Object)class_10592) && ((PBRAtlasTexture)((Object)(object2 = (PBRAtlasTexture)((Object)this.normalAtlases.get((Object)class_10592))))).tryUpload(n, n2, n3)) {
            pBRTextureConsumer.acceptNormalTexture((class_1044)object2);
        }
        if (this.specularAtlases.containsKey((Object)class_10592) && ((PBRAtlasTexture)((Object)(object2 = (PBRAtlasTexture)((Object)this.specularAtlases.get((Object)class_10592))))).tryUpload(n, n2, n3)) {
            pBRTextureConsumer.acceptSpecularTexture((class_1044)object2);
        }
    }

    protected static int fetchAtlasMipLevel(class_1059 class_10592) {
        class_1058 class_10582 = class_10592.method_4608(class_1047.method_4539());
        return ((SpriteContentsAccessor)class_10582.method_45851()).getMainImage().length - 1;
    }

    @Nullable
    protected class_1058 createPBRSprite(class_1058 class_10582, class_3300 class_33002, class_1059 class_10592, int n, int n2, int n3, PBRType pBRType) {
        class_2960 class_29602 = class_10582.method_45851().method_45816();
        class_2960 class_29603 = pBRType.appendToFileLocation(class_29602, true);
        PBRTextureAtlasSprite pBRTextureAtlasSprite = null;
        Optional optional = class_33002.method_14486(class_29603);
        if (optional.isPresent()) {
            try (InputStream inputStream = ((class_3298)optional.get()).method_14482();){
                int n4;
                int n5;
                class_1011 class_10112 = class_1011.method_4309((InputStream)inputStream);
                class_1079 class_10792 = ((class_3298)optional.get()).method_14481().method_43041((class_3270)class_1079.field_5337).orElse(class_1079.field_21768);
                class_7771 class_77712 = class_10792.method_24143(class_10112.method_4307(), class_10112.method_4323());
                int n6 = class_77712.comp_1049();
                int n7 = class_77712.comp_1050();
                int n8 = class_10582.method_45851().method_45807();
                int n9 = class_10582.method_45851().method_45815();
                if (n6 != n8 || n7 != n9) {
                    int n10 = class_10112.method_4307();
                    int n11 = class_10112.method_4323();
                    n5 = n10 / n6 * n8;
                    n4 = n11 / n7 * n9;
                    class_1011 class_10113 = n5 % n10 == 0 && n4 % n11 == 0 ? ImageManipulationUtil.scaleNearestNeighbor(class_10112, n5, n4) : ImageManipulationUtil.scaleBilinear(class_10112, n5, n4);
                    class_10112.close();
                    class_10112 = class_10113;
                    n6 = n8;
                    n7 = n9;
                    if (class_10792 != class_1079.field_21768) {
                        AnimationMetadataSectionAccessor animationMetadataSectionAccessor = (AnimationMetadataSectionAccessor)class_10792;
                        int n12 = animationMetadataSectionAccessor.getFrameWidth();
                        int n13 = animationMetadataSectionAccessor.getFrameHeight();
                        if (n12 != -1) {
                            animationMetadataSectionAccessor.setFrameWidth(n6);
                        }
                        if (n13 != -1) {
                            animationMetadataSectionAccessor.setFrameHeight(n7);
                        }
                    }
                }
                class_2960 class_29604 = new class_2960(class_29602.method_12836(), class_29602.method_12832() + pBRType.getSuffix());
                PBRTextureAtlasSpriteInfo pBRTextureAtlasSpriteInfo = new PBRTextureAtlasSpriteInfo(class_29604, n6, n7, class_10792, pBRType, class_10112);
                n5 = class_10582.method_35806();
                n4 = class_10582.method_35807();
                pBRTextureAtlasSpriteInfo.method_45808(n3);
                pBRTextureAtlasSprite = new PBRTextureAtlasSprite(class_29604, pBRTextureAtlasSpriteInfo, n, n2, n5, n4);
                this.syncAnimation(this.createAndReturnAtlas(class_10592, pBRType), class_10582, pBRTextureAtlasSprite);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Iris.logger.error("Unable to find file from {} : {}", class_29603, fileNotFoundException);
            }
            catch (RuntimeException runtimeException) {
                Iris.logger.error("Unable to parse metadata from {} : {}", class_29603, runtimeException);
            }
            catch (IOException iOException) {
                Iris.logger.error("Unable to load {} : {}", class_29603, iOException);
            }
        }
        return pBRTextureAtlasSprite;
    }

    private PBRAtlasTexture createAndReturnAtlas(class_1059 class_10592, PBRType pBRType) {
        if (pBRType == PBRType.NORMAL) {
            return (PBRAtlasTexture)((Object)this.normalAtlases.computeIfAbsent((Object)class_10592, object -> new PBRAtlasTexture(class_10592, PBRType.NORMAL)));
        }
        if (pBRType == PBRType.SPECULAR) {
            return (PBRAtlasTexture)((Object)this.specularAtlases.computeIfAbsent((Object)class_10592, object -> new PBRAtlasTexture(class_10592, PBRType.SPECULAR)));
        }
        throw new IllegalStateException("Unknown PBR Type: " + pBRType);
    }

    protected void syncAnimation(PBRAtlasTexture pBRAtlasTexture, class_1058 class_10582, class_1058 class_10583) {
        int n;
        int n2;
        class_7764.class_5790 class_57902 = ((SpriteContentsAccessor)class_10582.method_45851()).getAnimatedTexture();
        class_7764.class_5790 class_57903 = ((SpriteContentsAccessor)class_10583.method_45851()).getAnimatedTexture();
        if (!(class_57902 instanceof AnimatedTextureAccessor) || !(class_57903 instanceof AnimatedTextureAccessor)) {
            return;
        }
        AnimatedTextureAccessor animatedTextureAccessor = (AnimatedTextureAccessor)class_57902;
        int n3 = 0;
        for (int i = 0; i < animatedTextureAccessor.getFrames().size(); ++i) {
            n3 += ((FrameInfoAccessor)animatedTextureAccessor.getFrames().get(i)).getTime();
        }
        AnimatedTextureAccessor animatedTextureAccessor2 = (AnimatedTextureAccessor)class_57903;
        List<class_7764.class_5791> list = animatedTextureAccessor2.getFrames();
        int n4 = 0;
        int n5 = list.size();
        for (n2 = 0; n2 < n5; ++n2) {
            n4 += ((FrameInfoAccessor)list.get(n2)).getTime();
        }
        n3 %= n4;
        n2 = 0;
        while (n3 >= (n = ((FrameInfoAccessor)list.get(n2)).getTime())) {
            ++n2;
            n3 -= n;
        }
        pBRAtlasTexture.setFrameOnSprite(class_10583, n2);
        pBRAtlasTexture.setSubFrameOnSprite(class_10583, n3 + pBRAtlasTexture.getSubFrameFromSprite(class_10582));
    }

    protected static class PBRTextureAtlasSpriteInfo
    extends class_7764
    implements CustomMipmapGenerator.Provider {
        protected final PBRType pbrType;

        public PBRTextureAtlasSpriteInfo(class_2960 class_29602, int n, int n2, class_1079 class_10792, PBRType pBRType, class_1011 class_10112) {
            super(class_29602, new class_7771(n, n2), class_10112, class_10792);
            this.pbrType = pBRType;
        }

        @Override
        public CustomMipmapGenerator getMipmapGenerator() {
            CustomMipmapGenerator customMipmapGenerator;
            PBRType pBRType = this.pbrType;
            TextureFormat textureFormat = TextureFormatLoader.getFormat();
            if (textureFormat != null && (customMipmapGenerator = textureFormat.getMipmapGenerator(pBRType)) != null) {
                return customMipmapGenerator;
            }
            return LINEAR_MIPMAP_GENERATOR;
        }
    }

    public static class PBRTextureAtlasSprite
    extends class_1058 {
        protected PBRTextureAtlasSprite(class_2960 class_29602, class_7764 class_77642, int n, int n2, int n3, int n4) {
            super(class_29602, class_77642, n, n2, n3, n4);
        }
    }
}

