/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.discovery;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.coderbot.iris.Iris;

public class ShaderpackDirectoryManager {
    private final Path root;

    public ShaderpackDirectoryManager(Path path) {
        this.root = path;
    }

    public void copyPackIntoDirectory(String string, Path path2) throws IOException {
        Path path3 = Iris.getShaderpacksDirectory().resolve(string);
        Files.copy(path2, path3, new CopyOption[0]);
        if (Files.isDirectory(path2, new LinkOption[0])) {
            Path path4;
            try (Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);){
                for (Path path5 : stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).collect(Collectors.toList())) {
                    path4 = path2.relativize(path5);
                    if (Files.exists(path4, new LinkOption[0])) continue;
                    Files.createDirectory(path3.resolve(path4), new FileAttribute[0]);
                }
            }
            stream = Files.walk(path2, new FileVisitOption[0]);
            try {
                for (Path path5 : stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).collect(Collectors.toSet())) {
                    path4 = path2.relativize(path5);
                    Files.copy(path5, path3.resolve(path4), new CopyOption[0]);
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
    }

    public Collection<String> enumerate() throws IOException {
        Comparator comparator = String.CASE_INSENSITIVE_ORDER.thenComparing(Comparator.naturalOrder());
        Comparator comparator2 = (string, string2) -> {
            string = ShaderpackDirectoryManager.removeFormatting(string);
            string2 = ShaderpackDirectoryManager.removeFormatting(string2);
            return comparator.compare(string, string2);
        };
        try (Stream<Path> stream = Files.list(this.root);){
            Collection collection = stream.filter(Iris::isValidShaderpack).map(path -> path.getFileName().toString()).sorted(comparator2).collect(Collectors.toList());
            return collection;
        }
    }

    private static String removeFormatting(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\u00a7') {
                ++i;
                continue;
            }
            cArray2[n++] = cArray[i];
        }
        return new String(cArray2, 0, n);
    }

    public URI getDirectoryUri() {
        return this.root.toUri();
    }
}

